/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.http;

import java.io.File;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.Servlet;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletException;
import org.apache.jasper.servlet.JasperInitializer;
import org.apache.tomcat.InstanceManager;
import org.apache.tomcat.SimpleInstanceManager;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.plus.annotation.ContainerInitializer;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.ForwardedRequestCustomizer;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlets.AsyncGzipFilter;
import org.eclipse.jetty.spdy.server.http.HTTPSPDYServerConnector;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.webapp.WebAppContext;
import org.jivesoftware.openfire.Connection;
import org.jivesoftware.openfire.JMXManager;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.http.FlashCrossDomainServlet;
import org.jivesoftware.openfire.http.HttpBindServlet;
import org.jivesoftware.openfire.http.HttpSessionManager;
import org.jivesoftware.openfire.keystore.CertificateStore;
import org.jivesoftware.openfire.keystore.IdentityStore;
import org.jivesoftware.openfire.spi.ConnectionConfiguration;
import org.jivesoftware.openfire.spi.ConnectionManagerImpl;
import org.jivesoftware.openfire.spi.ConnectionType;
import org.jivesoftware.openfire.spi.EncryptionArtifactFactory;
import org.jivesoftware.openfire.websocket.OpenfireWebSocketServlet;
import org.jivesoftware.util.CertificateEventListener;
import org.jivesoftware.util.CertificateManager;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.PropertyEventDispatcher;
import org.jivesoftware.util.PropertyEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpBindManager
implements CertificateEventListener,
PropertyEventListener {
    private static final Logger Log = LoggerFactory.getLogger(HttpBindManager.class);
    public static final String HTTP_BIND_ENABLED = "httpbind.enabled";
    public static final boolean HTTP_BIND_ENABLED_DEFAULT = true;
    public static final String HTTP_BIND_PORT = "httpbind.port.plain";
    public static final int HTTP_BIND_PORT_DEFAULT = 7070;
    public static final String HTTP_BIND_SECURE_PORT = "httpbind.port.secure";
    public static final int HTTP_BIND_SECURE_PORT_DEFAULT = 7443;
    public static final String HTTP_BIND_THREADS = "httpbind.client.processing.threads";
    public static final String HTTP_BIND_AUTH_PER_CLIENTCERT_POLICY = "httpbind.client.cert.policy";
    public static final int HTTP_BIND_THREADS_DEFAULT = 200;
    private static final String HTTP_BIND_FORWARDED = "httpbind.forwarded.enabled";
    private static final String HTTP_BIND_FORWARDED_FOR = "httpbind.forwarded.for.header";
    private static final String HTTP_BIND_FORWARDED_SERVER = "httpbind.forwarded.server.header";
    private static final String HTTP_BIND_FORWARDED_HOST = "httpbind.forwarded.host.header";
    private static final String HTTP_BIND_FORWARDED_HOST_NAME = "httpbind.forwarded.host.name";
    public static final String HTTP_BIND_CORS_ENABLED = "httpbind.CORS.enabled";
    public static final boolean HTTP_BIND_CORS_ENABLED_DEFAULT = true;
    public static final String HTTP_BIND_CORS_ALLOW_ORIGIN = "httpbind.CORS.domains";
    public static final String HTTP_BIND_CORS_ALLOW_ORIGIN_DEFAULT = "*";
    public static final String HTTP_BIND_CORS_ALLOW_METHODS_DEFAULT = "PROPFIND, PROPPATCH, COPY, MOVE, DELETE, MKCOL, LOCK, UNLOCK, PUT, GETLIB, VERSION-CONTROL, CHECKIN, CHECKOUT, UNCHECKOUT, REPORT, UPDATE, CANCELUPLOAD, HEAD, OPTIONS, GET, POST";
    public static final String HTTP_BIND_CORS_ALLOW_HEADERS_DEFAULT = "Overwrite, Destination, Content-Type, Depth, User-Agent, X-File-Size, X-Requested-With, If-Modified-Since, X-File-Name, Cache-Control";
    public static final String HTTP_BIND_CORS_MAX_AGE_DEFAULT = "86400";
    public static final String HTTP_BIND_REQUEST_HEADER_SIZE = "httpbind.request.header.size";
    public static final int HTTP_BIND_REQUEST_HEADER_SIZE_DEFAULT = 32768;
    public static Map<String, Boolean> HTTP_BIND_ALLOWED_ORIGINS = new HashMap<String, Boolean>();
    private static HttpBindManager instance = new HttpBindManager();
    private Server httpBindServer;
    private final HttpSessionManager httpSessionManager;
    private final HandlerList handlerList = new HandlerList();
    private final HandlerCollection extensionHandlers = new HandlerCollection(true);

    public static HttpBindManager getInstance() {
        return instance;
    }

    private HttpBindManager() {
        JiveGlobals.migrateProperty(HTTP_BIND_ENABLED);
        JiveGlobals.migrateProperty(HTTP_BIND_PORT);
        JiveGlobals.migrateProperty(HTTP_BIND_SECURE_PORT);
        JiveGlobals.migrateProperty(HTTP_BIND_THREADS);
        JiveGlobals.migrateProperty(HTTP_BIND_FORWARDED);
        JiveGlobals.migrateProperty(HTTP_BIND_FORWARDED_FOR);
        JiveGlobals.migrateProperty(HTTP_BIND_FORWARDED_SERVER);
        JiveGlobals.migrateProperty(HTTP_BIND_FORWARDED_HOST);
        JiveGlobals.migrateProperty(HTTP_BIND_FORWARDED_HOST_NAME);
        JiveGlobals.migrateProperty(HTTP_BIND_CORS_ENABLED);
        JiveGlobals.migrateProperty(HTTP_BIND_CORS_ALLOW_ORIGIN);
        JiveGlobals.migrateProperty(HTTP_BIND_REQUEST_HEADER_SIZE);
        PropertyEventDispatcher.addListener(this);
        this.httpSessionManager = new HttpSessionManager();
        this.setupAllowedOriginsMap();
        this.handlerList.addHandler(this.createBoshHandler());
        this.handlerList.addHandler(this.createWebsocketHandler());
        this.handlerList.addHandler(this.createCrossDomainHandler());
        this.handlerList.addHandler((Handler)this.extensionHandlers);
        Handler staticContentHandler = this.createStaticContentHandler();
        if (staticContentHandler != null) {
            this.handlerList.addHandler(staticContentHandler);
        }
    }

    public void start() {
        if (!this.isHttpBindServiceEnabled()) {
            return;
        }
        int processingThreads = JiveGlobals.getIntProperty(HTTP_BIND_THREADS, 200);
        QueuedThreadPool tp = new QueuedThreadPool(processingThreads);
        tp.setName("Jetty-QTP-BOSH");
        this.httpBindServer = new Server((ThreadPool)tp);
        if (JMXManager.isEnabled()) {
            JMXManager jmx = JMXManager.getInstance();
            this.httpBindServer.addBean((Object)jmx.getContainer());
        }
        Connector httpConnector = this.createConnector(this.httpBindServer);
        Connector httpsConnector = this.createSSLConnector(this.httpBindServer);
        if (httpConnector == null && httpsConnector == null) {
            this.httpBindServer = null;
            return;
        }
        if (httpConnector != null) {
            this.httpBindServer.addConnector(httpConnector);
        }
        if (httpsConnector != null) {
            this.httpBindServer.addConnector(httpsConnector);
        }
        this.httpBindServer.setHandler((Handler)this.handlerList);
        try {
            this.httpBindServer.start();
            this.handlerList.start();
            this.extensionHandlers.start();
            CertificateManager.addListener(this);
            Log.info("HTTP bind service started");
        }
        catch (Exception e) {
            Log.error("Error starting HTTP bind service", (Throwable)e);
        }
    }

    public void stop() {
        CertificateManager.removeListener(this);
        if (this.httpBindServer != null) {
            try {
                this.handlerList.stop();
                this.extensionHandlers.stop();
                this.httpBindServer.stop();
                Log.info("HTTP bind service stopped");
            }
            catch (Exception e) {
                Log.error("Error stopping HTTP bind service", (Throwable)e);
            }
            this.httpBindServer = null;
        }
    }

    public HttpSessionManager getSessionManager() {
        return this.httpSessionManager;
    }

    private boolean isHttpBindServiceEnabled() {
        return JiveGlobals.getBooleanProperty(HTTP_BIND_ENABLED, true);
    }

    private Connector createConnector(Server httpBindServer) {
        int port = this.getHttpBindUnsecurePort();
        if (port > 0) {
            HttpConfiguration httpConfig = new HttpConfiguration();
            this.configureProxiedConnector(httpConfig);
            ServerConnector connector = new ServerConnector(httpBindServer, new ConnectionFactory[]{new HttpConnectionFactory(httpConfig)});
            connector.setHost(this.getBindInterface());
            connector.setPort(port);
            return connector;
        }
        return null;
    }

    private Connector createSSLConnector(Server httpBindServer) {
        int securePort = this.getHttpBindSecurePort();
        try {
            IdentityStore identityStore = XMPPServer.getInstance().getCertificateStoreManager().getIdentityStore(ConnectionType.BOSH_C2S);
            if (securePort > 0 && identityStore.getStore().aliases().hasMoreElements()) {
                if (!identityStore.containsDomainCertificate("RSA")) {
                    Log.warn("HTTP binding: Using RSA certificates but they are not valid for the hosted domain");
                }
                ConnectionManagerImpl connectionManager = (ConnectionManagerImpl)XMPPServer.getInstance().getConnectionManager();
                ConnectionConfiguration configuration = connectionManager.getListener(ConnectionType.BOSH_C2S, true).generateConnectionConfiguration();
                SslContextFactory sslContextFactory = new EncryptionArtifactFactory(configuration).getSslContextFactory();
                HttpConfiguration httpsConfig = new HttpConfiguration();
                httpsConfig.setSecureScheme("https");
                httpsConfig.setSecurePort(securePort);
                this.configureProxiedConnector(httpsConfig);
                httpsConfig.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
                Object sslConnector = "npn".equals(JiveGlobals.getXMLProperty("spdy.protocol", "")) ? new HTTPSPDYServerConnector(httpBindServer, sslContextFactory) : new ServerConnector(httpBindServer, new ConnectionFactory[]{new SslConnectionFactory(sslContextFactory, "http/1.1"), new HttpConnectionFactory(httpsConfig)});
                sslConnector.setHost(this.getBindInterface());
                sslConnector.setPort(securePort);
                return sslConnector;
            }
        }
        catch (Exception e) {
            Log.error("Error creating SSL connector for Http bind", (Throwable)e);
        }
        return null;
    }

    private void configureProxiedConnector(HttpConfiguration httpConfig) {
        if (this.isXFFEnabled()) {
            String hostName;
            String forwardedHostHeader;
            String forwardedServerHeader;
            ForwardedRequestCustomizer customizer = new ForwardedRequestCustomizer();
            String forwardedForHeader = this.getXFFHeader();
            if (forwardedForHeader != null) {
                customizer.setForwardedForHeader(forwardedForHeader);
            }
            if ((forwardedServerHeader = this.getXFFServerHeader()) != null) {
                customizer.setForwardedServerHeader(forwardedServerHeader);
            }
            if ((forwardedHostHeader = this.getXFFHostHeader()) != null) {
                customizer.setForwardedHostHeader(forwardedHostHeader);
            }
            if ((hostName = this.getXFFHostName()) != null) {
                customizer.setHostHeader(hostName);
            }
            httpConfig.addCustomizer((HttpConfiguration.Customizer)customizer);
        }
        httpConfig.setRequestHeaderSize(JiveGlobals.getIntProperty(HTTP_BIND_REQUEST_HEADER_SIZE, 32768));
    }

    private String getBindInterface() {
        String interfaceName = JiveGlobals.getXMLProperty("network.interface");
        String bindInterface = null;
        if (interfaceName != null && interfaceName.trim().length() > 0) {
            bindInterface = interfaceName;
        }
        return bindInterface;
    }

    public boolean isHttpBindEnabled() {
        return this.httpBindServer != null && this.httpBindServer.isRunning();
    }

    public boolean isHttpBindActive() {
        if (this.isHttpBindEnabled()) {
            int configuredPort = this.getHttpBindUnsecurePort();
            for (Connector connector : this.httpBindServer.getConnectors()) {
                int activePort;
                if (!(connector instanceof ServerConnector) || (activePort = ((ServerConnector)connector).getLocalPort()) != configuredPort) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isHttpsBindActive() {
        if (this.isHttpBindEnabled()) {
            int configuredPort = this.getHttpBindSecurePort();
            for (Connector connector : this.httpBindServer.getConnectors()) {
                int activePort;
                if (!(connector instanceof ServerConnector) || (activePort = ((ServerConnector)connector).getLocalPort()) != configuredPort) continue;
                return true;
            }
        }
        return false;
    }

    public String getHttpBindUnsecureAddress() {
        return "http://" + XMPPServer.getInstance().getServerInfo().getHostname() + ":" + this.getHttpBindUnsecurePort() + "/http-bind/";
    }

    public String getHttpBindSecureAddress() {
        return "https://" + XMPPServer.getInstance().getServerInfo().getHostname() + ":" + this.getHttpBindSecurePort() + "/http-bind/";
    }

    public String getJavaScriptUrl() {
        return "http://" + XMPPServer.getInstance().getServerInfo().getHostname() + ":" + this.getHttpBindUnsecurePort() + "/scripts/";
    }

    private void setupAllowedOriginsMap() {
        String originString = this.getCORSAllowOrigin();
        if (!originString.equals(HTTP_BIND_CORS_ALLOW_ORIGIN_DEFAULT)) {
            String[] origins = originString.split(",");
            HTTP_BIND_ALLOWED_ORIGINS.clear();
            for (String str : origins) {
                HTTP_BIND_ALLOWED_ORIGINS.put(str, true);
            }
        }
    }

    public boolean isCORSEnabled() {
        return JiveGlobals.getBooleanProperty(HTTP_BIND_CORS_ENABLED, true);
    }

    public void setCORSEnabled(Boolean value) {
        if (value != null) {
            JiveGlobals.setProperty(HTTP_BIND_CORS_ENABLED, String.valueOf(value));
        }
    }

    public String getCORSAllowOrigin() {
        return JiveGlobals.getProperty(HTTP_BIND_CORS_ALLOW_ORIGIN, HTTP_BIND_CORS_ALLOW_ORIGIN_DEFAULT);
    }

    public void setCORSAllowOrigin(String origins) {
        origins = origins == null || origins.trim().length() == 0 ? HTTP_BIND_CORS_ALLOW_ORIGIN_DEFAULT : origins.replaceAll("\\s+", "");
        JiveGlobals.setProperty(HTTP_BIND_CORS_ALLOW_ORIGIN, origins);
        this.setupAllowedOriginsMap();
    }

    public boolean isAllOriginsAllowed() {
        return HTTP_BIND_CORS_ALLOW_ORIGIN_DEFAULT.equals(this.getCORSAllowOrigin());
    }

    public boolean isThisOriginAllowed(String origin) {
        return this.isAllOriginsAllowed() || HTTP_BIND_ALLOWED_ORIGINS.get(origin) != null;
    }

    public boolean isXFFEnabled() {
        return JiveGlobals.getBooleanProperty(HTTP_BIND_FORWARDED, false);
    }

    public void setXFFEnabled(boolean enabled) {
        JiveGlobals.setProperty(HTTP_BIND_FORWARDED, String.valueOf(enabled));
    }

    public String getXFFHeader() {
        return JiveGlobals.getProperty(HTTP_BIND_FORWARDED_FOR);
    }

    public void setXFFHeader(String header) {
        if (header == null || header.trim().length() == 0) {
            JiveGlobals.deleteProperty(HTTP_BIND_FORWARDED_FOR);
        } else {
            JiveGlobals.setProperty(HTTP_BIND_FORWARDED_FOR, header);
        }
    }

    public String getXFFServerHeader() {
        return JiveGlobals.getProperty(HTTP_BIND_FORWARDED_SERVER);
    }

    public void setXFFServerHeader(String header) {
        if (header == null || header.trim().length() == 0) {
            JiveGlobals.deleteProperty(HTTP_BIND_FORWARDED_SERVER);
        } else {
            JiveGlobals.setProperty(HTTP_BIND_FORWARDED_SERVER, header);
        }
    }

    public String getXFFHostHeader() {
        return JiveGlobals.getProperty(HTTP_BIND_FORWARDED_HOST);
    }

    public void setXFFHostHeader(String header) {
        if (header == null || header.trim().length() == 0) {
            JiveGlobals.deleteProperty(HTTP_BIND_FORWARDED_HOST);
        } else {
            JiveGlobals.setProperty(HTTP_BIND_FORWARDED_HOST, header);
        }
    }

    public String getXFFHostName() {
        return JiveGlobals.getProperty(HTTP_BIND_FORWARDED_HOST_NAME);
    }

    public void setXFFHostName(String name) {
        if (name == null || name.trim().length() == 0) {
            JiveGlobals.deleteProperty(HTTP_BIND_FORWARDED_HOST_NAME);
        } else {
            JiveGlobals.setProperty(HTTP_BIND_FORWARDED_HOST_NAME, name);
        }
    }

    public void setHttpBindEnabled(boolean isEnabled) {
        JiveGlobals.setProperty(HTTP_BIND_ENABLED, String.valueOf(isEnabled));
    }

    public void setHttpBindPorts(int unsecurePort, int securePort) throws Exception {
        if (unsecurePort != 7070) {
            JiveGlobals.setProperty(HTTP_BIND_PORT, String.valueOf(unsecurePort));
        } else {
            JiveGlobals.deleteProperty(HTTP_BIND_PORT);
        }
        if (securePort != 7443) {
            JiveGlobals.setProperty(HTTP_BIND_SECURE_PORT, String.valueOf(securePort));
        } else {
            JiveGlobals.deleteProperty(HTTP_BIND_SECURE_PORT);
        }
    }

    protected Handler createBoshHandler() {
        ServletContextHandler context = new ServletContextHandler(null, "/http-bind", 1);
        ArrayList<ContainerInitializer> initializers = new ArrayList<ContainerInitializer>();
        initializers.add(new ContainerInitializer((ServletContainerInitializer)new JasperInitializer(), null));
        context.setAttribute("org.eclipse.jetty.containerInitializers", initializers);
        context.setAttribute(InstanceManager.class.getName(), (Object)new SimpleInstanceManager());
        context.setAllowNullPathInfo(true);
        context.addServlet(new ServletHolder((Servlet)new HttpBindServlet()), "/*");
        if (this.isHttpCompressionEnabled()) {
            AsyncGzipFilter gzipFilter = new AsyncGzipFilter(){

                public void init(FilterConfig config) throws ServletException {
                    super.init(config);
                    this._methods.add(HttpMethod.POST.asString());
                    Log.info("Installed response compression filter");
                }
            };
            FilterHolder filterHolder = new FilterHolder();
            filterHolder.setFilter((Filter)gzipFilter);
            context.addFilter(filterHolder, "/*", EnumSet.of(DispatcherType.REQUEST));
        }
        return context;
    }

    protected Handler createWebsocketHandler() {
        ServletContextHandler context = new ServletContextHandler(null, "/ws", 1);
        context.addServlet(new ServletHolder((Servlet)new OpenfireWebSocketServlet()), "/*");
        return context;
    }

    private boolean isHttpCompressionEnabled() {
        ConnectionManagerImpl connectionManager = (ConnectionManagerImpl)XMPPServer.getInstance().getConnectionManager();
        ConnectionConfiguration configuration = connectionManager.getListener(ConnectionType.BOSH_C2S, true).generateConnectionConfiguration();
        return configuration.getCompressionPolicy() == null || configuration.getCompressionPolicy().equals((Object)Connection.CompressionPolicy.optional);
    }

    protected Handler createCrossDomainHandler() {
        ServletContextHandler context = new ServletContextHandler(null, "/crossdomain.xml", 1);
        ArrayList<ContainerInitializer> initializers = new ArrayList<ContainerInitializer>();
        initializers.add(new ContainerInitializer((ServletContainerInitializer)new JasperInitializer(), null));
        context.setAttribute("org.eclipse.jetty.containerInitializers", initializers);
        context.setAttribute(InstanceManager.class.getName(), (Object)new SimpleInstanceManager());
        context.setAllowNullPathInfo(true);
        context.addServlet(new ServletHolder((Servlet)new FlashCrossDomainServlet()), "");
        return context;
    }

    protected Handler createStaticContentHandler() {
        File spankDirectory = new File(JiveGlobals.getHomeDirectory() + File.separator + "resources" + File.separator + "spank");
        if (spankDirectory.exists()) {
            if (spankDirectory.canRead()) {
                WebAppContext context = new WebAppContext(null, spankDirectory.getPath(), "/");
                context.setWelcomeFiles(new String[]{"index.html"});
                return context;
            }
            Log.warn("Openfire cannot read the directory: " + spankDirectory);
        }
        return null;
    }

    public void addJettyHandler(Handler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("Argument 'handler' cannot be null.");
        }
        this.extensionHandlers.addHandler(handler);
        if (!handler.isStarted() && this.extensionHandlers.isStarted()) {
            try {
                handler.start();
            }
            catch (Exception e) {
                Log.warn("Unable to start handler {}", (Object)handler, (Object)e);
            }
        }
    }

    public void removeJettyHandler(Handler handler) {
        this.extensionHandlers.removeHandler(handler);
        if (handler.isStarted()) {
            try {
                handler.stop();
            }
            catch (Exception e) {
                Log.warn("Unable to stop the handler that was removed: {}", (Object)handler, (Object)e);
            }
        }
    }

    private void doEnableHttpBind(boolean shouldEnable) {
        if (shouldEnable && this.httpBindServer == null) {
            this.start();
        } else if (!shouldEnable && this.httpBindServer != null) {
            this.stop();
        }
    }

    public int getHttpBindUnsecurePort() {
        return JiveGlobals.getIntProperty(HTTP_BIND_PORT, 7070);
    }

    public int getHttpBindSecurePort() {
        return JiveGlobals.getIntProperty(HTTP_BIND_SECURE_PORT, 7443);
    }

    public boolean isScriptSyntaxEnabled() {
        return JiveGlobals.getBooleanProperty("xmpp.httpbind.scriptSyntax.enabled", false);
    }

    public void setScriptSyntaxEnabled(boolean isEnabled) {
        String property = "xmpp.httpbind.scriptSyntax.enabled";
        if (!isEnabled) {
            JiveGlobals.deleteProperty("xmpp.httpbind.scriptSyntax.enabled");
        } else {
            JiveGlobals.setProperty("xmpp.httpbind.scriptSyntax.enabled", String.valueOf(isEnabled));
        }
    }

    private synchronized void restartServer() {
        this.stop();
        this.start();
    }

    @Override
    public void propertySet(String property, Map<String, Object> params) {
        if (property.equalsIgnoreCase(HTTP_BIND_ENABLED)) {
            this.doEnableHttpBind(Boolean.valueOf(params.get("value").toString()));
        } else if (property.equalsIgnoreCase(HTTP_BIND_PORT)) {
            try {
                Integer.valueOf(params.get("value").toString());
            }
            catch (NumberFormatException ne) {
                JiveGlobals.deleteProperty(HTTP_BIND_PORT);
                return;
            }
            this.restartServer();
        } else if (property.equalsIgnoreCase(HTTP_BIND_SECURE_PORT)) {
            try {
                Integer.valueOf(params.get("value").toString());
            }
            catch (NumberFormatException ne) {
                JiveGlobals.deleteProperty(HTTP_BIND_SECURE_PORT);
                return;
            }
            this.restartServer();
        } else if (HTTP_BIND_AUTH_PER_CLIENTCERT_POLICY.equalsIgnoreCase(property)) {
            this.restartServer();
        }
    }

    @Override
    public void propertyDeleted(String property, Map<String, Object> params) {
        if (property.equalsIgnoreCase(HTTP_BIND_ENABLED)) {
            this.doEnableHttpBind(true);
        } else if (property.equalsIgnoreCase(HTTP_BIND_PORT)) {
            this.restartServer();
        } else if (property.equalsIgnoreCase(HTTP_BIND_SECURE_PORT)) {
            this.restartServer();
        } else if (HTTP_BIND_AUTH_PER_CLIENTCERT_POLICY.equalsIgnoreCase(property)) {
            this.restartServer();
        }
    }

    @Override
    public void xmlPropertySet(String property, Map<String, Object> params) {
    }

    @Override
    public void xmlPropertyDeleted(String property, Map<String, Object> params) {
    }

    @Override
    public void storeContentChanged(CertificateStore store) {
        this.restartServer();
    }
}

