/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.handler;

import java.util.Collections;
import java.util.Iterator;
import org.dom4j.Element;
import org.jivesoftware.openfire.IQHandlerInfo;
import org.jivesoftware.openfire.PacketException;
import org.jivesoftware.openfire.PrivateStorage;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.disco.ServerFeaturesProvider;
import org.jivesoftware.openfire.handler.IQHandler;
import org.xmpp.packet.IQ;
import org.xmpp.packet.PacketError;

public class IQPrivateHandler
extends IQHandler
implements ServerFeaturesProvider {
    private IQHandlerInfo info = new IQHandlerInfo("query", "jabber:iq:private");
    private PrivateStorage privateStorage = null;

    public IQPrivateHandler() {
        super("XMPP Private Storage Handler");
    }

    @Override
    public IQ handleIQ(IQ packet) throws UnauthorizedException, PacketException {
        IQ replyPacket;
        Element child = packet.getChildElement();
        Element dataElement = (Element)child.elementIterator().next();
        if (dataElement != null) {
            if (IQ.Type.get.equals((Object)packet.getType())) {
                replyPacket = IQ.createResultIQ((IQ)packet);
                Element dataStored = this.privateStorage.get(packet.getFrom().getNode(), dataElement);
                dataStored.setParent(null);
                child.remove(dataElement);
                child.setParent(null);
                replyPacket.setChildElement(child);
                child.add(dataStored);
            } else {
                replyPacket = IQ.createResultIQ((IQ)packet);
                if (this.privateStorage.isEnabled()) {
                    this.privateStorage.add(packet.getFrom().getNode(), dataElement);
                } else {
                    replyPacket.setChildElement(packet.getChildElement().createCopy());
                    replyPacket.setError(PacketError.Condition.service_unavailable);
                }
            }
        } else {
            replyPacket = IQ.createResultIQ((IQ)packet);
            replyPacket.setChildElement("query", "jabber:iq:private");
        }
        return replyPacket;
    }

    @Override
    public void initialize(XMPPServer server) {
        super.initialize(server);
        this.privateStorage = server.getPrivateStorage();
    }

    @Override
    public IQHandlerInfo getInfo() {
        return this.info;
    }

    @Override
    public Iterator<String> getFeatures() {
        return Collections.singleton("jabber:iq:private").iterator();
    }
}

