/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.handler;

import java.util.Collections;
import java.util.Iterator;
import org.dom4j.Element;
import org.jivesoftware.openfire.IQHandlerInfo;
import org.jivesoftware.openfire.PresenceManager;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.disco.ServerFeaturesProvider;
import org.jivesoftware.openfire.handler.IQHandler;
import org.jivesoftware.openfire.user.User;
import org.jivesoftware.openfire.user.UserManager;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.xmpp.packet.IQ;
import org.xmpp.packet.PacketError;

public class IQLastActivityHandler
extends IQHandler
implements ServerFeaturesProvider {
    private static final String NAMESPACE = "jabber:iq:last";
    private final IQHandlerInfo info = new IQHandlerInfo("query", "jabber:iq:last");
    private PresenceManager presenceManager;

    public IQLastActivityHandler() {
        super("XMPP Last Activity Handler");
    }

    @Override
    public IQ handleIQ(IQ packet) throws UnauthorizedException {
        IQ reply = IQ.createResultIQ((IQ)packet);
        Element lastActivity = reply.setChildElement("query", NAMESPACE);
        String sender = packet.getFrom().getNode();
        if (sender == null) {
            reply.setError(PacketError.Condition.forbidden);
            return reply;
        }
        if (packet.getTo() != null && packet.getTo().getNode() == null && XMPPServer.getInstance().isLocal(packet.getTo())) {
            long uptime = XMPPServer.getInstance().getServerInfo().getLastStarted().getTime();
            long lastActivityTime = (System.currentTimeMillis() - uptime) / 1000L;
            lastActivity.addAttribute("seconds", String.valueOf(lastActivityTime));
            return reply;
        }
        String username = packet.getTo() == null ? packet.getFrom().getNode() : packet.getTo().getNode();
        try {
            if (username != null) {
                if (this.presenceManager.canProbePresence(packet.getFrom(), username)) {
                    if (this.sessionManager.getSessions(username).isEmpty()) {
                        User user = UserManager.getInstance().getUser(username);
                        long lastActivityTime = this.presenceManager.getLastActivity(user);
                        if (lastActivityTime > -1L) {
                            lastActivityTime /= 1000L;
                        }
                        lastActivity.addAttribute("seconds", String.valueOf(lastActivityTime));
                        String lastStatus = this.presenceManager.getLastPresenceStatus(user);
                        if (lastStatus != null && lastStatus.length() > 0) {
                            lastActivity.setText(lastStatus);
                        }
                    } else {
                        lastActivity.addAttribute("seconds", "0");
                    }
                } else {
                    reply.setError(PacketError.Condition.forbidden);
                }
            }
        }
        catch (UserNotFoundException e) {
            reply.setError(PacketError.Condition.forbidden);
        }
        return reply;
    }

    @Override
    public IQHandlerInfo getInfo() {
        return this.info;
    }

    @Override
    public Iterator<String> getFeatures() {
        return Collections.singleton(NAMESPACE).iterator();
    }

    @Override
    public void initialize(XMPPServer server) {
        super.initialize(server);
        this.presenceManager = server.getPresenceManager();
    }
}

