/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.group;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jivesoftware.openfire.group.Group;
import org.jivesoftware.openfire.group.GroupManager;
import org.jivesoftware.openfire.group.GroupNotFoundException;

public class GroupCollection
extends AbstractCollection<Group> {
    private String[] elements;

    public GroupCollection(Collection<String> collection) {
        this.elements = collection.toArray(new String[collection.size()]);
    }

    public GroupCollection(String[] elements) {
        this.elements = elements;
    }

    @Override
    public Iterator<Group> iterator() {
        return new GroupIterator();
    }

    @Override
    public int size() {
        return this.elements.length;
    }

    private class GroupIterator
    implements Iterator<Group> {
        private int currentIndex = -1;
        private Group nextElement = null;

        private GroupIterator() {
        }

        @Override
        public boolean hasNext() {
            if (this.currentIndex + 1 >= GroupCollection.this.elements.length && this.nextElement == null) {
                return false;
            }
            if (this.nextElement == null) {
                this.nextElement = this.getNextElement();
                if (this.nextElement == null) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public Group next() throws NoSuchElementException {
            Group element;
            if (this.nextElement != null) {
                element = this.nextElement;
                this.nextElement = null;
            } else {
                element = this.getNextElement();
                if (element == null) {
                    throw new NoSuchElementException();
                }
            }
            return element;
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        private Group getNextElement() {
            while (this.currentIndex + 1 < GroupCollection.this.elements.length) {
                ++this.currentIndex;
                Group element = null;
                try {
                    element = GroupManager.getInstance().getGroup(GroupCollection.this.elements[this.currentIndex]);
                }
                catch (GroupNotFoundException groupNotFoundException) {
                    // empty catch block
                }
                if (element == null) continue;
                return element;
            }
            return null;
        }
    }
}

