/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.group;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListSet;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.event.GroupEventDispatcher;
import org.jivesoftware.openfire.group.GroupAlreadyExistsException;
import org.jivesoftware.openfire.group.GroupJID;
import org.jivesoftware.openfire.group.GroupManager;
import org.jivesoftware.openfire.group.GroupNotFoundException;
import org.jivesoftware.openfire.group.GroupProvider;
import org.jivesoftware.util.PersistableMap;
import org.jivesoftware.util.cache.CacheSizes;
import org.jivesoftware.util.cache.Cacheable;
import org.jivesoftware.util.cache.CannotCalculateSizeException;
import org.jivesoftware.util.cache.ExternalizableUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;

public class Group
implements Cacheable,
Externalizable {
    private static final Logger Log = LoggerFactory.getLogger(Group.class);
    private transient GroupProvider provider;
    private transient GroupManager groupManager;
    private transient PersistableMap<String, String> properties;
    private transient GroupJID jid;
    private String name;
    private String description;
    private ConcurrentSkipListSet<JID> members;
    private ConcurrentSkipListSet<JID> administrators;

    public Group() {
    }

    public Group(String name, String description, Collection<JID> members, Collection<JID> administrators) {
        this.groupManager = GroupManager.getInstance();
        this.provider = this.groupManager.getProvider();
        this.name = name;
        this.description = description;
        this.members = new ConcurrentSkipListSet<JID>(members);
        this.administrators = new ConcurrentSkipListSet<JID>(administrators);
    }

    public Group(String name, String description, Collection<JID> members, Collection<JID> administrators, Map<String, String> properties) {
        this.groupManager = GroupManager.getInstance();
        this.provider = this.groupManager.getProvider();
        this.name = name;
        this.description = description;
        this.members = new ConcurrentSkipListSet<JID>(members);
        this.administrators = new ConcurrentSkipListSet<JID>(administrators);
        this.properties = this.provider.loadProperties(this);
        for (Map.Entry<String, String> property : properties.entrySet()) {
            if (property.getValue().equals(this.properties.get(property.getKey()))) continue;
            this.properties.put(property.getKey(), property.getValue());
        }
        Iterator oldProps = this.properties.keySet().iterator();
        while (oldProps.hasNext()) {
            if (properties.containsKey(oldProps.next())) continue;
            oldProps.remove();
        }
    }

    public synchronized GroupJID getJID() {
        if (this.jid == null) {
            this.jid = new GroupJID(this.getName());
        }
        return this.jid;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == this.name || name != null && name.equals(this.name) || this.provider.isReadOnly()) {
            return;
        }
        try {
            String originalName = this.name;
            GroupJID originalJID = this.getJID();
            this.provider.setName(originalName, name);
            this.name = name;
            this.jid = null;
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("type", "nameModified");
            params.put("originalValue", originalName);
            params.put("originalJID", (Object)originalJID);
            GroupEventDispatcher.dispatchEvent(this, GroupEventDispatcher.EventType.group_modified, params);
        }
        catch (GroupAlreadyExistsException e) {
            Log.error("Failed to change group name; group already exists");
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        if (description == this.description || description != null && description.equals(this.description) || this.provider.isReadOnly()) {
            return;
        }
        try {
            String originalDescription = this.description;
            this.provider.setDescription(this.name, description);
            this.description = description;
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("type", "descriptionModified");
            params.put("originalValue", originalDescription);
            GroupEventDispatcher.dispatchEvent(this, GroupEventDispatcher.EventType.group_modified, params);
        }
        catch (Exception e) {
            Log.error(e.getMessage(), (Throwable)e);
        }
    }

    public String toString() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PersistableMap<String, String> getProperties() {
        Group group = this;
        synchronized (group) {
            if (this.properties == null) {
                this.properties = this.provider.loadProperties(this);
            }
        }
        return this.properties;
    }

    public Collection<JID> getAll() {
        HashSet<JID> everybody = new HashSet<JID>(this.administrators);
        everybody.addAll(this.members);
        return Collections.unmodifiableSet(everybody);
    }

    public Collection<JID> getAdmins() {
        return new MemberCollection(this.administrators, true);
    }

    public Collection<JID> getMembers() {
        return new MemberCollection(this.members, false);
    }

    public boolean isUser(JID user) {
        if (user != null && user.getResource() != null) {
            user = user.asBareJID();
        }
        return user != null && (this.members.contains(user) || this.administrators.contains(user));
    }

    public boolean isUser(String username) {
        if (username != null) {
            return this.isUser(XMPPServer.getInstance().createJID(username, null, true));
        }
        return false;
    }

    @Override
    public int getCachedSize() throws CannotCalculateSizeException {
        int size = 0;
        size += CacheSizes.sizeOfObject();
        size += CacheSizes.sizeOfString(this.name);
        size += CacheSizes.sizeOfString(this.description);
        size += CacheSizes.sizeOfMap(this.properties);
        for (JID member : this.members) {
            size += CacheSizes.sizeOfString(member.toString());
        }
        for (JID admin : this.administrators) {
            size += CacheSizes.sizeOfString(admin.toString());
        }
        return size;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && object instanceof Group) {
            return this.name.equals(((Group)object).getName());
        }
        return false;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        ExternalizableUtil.getInstance().writeSafeUTF(out, this.name);
        ExternalizableUtil.getInstance().writeBoolean(out, this.description != null);
        if (this.description != null) {
            ExternalizableUtil.getInstance().writeSafeUTF(out, this.description);
        }
        ExternalizableUtil.getInstance().writeSerializableCollection(out, this.members);
        ExternalizableUtil.getInstance().writeSerializableCollection(out, this.administrators);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.groupManager = GroupManager.getInstance();
        this.provider = this.groupManager.getProvider();
        this.name = ExternalizableUtil.getInstance().readSafeUTF(in);
        if (ExternalizableUtil.getInstance().readBoolean(in)) {
            this.description = ExternalizableUtil.getInstance().readSafeUTF(in);
        }
        this.members = new ConcurrentSkipListSet();
        this.administrators = new ConcurrentSkipListSet();
        ExternalizableUtil.getInstance().readSerializableCollection(in, this.members, this.getClass().getClassLoader());
        ExternalizableUtil.getInstance().readSerializableCollection(in, this.administrators, this.getClass().getClassLoader());
    }

    public static boolean search(JID needle, Object haystack) {
        Group group = Group.resolveFrom(haystack);
        return group != null && group.isUser(needle);
    }

    public static Group resolveFrom(Object proxy) {
        Group result = null;
        try {
            GroupManager groupManger = GroupManager.getInstance();
            if (proxy instanceof JID) {
                result = groupManger.getGroup((JID)proxy);
            } else if (proxy instanceof String) {
                result = groupManger.getGroup((String)proxy);
            } else if (proxy instanceof Group) {
                result = (Group)proxy;
            }
        }
        catch (GroupNotFoundException groupNotFoundException) {
            // empty catch block
        }
        return result;
    }

    private class MemberCollection
    extends AbstractCollection<JID> {
        private Collection<JID> users;
        private boolean adminCollection;

        public MemberCollection(Collection<JID> users, boolean adminCollection) {
            this.users = users;
            this.adminCollection = adminCollection;
        }

        @Override
        public Iterator<JID> iterator() {
            return new Iterator<JID>(){
                Iterator<JID> iter;
                JID current;
                {
                    this.iter = MemberCollection.this.users.iterator();
                    this.current = null;
                }

                @Override
                public boolean hasNext() {
                    return this.iter.hasNext();
                }

                @Override
                public JID next() {
                    this.current = this.iter.next();
                    return this.current;
                }

                @Override
                public void remove() {
                    if (this.current == null) {
                        throw new IllegalStateException();
                    }
                    if (Group.this.provider.isReadOnly()) {
                        return;
                    }
                    JID user = this.current;
                    this.iter.remove();
                    Group.this.provider.deleteMember(Group.this.name, user);
                    if (MemberCollection.this.adminCollection) {
                        HashMap<String, String> params = new HashMap<String, String>();
                        params.put("admin", user.toString());
                        GroupEventDispatcher.dispatchEvent(Group.this, GroupEventDispatcher.EventType.admin_removed, params);
                    } else {
                        HashMap<String, String> params = new HashMap<String, String>();
                        params.put("member", user.toString());
                        GroupEventDispatcher.dispatchEvent(Group.this, GroupEventDispatcher.EventType.member_removed, params);
                    }
                }
            };
        }

        @Override
        public int size() {
            return this.users.size();
        }

        @Override
        public boolean add(JID user) {
            if (Group.this.provider.isReadOnly()) {
                return false;
            }
            boolean alreadyGroupUser = this.adminCollection ? Group.this.members.contains(user) : Group.this.administrators.contains(user);
            if (this.users.add(user)) {
                if (alreadyGroupUser) {
                    Group.this.provider.updateMember(Group.this.name, user, this.adminCollection);
                } else {
                    Group.this.provider.addMember(Group.this.name, user, this.adminCollection);
                }
                HashMap<String, String> params = new HashMap<String, String>();
                if (this.adminCollection) {
                    params.put("admin", user.toString());
                    if (alreadyGroupUser) {
                        params.put("member", user.toString());
                        GroupEventDispatcher.dispatchEvent(Group.this, GroupEventDispatcher.EventType.member_removed, params);
                    }
                    GroupEventDispatcher.dispatchEvent(Group.this, GroupEventDispatcher.EventType.admin_added, params);
                } else {
                    params.put("member", user.toString());
                    if (alreadyGroupUser) {
                        params.put("admin", user.toString());
                        GroupEventDispatcher.dispatchEvent(Group.this, GroupEventDispatcher.EventType.admin_removed, params);
                    }
                    GroupEventDispatcher.dispatchEvent(Group.this, GroupEventDispatcher.EventType.member_added, params);
                }
                if (alreadyGroupUser) {
                    if (this.adminCollection) {
                        if (Group.this.members.contains(user)) {
                            Group.this.members.remove(user);
                        }
                    } else if (Group.this.administrators.contains(user)) {
                        Group.this.administrators.remove(user);
                    }
                }
                return true;
            }
            return false;
        }
    }
}

