/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.group;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jivesoftware.database.DbConnectionManager;
import org.jivesoftware.openfire.event.GroupEventDispatcher;
import org.jivesoftware.openfire.group.Group;
import org.jivesoftware.util.PersistableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultGroupPropertyMap<K, V>
extends PersistableMap<K, V> {
    private static final long serialVersionUID = 3128889631577167040L;
    private static final Logger logger = LoggerFactory.getLogger(DefaultGroupPropertyMap.class);
    private static final String DELETE_PROPERTY = "DELETE FROM ofGroupProp WHERE groupName=? AND name=?";
    private static final String DELETE_ALL_PROPERTIES = "DELETE FROM ofGroupProp WHERE groupName=?";
    private static final String UPDATE_PROPERTY = "UPDATE ofGroupProp SET propValue=? WHERE name=? AND groupName=?";
    private static final String INSERT_PROPERTY = "INSERT INTO ofGroupProp (groupName, name, propValue) VALUES (?, ?, ?)";
    private Group group;

    public DefaultGroupPropertyMap(Group group) {
        this.group = group;
    }

    @Override
    public V put(K key, V value, boolean persist) {
        V originalValue = super.put(key, value);
        if (persist && key instanceof String && value instanceof String) {
            if (logger.isDebugEnabled()) {
                logger.debug("Persisting group property [" + key + "]: " + value);
            }
            if (originalValue instanceof String) {
                this.updateProperty((String)key, (String)value, (String)originalValue);
            } else {
                this.insertProperty((String)key, (String)value);
            }
        }
        return originalValue;
    }

    @Override
    public V put(K key, V value) {
        if (value == null) {
            return this.remove(key);
        }
        return this.put(key, value, true);
    }

    @Override
    public V remove(Object key) {
        Object result = super.remove(key);
        if (key instanceof String) {
            this.deleteProperty((String)key);
        }
        return result;
    }

    @Override
    public void clear() {
        super.clear();
        this.deleteAllProperties();
    }

    @Override
    public Set<K> keySet() {
        return new PersistenceAwareKeySet(super.keySet());
    }

    @Override
    public Collection<V> values() {
        return Collections.unmodifiableCollection(super.values());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new PersistenceAwareEntrySet(super.entrySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void insertProperty(String key, String value) {
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(INSERT_PROPERTY);
            pstmt.setString(1, this.group.getName());
            pstmt.setString(2, key);
            pstmt.setString(3, value);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                logger.error(e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, con);
                throw throwable;
            }
            DbConnectionManager.closeConnection(pstmt, con);
        }
        DbConnectionManager.closeConnection(pstmt, con);
        HashMap<String, String> event = new HashMap<String, String>();
        event.put("propertyKey", key);
        event.put("type", "propertyAdded");
        GroupEventDispatcher.dispatchEvent(this.group, GroupEventDispatcher.EventType.group_modified, event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void updateProperty(String key, String value, String originalValue) {
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(UPDATE_PROPERTY);
            pstmt.setString(1, value);
            pstmt.setString(2, key);
            pstmt.setString(3, this.group.getName());
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                logger.error(e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, con);
                throw throwable;
            }
            DbConnectionManager.closeConnection(pstmt, con);
        }
        DbConnectionManager.closeConnection(pstmt, con);
        HashMap<String, String> event = new HashMap<String, String>();
        event.put("propertyKey", key);
        event.put("type", "propertyModified");
        event.put("originalValue", originalValue);
        GroupEventDispatcher.dispatchEvent(this.group, GroupEventDispatcher.EventType.group_modified, event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void deleteProperty(String key) {
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(DELETE_PROPERTY);
            pstmt.setString(1, this.group.getName());
            pstmt.setString(2, key);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                logger.error(e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, con);
                throw throwable;
            }
            DbConnectionManager.closeConnection(pstmt, con);
        }
        DbConnectionManager.closeConnection(pstmt, con);
        HashMap<String, String> event = new HashMap<String, String>();
        event.put("type", "propertyDeleted");
        event.put("propertyKey", key);
        GroupEventDispatcher.dispatchEvent(this.group, GroupEventDispatcher.EventType.group_modified, event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void deleteAllProperties() {
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(DELETE_ALL_PROPERTIES);
            pstmt.setString(1, this.group.getName());
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                logger.error(e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, con);
                throw throwable;
            }
            DbConnectionManager.closeConnection(pstmt, con);
        }
        DbConnectionManager.closeConnection(pstmt, con);
        HashMap<String, String> event = new HashMap<String, String>();
        event.put("type", "propertyDeleted");
        event.put("propertyKey", "*");
        GroupEventDispatcher.dispatchEvent(this.group, GroupEventDispatcher.EventType.group_modified, event);
    }

    private class EntryWrapper<E>
    implements Map.Entry<K, V> {
        private Map.Entry<K, V> delegate;

        public EntryWrapper(Map.Entry<K, V> delegate) {
            this.delegate = delegate;
        }

        @Override
        public K getKey() {
            return this.delegate.getKey();
        }

        @Override
        public V getValue() {
            return this.delegate.getValue();
        }

        @Override
        public V setValue(V value) {
            Object oldValue = this.delegate.setValue(value);
            Object key = this.delegate.getKey();
            if (key instanceof String) {
                if (value instanceof String) {
                    if (oldValue == null) {
                        DefaultGroupPropertyMap.this.insertProperty((String)key, (String)value);
                    } else if (!value.equals(oldValue)) {
                        DefaultGroupPropertyMap.this.updateProperty((String)key, (String)value, (String)oldValue);
                    }
                } else {
                    DefaultGroupPropertyMap.this.deleteProperty((String)key);
                }
            }
            return oldValue;
        }
    }

    private class EntryIterator<E>
    implements Iterator<Map.Entry<K, V>> {
        private Iterator<Map.Entry<K, V>> delegate;
        private EntryWrapper<E> current;

        public EntryIterator(Iterator<Map.Entry<K, V>> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public Map.Entry<K, V> next() {
            this.current = new EntryWrapper(this.delegate.next());
            return this.current;
        }

        @Override
        public void remove() {
            this.delegate.remove();
            Object key = this.current.getKey();
            if (key instanceof String) {
                DefaultGroupPropertyMap.this.deleteProperty((String)key);
            }
            this.current = null;
        }
    }

    private class PersistenceAwareEntrySet<E>
    implements Set<Map.Entry<K, V>> {
        private Set<Map.Entry<K, V>> delegate;

        public PersistenceAwareEntrySet(Set<Map.Entry<K, V>> delegate) {
            this.delegate = delegate;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator(this.delegate.iterator());
        }

        @Override
        public boolean remove(Object o) {
            boolean propertyExists = this.delegate.remove(o);
            if (propertyExists) {
                DefaultGroupPropertyMap.this.deleteProperty((String)((Map.Entry)o).getKey());
            }
            return propertyExists;
        }

        @Override
        public void clear() {
            this.delegate.clear();
            DefaultGroupPropertyMap.this.deleteAllProperties();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean add(Map.Entry<K, V> o) {
            return this.delegate.add(o);
        }

        @Override
        public boolean addAll(Collection<? extends Map.Entry<K, V>> c) {
            return this.delegate.addAll(c);
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.delegate.contains(o);
        }

        @Override
        public Object[] toArray() {
            return this.delegate.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.delegate.toArray(a);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.delegate.containsAll(c);
        }

        @Override
        public boolean equals(Object o) {
            return this.delegate.equals(o);
        }

        @Override
        public int hashCode() {
            return this.delegate.hashCode();
        }
    }

    private class KeyIterator<E>
    implements Iterator<K> {
        private Iterator<K> delegate;
        private K current;

        public KeyIterator(Iterator<K> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public K next() {
            this.current = this.delegate.next();
            return this.current;
        }

        @Override
        public void remove() {
            this.delegate.remove();
            if (this.current instanceof String) {
                DefaultGroupPropertyMap.this.deleteProperty((String)this.current);
            }
            this.current = null;
        }
    }

    private class PersistenceAwareKeySet<E>
    extends AbstractSet<K> {
        private Set<K> delegate;

        public PersistenceAwareKeySet(Set<K> delegate) {
            this.delegate = delegate;
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator(this.delegate.iterator());
        }

        @Override
        public int size() {
            return this.delegate.size();
        }
    }
}

