/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.group;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jivesoftware.openfire.group.Group;
import org.jivesoftware.openfire.group.GroupAwareMap;
import org.xmpp.packet.JID;

public class ConcurrentGroupMap<K, V>
extends ConcurrentHashMap<K, V>
implements GroupAwareMap<K, V> {
    private static final long serialVersionUID = 5479781418678223200L;
    private volatile transient Set<String> knownGroupNamesFromKeys;
    private volatile transient Set<String> knownGroupNamesFromValues;
    private static final boolean KEYS = true;
    private static final boolean VALUES = false;
    private static final boolean ADD = true;
    private static final boolean REMOVE = false;

    @Override
    public boolean includesKey(Object key) {
        boolean found = false;
        if (this.containsKey(key)) {
            found = true;
        } else if (key instanceof JID) {
            JID target = (JID)key;
            Iterator<Group> iterator = this.getGroupsFromKeys().iterator();
            while (!found && iterator.hasNext()) {
                Group next = iterator.next();
                if (next == null) continue;
                found = next.isUser(target);
            }
        }
        return found;
    }

    @Override
    public boolean includesValue(Object value) {
        boolean found = false;
        if (this.containsValue(value)) {
            found = true;
        } else if (value instanceof JID) {
            JID target = (JID)value;
            Iterator<Group> iterator = this.getGroupsFromValues().iterator();
            while (!found && iterator.hasNext()) {
                found = iterator.next().isUser(target);
            }
        }
        return found;
    }

    @Override
    public synchronized Set<Group> getGroupsFromKeys() {
        HashSet<Group> result = new HashSet<Group>();
        for (String groupName : this.getKnownGroupNamesFromKeys()) {
            Group resolved = Group.resolveFrom(groupName);
            if (resolved == null) continue;
            result.add(resolved);
        }
        return result;
    }

    @Override
    public synchronized Set<Group> getGroupsFromValues() {
        HashSet<Group> result = new HashSet<Group>();
        for (String groupName : this.getKnownGroupNamesFromValues()) {
            result.add(Group.resolveFrom(groupName));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getKnownGroupNamesFromKeys() {
        Set<String> result = this.knownGroupNamesFromKeys;
        if (result == null) {
            ConcurrentGroupMap concurrentGroupMap = this;
            synchronized (concurrentGroupMap) {
                result = this.knownGroupNamesFromKeys;
                if (result == null) {
                    result = new HashSet<String>();
                    for (Object key : this.keySet()) {
                        Group group = Group.resolveFrom(key);
                        if (group == null) continue;
                        result.add(group.getName());
                    }
                    this.knownGroupNamesFromKeys = result.isEmpty() ? null : result;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getKnownGroupNamesFromValues() {
        Set<String> result = this.knownGroupNamesFromValues;
        if (result == null) {
            ConcurrentGroupMap concurrentGroupMap = this;
            synchronized (concurrentGroupMap) {
                result = this.knownGroupNamesFromValues;
                if (result == null) {
                    result = new HashSet<String>();
                    for (Object key : this.values()) {
                        Group group = Group.resolveFrom(key);
                        if (group == null) continue;
                        result.add(group.getName());
                    }
                    this.knownGroupNamesFromValues = result.isEmpty() ? null : result;
                }
            }
        }
        return result;
    }

    private synchronized boolean syncGroups(Object item, boolean keyOrValue, boolean addOrRemove) {
        Group group;
        Set<String> groupSet;
        boolean result = false;
        Set<String> set = groupSet = keyOrValue ? this.knownGroupNamesFromKeys : this.knownGroupNamesFromValues;
        if (groupSet != null && (group = Group.resolveFrom(item)) != null) {
            result = true;
            if (addOrRemove) {
                groupSet.add(group.getName());
            } else if (!addOrRemove) {
                groupSet.remove(group.getName());
                if (groupSet.isEmpty()) {
                    if (keyOrValue) {
                        this.knownGroupNamesFromKeys = null;
                    } else {
                        this.knownGroupNamesFromValues = null;
                    }
                }
            }
        }
        return result;
    }

    @Override
    public V put(K key, V value) {
        V priorValue = super.put(key, value);
        this.syncGroups(value, false, true);
        if (priorValue == null) {
            this.syncGroups(key, true, true);
        } else {
            this.syncGroups(priorValue, false, false);
        }
        return priorValue;
    }

    @Override
    public V putIfAbsent(K key, V value) {
        V priorValue = super.putIfAbsent(key, value);
        if (!value.equals(priorValue)) {
            this.syncGroups(value, false, true);
            if (priorValue == null) {
                this.syncGroups(key, true, true);
            } else {
                this.syncGroups(priorValue, false, false);
            }
        }
        return priorValue;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        super.putAll(m);
        this.clearCache();
    }

    @Override
    public V remove(Object key) {
        Object priorValue = super.remove(key);
        if (priorValue != null) {
            this.syncGroups(key, true, false);
            this.syncGroups(priorValue, false, false);
        }
        return priorValue;
    }

    @Override
    public boolean remove(Object key, Object value) {
        boolean removed = super.remove(key, value);
        if (removed) {
            this.syncGroups(key, true, false);
            this.syncGroups(value, false, false);
        }
        return removed;
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        boolean replaced = super.replace(key, oldValue, newValue);
        if (replaced) {
            this.syncGroups(oldValue, false, false);
            this.syncGroups(newValue, false, true);
        }
        return replaced;
    }

    @Override
    public V replace(K key, V value) {
        V priorValue = super.replace(key, value);
        if (priorValue != null) {
            this.syncGroups(value, false, true);
            this.syncGroups(priorValue, false, false);
        }
        return priorValue;
    }

    @Override
    public void clear() {
        super.clear();
        this.clearCache();
    }

    private synchronized void clearCache() {
        this.knownGroupNamesFromKeys = null;
        this.knownGroupNamesFromValues = null;
    }
}

