/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.filetransfer;

import java.util.ArrayList;
import java.util.List;
import org.dom4j.Element;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.container.BasicModule;
import org.jivesoftware.openfire.filetransfer.FileTransfer;
import org.jivesoftware.openfire.filetransfer.FileTransferEventListener;
import org.jivesoftware.openfire.filetransfer.FileTransferManager;
import org.jivesoftware.openfire.filetransfer.FileTransferRejectedException;
import org.jivesoftware.openfire.filetransfer.proxy.ProxyConnectionManager;
import org.jivesoftware.openfire.filetransfer.proxy.ProxyTransfer;
import org.jivesoftware.openfire.interceptor.InterceptorManager;
import org.jivesoftware.openfire.interceptor.PacketInterceptor;
import org.jivesoftware.openfire.interceptor.PacketRejectedException;
import org.jivesoftware.openfire.session.Session;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.cache.Cache;
import org.jivesoftware.util.cache.CacheFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.IQ;
import org.xmpp.packet.JID;
import org.xmpp.packet.Packet;

public class DefaultFileTransferManager
extends BasicModule
implements FileTransferManager {
    private static final Logger Log = LoggerFactory.getLogger(DefaultFileTransferManager.class);
    private static final String CACHE_NAME = "File Transfer Cache";
    private final Cache<String, FileTransfer> fileTransferMap;
    private final List<FileTransferEventListener> eventListeners = new ArrayList<FileTransferEventListener>();

    public DefaultFileTransferManager() {
        super("File Transfer Manager");
        this.fileTransferMap = CacheFactory.createCache(CACHE_NAME);
        InterceptorManager.getInstance().addInterceptor(new MetaFileTransferInterceptor());
    }

    public boolean isMatchProxyTransfer() {
        return JiveGlobals.getBooleanProperty("xmpp.proxy.transfer.required", true);
    }

    protected void cacheFileTransfer(String key, FileTransfer transfer) {
        this.fileTransferMap.put(key, transfer);
    }

    protected FileTransfer retrieveFileTransfer(String key) {
        return (FileTransfer)this.fileTransferMap.get(key);
    }

    protected static Element getChildElement(Element element, String namespace) {
        List elements = element.elements();
        if (elements.isEmpty()) {
            return null;
        }
        for (Element childElement : elements) {
            String childNamespace = childElement.getNamespaceURI();
            if (!namespace.equals(childNamespace)) continue;
            return childElement;
        }
        return null;
    }

    @Override
    public boolean acceptIncomingFileTransferRequest(FileTransfer transfer) throws FileTransferRejectedException {
        if (transfer != null) {
            this.fireFileTransferStart(transfer.getSessionID(), false);
            String streamID = transfer.getSessionID();
            JID from = new JID(transfer.getInitiator());
            JID to = new JID(transfer.getTarget());
            this.cacheFileTransfer(ProxyConnectionManager.createDigest(streamID, from, to), transfer);
            return true;
        }
        return false;
    }

    @Override
    public void registerProxyTransfer(String transferDigest, ProxyTransfer proxyTransfer) throws UnauthorizedException {
        FileTransfer transfer = this.retrieveFileTransfer(transferDigest);
        if (this.isMatchProxyTransfer() && transfer == null) {
            throw new UnauthorizedException("Unable to match proxy transfer with a file transfer");
        }
        if (transfer == null) {
            return;
        }
        transfer.setProgress(proxyTransfer);
        this.cacheFileTransfer(transferDigest, transfer);
    }

    private FileTransfer createFileTransfer(JID from, JID to, Element siElement) {
        long size;
        String streamID = siElement.attributeValue("id");
        String mimeType = siElement.attributeValue("mime-type");
        Element fileTransferElement = DefaultFileTransferManager.getChildElement(siElement, "http://jabber.org/protocol/si/profile/file-transfer");
        if (fileTransferElement == null) {
            return null;
        }
        String fileName = fileTransferElement.attributeValue("name");
        String sizeString = fileTransferElement.attributeValue("size");
        if (fileName == null || sizeString == null) {
            return null;
        }
        try {
            size = Long.parseLong(sizeString);
        }
        catch (Exception ex) {
            return null;
        }
        return new FileTransfer(from.toString(), to.toString(), streamID, fileName, size, mimeType);
    }

    @Override
    public void addListener(FileTransferEventListener eventListener) {
        this.eventListeners.add(eventListener);
    }

    @Override
    public void removeListener(FileTransferEventListener eventListener) {
        this.eventListeners.remove(eventListener);
    }

    @Override
    public void fireFileTransferStart(String sid, boolean isReady) throws FileTransferRejectedException {
        FileTransfer transfer = (FileTransfer)this.fileTransferMap.get(sid);
        for (FileTransferEventListener listener : this.eventListeners) {
            try {
                listener.fileTransferStart(transfer, isReady);
            }
            catch (FileTransferRejectedException ex) {
                Log.debug("Listener '{}' rejected file transfer '{}'.", (Object)listener, (Object)transfer);
                throw ex;
            }
            catch (Exception ex) {
                Log.warn("Listener '{}' threw exception when being informed of file transfer complete for transfer '{}'.", new Object[]{listener, transfer, ex});
            }
        }
    }

    @Override
    public void fireFileTransferCompleted(String sid, boolean wasSuccessful) {
        FileTransfer transfer = (FileTransfer)this.fileTransferMap.get(sid);
        for (FileTransferEventListener listener : this.eventListeners) {
            try {
                listener.fileTransferComplete(transfer, wasSuccessful);
            }
            catch (Exception ex) {
                Log.warn("Listener '{}' threw exception when being informed of file transfer complete for transfer '{}'.", new Object[]{listener, transfer, ex});
            }
        }
    }

    private class MetaFileTransferInterceptor
    implements PacketInterceptor {
        private MetaFileTransferInterceptor() {
        }

        @Override
        public void interceptPacket(Packet packet, Session session, boolean incoming, boolean processed) throws PacketRejectedException {
            if (!processed && incoming && packet instanceof IQ) {
                IQ iq = (IQ)packet;
                Element childElement = iq.getChildElement();
                if (childElement == null) {
                    return;
                }
                String namespace = childElement.getNamespaceURI();
                String profile = childElement.attributeValue("profile");
                if ("http://jabber.org/protocol/si".equals(namespace) && "http://jabber.org/protocol/si/profile/file-transfer".equals(profile) && iq.getType().equals((Object)IQ.Type.set)) {
                    JID from = iq.getFrom();
                    JID to = iq.getTo();
                    FileTransfer transfer = DefaultFileTransferManager.this.createFileTransfer(from, to, childElement);
                    try {
                        if (transfer == null || !DefaultFileTransferManager.this.acceptIncomingFileTransferRequest(transfer)) {
                            throw new PacketRejectedException();
                        }
                    }
                    catch (FileTransferRejectedException e) {
                        throw new PacketRejectedException(e);
                    }
                }
            }
        }
    }
}

