/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.event;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jivesoftware.openfire.event.GroupEventListener;
import org.jivesoftware.openfire.group.Group;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupEventDispatcher {
    private static final Logger Log = LoggerFactory.getLogger(GroupEventDispatcher.class);
    private static List<GroupEventListener> listeners = new CopyOnWriteArrayList<GroupEventListener>();

    private GroupEventDispatcher() {
    }

    public static void addListener(GroupEventListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        listeners.add(listener);
    }

    public static void removeListener(GroupEventListener listener) {
        listeners.remove(listener);
    }

    public static void dispatchEvent(Group group, EventType eventType, Map params) {
        for (GroupEventListener listener : listeners) {
            try {
                switch (eventType) {
                    case group_created: {
                        listener.groupCreated(group, params);
                        break;
                    }
                    case group_deleting: {
                        listener.groupDeleting(group, params);
                        break;
                    }
                    case member_added: {
                        listener.memberAdded(group, params);
                        break;
                    }
                    case member_removed: {
                        listener.memberRemoved(group, params);
                        break;
                    }
                    case admin_added: {
                        listener.adminAdded(group, params);
                        break;
                    }
                    case admin_removed: {
                        listener.adminRemoved(group, params);
                        break;
                    }
                    case group_modified: {
                        listener.groupModified(group, params);
                        break;
                    }
                }
            }
            catch (Exception e) {
                Log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static enum EventType {
        group_created,
        group_deleting,
        group_modified,
        member_added,
        member_removed,
        admin_added,
        admin_removed;

    }
}

