/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.disco;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.locks.Lock;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;
import org.jivesoftware.openfire.IQHandlerInfo;
import org.jivesoftware.openfire.SessionManager;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.cluster.ClusterEventListener;
import org.jivesoftware.openfire.cluster.ClusterManager;
import org.jivesoftware.openfire.cluster.NodeID;
import org.jivesoftware.openfire.disco.DiscoInfoProvider;
import org.jivesoftware.openfire.disco.ServerFeaturesProvider;
import org.jivesoftware.openfire.disco.ServerIdentitiesProvider;
import org.jivesoftware.openfire.disco.UserIdentitiesProvider;
import org.jivesoftware.openfire.handler.IQHandler;
import org.jivesoftware.openfire.user.UserManager;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.cache.Cache;
import org.jivesoftware.util.cache.CacheFactory;
import org.xmpp.forms.DataForm;
import org.xmpp.packet.IQ;
import org.xmpp.packet.JID;
import org.xmpp.packet.PacketError;

public class IQDiscoInfoHandler
extends IQHandler
implements ClusterEventListener {
    public static final String NAMESPACE_DISCO_INFO = "http://jabber.org/protocol/disco#info";
    private Map<String, DiscoInfoProvider> entities = new HashMap<String, DiscoInfoProvider>();
    private Set<String> localServerFeatures = new CopyOnWriteArraySet<String>();
    private Cache<String, Set<NodeID>> serverFeatures;
    private List<Element> serverIdentities = new ArrayList<Element>();
    private Map<String, DiscoInfoProvider> serverNodeProviders = new ConcurrentHashMap<String, DiscoInfoProvider>();
    private IQHandlerInfo info;
    private List<Element> anonymousUserIdentities = new ArrayList<Element>();
    private List<Element> registeredUserIdentities = new ArrayList<Element>();

    public IQDiscoInfoHandler() {
        super("XMPP Disco Info Handler");
        this.info = new IQHandlerInfo("query", NAMESPACE_DISCO_INFO);
        Element userIdentity = DocumentHelper.createElement((String)"identity");
        userIdentity.addAttribute("category", "account");
        userIdentity.addAttribute("type", "anonymous");
        this.anonymousUserIdentities.add(userIdentity);
        userIdentity = DocumentHelper.createElement((String)"identity");
        userIdentity.addAttribute("category", "account");
        userIdentity.addAttribute("type", "registered");
        this.registeredUserIdentities.add(userIdentity);
    }

    @Override
    public IQHandlerInfo getInfo() {
        return this.info;
    }

    @Override
    public IQ handleIQ(IQ packet) {
        IQ reply = IQ.createResultIQ((IQ)packet);
        DiscoInfoProvider infoProvider = this.getProvider(packet.getTo() == null ? XMPPServer.getInstance().getServerInfo().getXMPPDomain() : packet.getTo().getDomain());
        if (infoProvider != null) {
            Element iq;
            String node;
            String name;
            String string = name = packet.getTo() == null ? null : packet.getTo().getNode();
            if (name == null || name.trim().length() == 0) {
                name = null;
            }
            if (infoProvider.hasInfo(name, node = (iq = packet.getChildElement()).attributeValue("node"), packet.getFrom())) {
                DataForm dataForm;
                reply.setChildElement(iq.createCopy());
                Element queryElement = reply.getChildElement();
                Iterator<Element> identities = infoProvider.getIdentities(name, node, packet.getFrom());
                while (identities.hasNext()) {
                    Element identity = identities.next();
                    identity.setQName(new QName(identity.getName(), queryElement.getNamespace()));
                    queryElement.add((Element)identity.clone());
                }
                Iterator<String> features = infoProvider.getFeatures(name, node, packet.getFrom());
                boolean hasDiscoInfoFeature = false;
                boolean hasDiscoItemsFeature = false;
                boolean hasResultSetManagementFeature = false;
                while (features.hasNext()) {
                    String feature = features.next();
                    queryElement.addElement("feature").addAttribute("var", feature);
                    if (feature.equals(NAMESPACE_DISCO_INFO)) {
                        hasDiscoInfoFeature = true;
                        continue;
                    }
                    if (feature.equals("http://jabber.org/protocol/disco#items")) {
                        hasDiscoItemsFeature = true;
                        continue;
                    }
                    if (!feature.equals("http://jabber.org/protocol/rsm")) continue;
                    hasResultSetManagementFeature = true;
                }
                if (hasDiscoItemsFeature && !hasResultSetManagementFeature) {
                    queryElement.addElement("feature").addAttribute("var", "http://jabber.org/protocol/rsm");
                }
                if (!hasDiscoInfoFeature) {
                    queryElement.addElement("feature").addAttribute("var", NAMESPACE_DISCO_INFO);
                }
                if ((dataForm = infoProvider.getExtendedInfo(name, node, packet.getFrom())) != null) {
                    queryElement.add(dataForm.getElement());
                }
            } else {
                reply.setChildElement(packet.getChildElement().createCopy());
                reply.setError(PacketError.Condition.item_not_found);
            }
        } else {
            reply.setChildElement(packet.getChildElement().createCopy());
            reply.setError(PacketError.Condition.item_not_found);
        }
        return reply;
    }

    public void setServerNodeInfoProvider(String node, DiscoInfoProvider provider) {
        this.serverNodeProviders.put(node, provider);
    }

    public void removeServerNodeInfoProvider(String node) {
        this.serverNodeProviders.remove(node);
    }

    private DiscoInfoProvider getProvider(String name) {
        return this.entities.get(name);
    }

    protected void setProvider(String name, DiscoInfoProvider provider) {
        this.entities.put(name, provider);
    }

    protected void removeProvider(String name) {
        this.entities.remove(name);
    }

    private void addServerFeaturesProvider(ServerFeaturesProvider provider) {
        Iterator<String> it = provider.getFeatures();
        while (it.hasNext()) {
            this.addServerFeature(it.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServerFeature(String namespace) {
        if (this.localServerFeatures.add(namespace)) {
            Lock lock = CacheFactory.getLock(namespace, this.serverFeatures);
            try {
                lock.lock();
                HashSet<NodeID> nodeIDs = (HashSet<NodeID>)this.serverFeatures.get(namespace);
                if (nodeIDs == null) {
                    nodeIDs = new HashSet<NodeID>();
                }
                nodeIDs.add(XMPPServer.getInstance().getNodeID());
                this.serverFeatures.put(namespace, nodeIDs);
            }
            finally {
                lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeServerFeature(String namespace) {
        if (this.localServerFeatures.remove(namespace)) {
            Lock lock = CacheFactory.getLock(namespace, this.serverFeatures);
            try {
                lock.lock();
                Set nodeIDs = (Set)this.serverFeatures.get(namespace);
                if (nodeIDs != null) {
                    nodeIDs.remove(XMPPServer.getInstance().getNodeID());
                    if (nodeIDs.isEmpty()) {
                        this.serverFeatures.remove(namespace);
                    } else {
                        this.serverFeatures.put(namespace, nodeIDs);
                    }
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    @Override
    public void initialize(XMPPServer server) {
        Iterator<Element> it;
        super.initialize(server);
        this.serverFeatures = CacheFactory.createCache("Disco Server Features");
        this.addServerFeature(NAMESPACE_DISCO_INFO);
        for (ServerFeaturesProvider serverFeaturesProvider : server.getServerFeaturesProviders()) {
            this.addServerFeaturesProvider(serverFeaturesProvider);
        }
        for (ServerIdentitiesProvider serverIdentitiesProvider : server.getServerIdentitiesProviders()) {
            it = serverIdentitiesProvider.getIdentities();
            while (it.hasNext()) {
                this.serverIdentities.add(it.next());
            }
        }
        for (UserIdentitiesProvider userIdentitiesProvider : server.getUserIdentitiesProviders()) {
            it = userIdentitiesProvider.getIdentities();
            while (it.hasNext()) {
                this.registeredUserIdentities.add(it.next());
            }
        }
        this.setProvider(server.getServerInfo().getXMPPDomain(), this.getServerInfoProvider());
        ClusterManager.addListener(this);
    }

    @Override
    public void joinedCluster() {
        this.restoreCacheContent();
    }

    @Override
    public void joinedCluster(byte[] nodeID) {
    }

    @Override
    public void leftCluster() {
        if (!XMPPServer.getInstance().isShuttingDown()) {
            this.restoreCacheContent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void leftCluster(byte[] nodeID) {
        if (ClusterManager.isSeniorClusterMember()) {
            NodeID leftNode = NodeID.getInstance(nodeID);
            for (Map.Entry entry : this.serverFeatures.entrySet()) {
                String namespace = (String)entry.getKey();
                Lock lock = CacheFactory.getLock(namespace, this.serverFeatures);
                try {
                    lock.lock();
                    Set nodeIDs = (Set)entry.getValue();
                    if (!nodeIDs.remove(leftNode)) continue;
                    if (nodeIDs.isEmpty()) {
                        this.serverFeatures.remove(namespace);
                        continue;
                    }
                    this.serverFeatures.put(namespace, nodeIDs);
                }
                finally {
                    lock.unlock();
                }
            }
        }
    }

    @Override
    public void markedAsSeniorClusterMember() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreCacheContent() {
        for (String feature : this.localServerFeatures) {
            Lock lock = CacheFactory.getLock(feature, this.serverFeatures);
            try {
                lock.lock();
                HashSet<NodeID> nodeIDs = (HashSet<NodeID>)this.serverFeatures.get(feature);
                if (nodeIDs == null) {
                    nodeIDs = new HashSet<NodeID>();
                }
                nodeIDs.add(XMPPServer.getInstance().getNodeID());
                this.serverFeatures.put(feature, nodeIDs);
            }
            finally {
                lock.unlock();
            }
        }
    }

    private DiscoInfoProvider getServerInfoProvider() {
        return new DiscoInfoProvider(){
            final ArrayList<Element> identities = new ArrayList();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Iterator<Element> getIdentities(String name, String node, JID senderJID) {
                if (node != null && IQDiscoInfoHandler.this.serverNodeProviders.get(node) != null) {
                    return ((DiscoInfoProvider)IQDiscoInfoHandler.this.serverNodeProviders.get(node)).getIdentities(name, node, senderJID);
                }
                if (name == null || name.equals(XMPPServer.getInstance().getServerInfo().getXMPPDomain())) {
                    ArrayList<Element> arrayList = this.identities;
                    synchronized (arrayList) {
                        if (this.identities.isEmpty()) {
                            Element identity = DocumentHelper.createElement((String)"identity");
                            identity.addAttribute("category", "server");
                            identity.addAttribute("name", JiveGlobals.getProperty("xmpp.server.name", "Openfire Server"));
                            identity.addAttribute("type", "im");
                            this.identities.add(identity);
                            for (Element identityElement : IQDiscoInfoHandler.this.serverIdentities) {
                                this.identities.add(identityElement);
                            }
                        }
                    }
                    return this.identities.iterator();
                }
                if (node != null) {
                    return XMPPServer.getInstance().getIQPEPHandler().getIdentities(name, node, senderJID);
                }
                if (SessionManager.getInstance().isAnonymousRoute(name)) {
                    return IQDiscoInfoHandler.this.anonymousUserIdentities.iterator();
                }
                return IQDiscoInfoHandler.this.registeredUserIdentities.iterator();
            }

            @Override
            public Iterator<String> getFeatures(String name, String node, JID senderJID) {
                if (node != null && IQDiscoInfoHandler.this.serverNodeProviders.get(node) != null) {
                    return ((DiscoInfoProvider)IQDiscoInfoHandler.this.serverNodeProviders.get(node)).getFeatures(name, node, senderJID);
                }
                if (node != null && name != null) {
                    return XMPPServer.getInstance().getIQPEPHandler().getFeatures(name, node, senderJID);
                }
                return new HashSet(IQDiscoInfoHandler.this.serverFeatures.keySet()).iterator();
            }

            @Override
            public boolean hasInfo(String name, String node, JID senderJID) {
                if (node != null) {
                    if (IQDiscoInfoHandler.this.serverNodeProviders.get(node) != null) {
                        return ((DiscoInfoProvider)IQDiscoInfoHandler.this.serverNodeProviders.get(node)).hasInfo(name, node, senderJID);
                    }
                    if (name != null) {
                        return XMPPServer.getInstance().getIQPEPHandler().hasInfo(name, node, senderJID);
                    }
                    return false;
                }
                try {
                    if (name == null) {
                        return true;
                    }
                    if (UserManager.getInstance().getUser(name) != null || SessionManager.getInstance().isAnonymousRoute(name)) {
                        if (node == null) {
                            return true;
                        }
                        return XMPPServer.getInstance().getIQPEPHandler().hasInfo(name, node, senderJID);
                    }
                    return false;
                }
                catch (UserNotFoundException e) {
                    return false;
                }
            }

            @Override
            public DataForm getExtendedInfo(String name, String node, JID senderJID) {
                if (node != null && IQDiscoInfoHandler.this.serverNodeProviders.get(node) != null) {
                    return ((DiscoInfoProvider)IQDiscoInfoHandler.this.serverNodeProviders.get(node)).getExtendedInfo(name, node, senderJID);
                }
                if (node != null && name != null) {
                    return XMPPServer.getInstance().getIQPEPHandler().getExtendedInfo(name, node, senderJID);
                }
                return null;
            }
        };
    }
}

