/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.crowd;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URI;
import java.net.URLEncoder;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXB;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.lang.StringUtils;
import org.jivesoftware.openfire.crowd.CrowdProperties;
import org.jivesoftware.openfire.crowd.jaxb.AuthenticatePost;
import org.jivesoftware.openfire.crowd.jaxb.Group;
import org.jivesoftware.openfire.crowd.jaxb.Groups;
import org.jivesoftware.openfire.crowd.jaxb.User;
import org.jivesoftware.openfire.crowd.jaxb.Users;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;

public class CrowdManager {
    private static final Logger LOG = LoggerFactory.getLogger(CrowdManager.class);
    private static final Object O = new Object();
    private static final String APPLICATION_XML = "application/xml";
    private static final Header HEADER_ACCEPT_APPLICATION_XML = new Header("Accept", "application/xml");
    private static final Header HEADER_ACCEPT_CHARSET_UTF8 = new Header("Accept-Charset", "UTF-8");
    private static CrowdManager INSTANCE;
    private HttpClient client;
    private URI crowdServer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CrowdManager getInstance() {
        if (INSTANCE == null) {
            Object object = O;
            synchronized (object) {
                CrowdManager manager;
                if (INSTANCE == null && (manager = new CrowdManager()) != null) {
                    INSTANCE = manager;
                }
            }
        }
        return INSTANCE;
    }

    private CrowdManager() {
        try {
            CrowdProperties crowdProps = new CrowdProperties();
            MultiThreadedHttpConnectionManager threadedConnectionManager = new MultiThreadedHttpConnectionManager();
            HttpClient hc = new HttpClient((HttpConnectionManager)threadedConnectionManager);
            HttpClientParams hcParams = hc.getParams();
            hcParams.setAuthenticationPreemptive(true);
            HttpConnectionManagerParams hcConnectionParams = hc.getHttpConnectionManager().getParams();
            hcConnectionParams.setDefaultMaxConnectionsPerHost(crowdProps.getHttpMaxConnections());
            hcConnectionParams.setMaxTotalConnections(crowdProps.getHttpMaxConnections());
            hcConnectionParams.setConnectionTimeout(crowdProps.getHttpConnectionTimeout());
            hcConnectionParams.setSoTimeout(crowdProps.getHttpSocketTimeout());
            this.crowdServer = new URI(crowdProps.getCrowdServerUrl()).resolve("rest/usermanagement/latest/");
            HttpState httpState = hc.getState();
            UsernamePasswordCredentials crowdCreds = new UsernamePasswordCredentials(crowdProps.getApplicationName(), crowdProps.getApplicationPassword());
            httpState.setCredentials(new AuthScope(this.crowdServer.getHost(), this.crowdServer.getPort()), (Credentials)crowdCreds);
            if (StringUtils.isNotBlank((String)crowdProps.getHttpProxyHost()) && crowdProps.getHttpProxyPort() > 0) {
                hc.getHostConfiguration().setProxy(crowdProps.getHttpProxyHost(), crowdProps.getHttpProxyPort());
                if (StringUtils.isNotBlank((String)crowdProps.getHttpProxyUsername()) || StringUtils.isNotBlank((String)crowdProps.getHttpProxyPassword())) {
                    UsernamePasswordCredentials proxyCreds = new UsernamePasswordCredentials(crowdProps.getHttpProxyUsername(), crowdProps.getHttpProxyPassword());
                    httpState.setProxyCredentials(new AuthScope(crowdProps.getHttpProxyHost(), crowdProps.getHttpProxyPort()), (Credentials)proxyCreds);
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("HTTP Client config");
                LOG.debug(this.crowdServer.toString());
                LOG.debug("Max connections:" + hcConnectionParams.getMaxTotalConnections());
                LOG.debug("Socket timeout:" + hcConnectionParams.getSoTimeout());
                LOG.debug("Connect timeout:" + hcConnectionParams.getConnectionTimeout());
                LOG.debug("Proxy host:" + crowdProps.getHttpProxyHost() + ":" + crowdProps.getHttpProxyPort());
                LOG.debug("Crowd application name:" + crowdProps.getApplicationName());
            }
            this.client = hc;
        }
        catch (Exception e) {
            LOG.error("Failure to load the Crowd manager", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void authenticate(String username, String password) throws RemoteException {
        username = JID.unescapeNode((String)username);
        if (LOG.isDebugEnabled()) {
            LOG.debug("authenticate '" + String.valueOf(username) + "'");
        }
        PostMethod post = new PostMethod(this.crowdServer.resolve("authentication?username=" + this.urlEncode(username)).toString());
        AuthenticatePost creds = new AuthenticatePost();
        creds.value = password;
        try {
            StringWriter writer = new StringWriter();
            JAXB.marshal((Object)creds, (Writer)writer);
            post.setRequestEntity((RequestEntity)new StringRequestEntity(writer.toString(), APPLICATION_XML, "UTF-8"));
            int httpCode = this.client.executeMethod((HttpMethod)post);
            if (httpCode != 200) {
                this.handleHTTPError((HttpMethod)post);
            }
        }
        catch (IOException ioe) {
            this.handleError(ioe);
        }
        finally {
            post.releaseConnection();
        }
        LOG.info("authenticated user:" + username);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<User> getAllUsers() throws RemoteException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("fetching all crowd users");
        }
        int maxResults = 100;
        int startIndex = 0;
        ArrayList<User> results = new ArrayList<User>();
        StringBuilder request = new StringBuilder("search?entity-type=user&expand=user&restriction=active%3dtrue").append("&max-results=").append(maxResults).append("&start-index=");
        try {
            while (true) {
                GetMethod get = this.createGetMethodXmlResponse(this.crowdServer.resolve(request.toString() + startIndex));
                Users users = null;
                try {
                    int httpCode = this.client.executeMethod((HttpMethod)get);
                    if (httpCode != 200) {
                        this.handleHTTPError((HttpMethod)get);
                    }
                    users = (Users)JAXB.unmarshal((InputStream)get.getResponseBodyAsStream(), Users.class);
                }
                finally {
                    get.releaseConnection();
                }
                if (users != null && users.user != null) {
                    for (User user : users.user) {
                        user.name = JID.escapeNode((String)user.name);
                        results.add(user);
                    }
                    if (users.user.size() == maxResults) {
                        startIndex += maxResults;
                        continue;
                    }
                }
                break;
            }
        }
        catch (IOException ioe) {
            this.handleError(ioe);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getAllGroupNames() throws RemoteException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("fetch all crowd groups");
        }
        int maxResults = 100;
        int startIndex = 0;
        ArrayList<String> results = new ArrayList<String>();
        StringBuilder request = new StringBuilder("search?entity-type=group&restriction=active%3dtrue").append("&max-results=").append(maxResults).append("&start-index=");
        try {
            while (true) {
                GetMethod get = this.createGetMethodXmlResponse(this.crowdServer.resolve(request.toString() + startIndex));
                Groups groups = null;
                try {
                    int httpCode = this.client.executeMethod((HttpMethod)get);
                    if (httpCode != 200) {
                        this.handleHTTPError((HttpMethod)get);
                    }
                    groups = (Groups)JAXB.unmarshal((InputStream)get.getResponseBodyAsStream(), Groups.class);
                }
                finally {
                    get.releaseConnection();
                }
                if (groups != null && groups.group != null) {
                    for (Group group : groups.group) {
                        results.add(group.name);
                    }
                    if (groups.group.size() == maxResults) {
                        startIndex += maxResults;
                        continue;
                    }
                }
                break;
            }
        }
        catch (IOException ioe) {
            this.handleError(ioe);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getUserGroups(String username) throws RemoteException {
        username = JID.unescapeNode((String)username);
        if (LOG.isDebugEnabled()) {
            LOG.debug("fetch all crowd groups for user:" + username);
        }
        int maxResults = 100;
        int startIndex = 0;
        ArrayList<String> results = new ArrayList<String>();
        StringBuilder request = new StringBuilder("user/group/nested?username=").append(this.urlEncode(username)).append("&max-results=").append(maxResults).append("&start-index=");
        try {
            while (true) {
                GetMethod get = this.createGetMethodXmlResponse(this.crowdServer.resolve(request.toString() + startIndex));
                Groups groups = null;
                try {
                    int httpCode = this.client.executeMethod((HttpMethod)get);
                    if (httpCode != 200) {
                        this.handleHTTPError((HttpMethod)get);
                    }
                    groups = (Groups)JAXB.unmarshal((InputStream)get.getResponseBodyAsStream(), Groups.class);
                }
                finally {
                    get.releaseConnection();
                }
                if (groups != null && groups.group != null) {
                    for (Group group : groups.group) {
                        results.add(group.name);
                    }
                    if (groups.group.size() == maxResults) {
                        startIndex += maxResults;
                        continue;
                    }
                }
                break;
            }
        }
        catch (IOException ioe) {
            this.handleError(ioe);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Group getGroup(String groupName) throws RemoteException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Get group:" + groupName + " from crowd");
        }
        GetMethod get = this.createGetMethodXmlResponse(this.crowdServer.resolve("group?groupname=" + this.urlEncode(groupName)));
        Group group = null;
        try {
            int httpCode = this.client.executeMethod((HttpMethod)get);
            if (httpCode != 200) {
                this.handleHTTPError((HttpMethod)get);
            }
            group = (Group)JAXB.unmarshal((InputStream)get.getResponseBodyAsStream(), Group.class);
        }
        catch (IOException ioe) {
            this.handleError(ioe);
        }
        finally {
            get.releaseConnection();
        }
        return group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getGroupMembers(String groupName) throws RemoteException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Get all members for group:" + groupName);
        }
        int maxResults = 100;
        int startIndex = 0;
        ArrayList<String> results = new ArrayList<String>();
        StringBuilder request = new StringBuilder("group/user/nested?groupname=").append(this.urlEncode(groupName)).append("&max-results=").append(maxResults).append("&start-index=");
        try {
            while (true) {
                GetMethod get = this.createGetMethodXmlResponse(this.crowdServer.resolve(request.toString() + startIndex));
                Users users = null;
                try {
                    int httpCode = this.client.executeMethod((HttpMethod)get);
                    if (httpCode != 200) {
                        this.handleHTTPError((HttpMethod)get);
                    }
                    users = (Users)JAXB.unmarshal((InputStream)get.getResponseBodyAsStream(), Users.class);
                }
                finally {
                    get.releaseConnection();
                }
                if (users != null && users.user != null) {
                    for (User user : users.user) {
                        results.add(JID.escapeNode((String)user.name));
                    }
                    if (users.user.size() == maxResults) {
                        startIndex += maxResults;
                        continue;
                    }
                }
                break;
            }
        }
        catch (IOException ioe) {
            this.handleError(ioe);
        }
        return results;
    }

    private String urlEncode(String str) {
        try {
            return URLEncoder.encode(str, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            LOG.error("UTF-8 not supported ?", (Throwable)uee);
            return str;
        }
    }

    private void handleHTTPError(HttpMethod method) throws RemoteException {
        int status = method.getStatusCode();
        String statusText = method.getStatusText();
        String body = null;
        try {
            body = method.getResponseBodyAsString();
        }
        catch (IOException ioe) {
            LOG.warn("Unable to retreive Crowd http response body", (Throwable)ioe);
        }
        StringBuilder strBuf = new StringBuilder();
        strBuf.append("Crowd returned HTTP error code:").append(status);
        strBuf.append(" - ").append(statusText);
        if (StringUtils.isNotBlank((String)body)) {
            strBuf.append("\n").append(body);
        }
        throw new RemoteException(strBuf.toString());
    }

    private void handleError(Exception e) throws RemoteException {
        LOG.error("Error occured while consuming Crowd REST service", (Throwable)e);
        throw new RemoteException(e.getMessage());
    }

    private GetMethod createGetMethodXmlResponse(URI uri) {
        GetMethod get = new GetMethod(uri.toString());
        get.addRequestHeader(HEADER_ACCEPT_APPLICATION_XML);
        get.addRequestHeader(HEADER_ACCEPT_CHARSET_UTF8);
        return get;
    }
}

