/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.container;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.GenericServlet;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jasper.JspC;
import org.dom4j.Document;
import org.jivesoftware.admin.PluginFilter;
import org.jivesoftware.openfire.container.Plugin;
import org.jivesoftware.openfire.container.PluginClassLoader;
import org.jivesoftware.openfire.container.PluginDevEnvironment;
import org.jivesoftware.openfire.container.PluginManager;
import org.jivesoftware.openfire.container.PluginServletContext;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.StringUtils;
import org.jivesoftware.util.WebXmlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginServlet
extends HttpServlet {
    private static final Logger Log = LoggerFactory.getLogger(PluginServlet.class);
    private static Map<String, GenericServlet> servlets = new ConcurrentHashMap<String, GenericServlet>();
    private static PluginManager pluginManager;
    private static ServletConfig servletConfig;
    public static final String PLUGINS_WEBROOT = "/plugins/";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        servletConfig = config;
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String pathInfo = request.getPathInfo();
        if (pathInfo == null) {
            response.setStatus(404);
        } else {
            try {
                if (pathInfo.endsWith(".jsp")) {
                    if (this.handleDevJSP(pathInfo, request, response)) {
                        return;
                    }
                    this.handleJSP(pathInfo, request, response);
                } else if (this.getServlet(pathInfo) != null) {
                    this.handleServlet(pathInfo, request, response);
                } else {
                    this.handleOtherRequest(pathInfo, response);
                }
            }
            catch (Exception e) {
                Log.error(e.getMessage(), (Throwable)e);
                response.setStatus(500);
            }
        }
    }

    public static void registerServlets(PluginManager manager, final Plugin plugin, File webXML) {
        pluginManager = manager;
        if (!webXML.exists()) {
            Log.error("Could not register plugin servlets, file " + webXML.getAbsolutePath() + " does not exist.");
            return;
        }
        String pluginName = webXML.getParentFile().getParentFile().getParentFile().getName();
        try {
            final Document webXmlDoc = WebXmlUtils.asDocument(webXML);
            List<String> servletNames = WebXmlUtils.getServletNames(webXmlDoc);
            for (String servletName : servletNames) {
                Log.debug("Loading servlet '{}' of plugin '{}'...", (Object)servletName, (Object)pluginName);
                String className = WebXmlUtils.getServletClassName(webXmlDoc, servletName);
                if (className == null || className.isEmpty()) {
                    Log.warn("Could not load servlet '{}' of plugin '{}'. web-xml does not define a class name for this servlet.", (Object)servletName, (Object)pluginName);
                    continue;
                }
                Class theClass = manager.loadClass(plugin, className);
                Object instance = theClass.newInstance();
                if (!(instance instanceof GenericServlet)) {
                    Log.warn("Could not load servlet '{}' of plugin '{}'. Its class ({}) is not an instance of javax.servlet.GenericServlet.", new Object[]{servletName, pluginName, className});
                    continue;
                }
                Log.debug("Initializing servlet '{}' of plugin '{}'...", (Object)servletName, (Object)pluginName);
                ((GenericServlet)instance).init(servletConfig);
                Log.debug("Registering servlet '{}' of plugin '{}' URL patterns.", (Object)servletName, (Object)pluginName);
                Set<String> urlPatterns = WebXmlUtils.getServletUrlPatterns(webXmlDoc, servletName);
                for (String urlPattern : urlPatterns) {
                    servlets.put((pluginName + urlPattern).toLowerCase(), (GenericServlet)instance);
                }
                Log.debug("Servlet '{}' of plugin '{}' loaded successfully.", (Object)servletName, (Object)pluginName);
            }
            List<String> filterNames = WebXmlUtils.getFilterNames(webXmlDoc);
            for (final String filterName : filterNames) {
                Log.debug("Loading filter '{}' of plugin '{}'...", (Object)filterName, (Object)pluginName);
                String className = WebXmlUtils.getFilterClassName(webXmlDoc, filterName);
                if (className == null || className.isEmpty()) {
                    Log.warn("Could not load filter '{}' of plugin '{}'. web-xml does not define a class name for this filter.", (Object)filterName, (Object)pluginName);
                    continue;
                }
                Class theClass = manager.loadClass(plugin, className);
                Object instance = theClass.newInstance();
                if (!(instance instanceof Filter)) {
                    Log.warn("Could not load filter '{}' of plugin '{}'. Its class ({}) is not an instance of javax.servlet.Filter.", new Object[]{filterName, pluginName, className});
                    continue;
                }
                Log.debug("Initializing filter '{}' of plugin '{}'...", (Object)filterName, (Object)pluginName);
                ((Filter)instance).init(new FilterConfig(){

                    public String getFilterName() {
                        return filterName;
                    }

                    public ServletContext getServletContext() {
                        return new PluginServletContext(servletConfig.getServletContext(), pluginManager, plugin);
                    }

                    public String getInitParameter(String s) {
                        Map<String, String> params = WebXmlUtils.getFilterInitParams(webXmlDoc, filterName);
                        if (params == null || params.isEmpty()) {
                            return null;
                        }
                        return params.get(s);
                    }

                    public Enumeration<String> getInitParameterNames() {
                        Map<String, String> params = WebXmlUtils.getFilterInitParams(webXmlDoc, filterName);
                        if (params == null || params.isEmpty()) {
                            return Collections.emptyEnumeration();
                        }
                        return Collections.enumeration(params.keySet());
                    }
                });
                Log.debug("Registering filter '{}' of plugin '{}' URL patterns.", (Object)filterName, (Object)pluginName);
                Set<String> urlPatterns = WebXmlUtils.getFilterUrlPatterns(webXmlDoc, filterName);
                for (String urlPattern : urlPatterns) {
                    PluginFilter.addPluginFilter(urlPattern, (Filter)instance);
                }
                Log.debug("Filter '{}' of plugin '{}' loaded successfully.", (Object)filterName, (Object)pluginName);
            }
        }
        catch (Throwable e) {
            Log.error("An unexpected problem occurred while attempting to register servlets for plugin '{}'.", (Object)plugin, (Object)e);
        }
    }

    public static void unregisterServlets(File webXML) {
        if (!webXML.exists()) {
            Log.error("Could not unregister plugin servlets, file " + webXML.getAbsolutePath() + " does not exist.");
            return;
        }
        String pluginName = webXML.getParentFile().getParentFile().getParentFile().getName();
        try {
            Document webXmlDoc = WebXmlUtils.asDocument(webXML);
            List<String> servletNames = WebXmlUtils.getServletNames(webXmlDoc);
            for (String servletName : servletNames) {
                Log.debug("Unregistering servlet '{}' of plugin '{}'", (Object)servletName, (Object)pluginName);
                HashSet<GenericServlet> toDestroy = new HashSet<GenericServlet>();
                Set<String> urlPatterns = WebXmlUtils.getServletUrlPatterns(webXmlDoc, servletName);
                for (String string : urlPatterns) {
                    GenericServlet servlet = servlets.remove((pluginName + string).toLowerCase());
                    if (servlet == null) continue;
                    toDestroy.add(servlet);
                }
                for (Servlet servlet : toDestroy) {
                    servlet.destroy();
                }
                Log.debug("Servlet '{}' of plugin '{}' unregistered and destroyed successfully.", (Object)servletName, (Object)pluginName);
            }
            List<String> filterNames = WebXmlUtils.getFilterNames(webXmlDoc);
            for (String filterName : filterNames) {
                Log.debug("Unregistering filter '{}' of plugin '{}'", (Object)filterName, (Object)pluginName);
                HashSet<Filter> toDestroy = new HashSet<Filter>();
                String className = WebXmlUtils.getFilterClassName(webXmlDoc, filterName);
                Set<String> set = WebXmlUtils.getFilterUrlPatterns(webXmlDoc, filterName);
                for (String urlPattern : set) {
                    Filter filter = PluginFilter.removePluginFilter(urlPattern, className);
                    if (filter == null) continue;
                    toDestroy.add(filter);
                }
                for (Filter filter : toDestroy) {
                    filter.destroy();
                }
                Log.debug("Filter '{}' of plugin '{}' unregistered and destroyesd successfully.", (Object)filterName, (Object)pluginName);
            }
        }
        catch (Throwable e) {
            Log.error("An unexpected problem occurred while attempting to unregister servlets.", e);
        }
    }

    public static String registerServlet(PluginManager pluginManager, Plugin plugin, GenericServlet servlet, String relativeUrl) throws ServletException {
        String pluginName = pluginManager.getPluginDirectory(plugin).getName();
        PluginServlet.pluginManager = pluginManager;
        if (servlet == null) {
            throw new ServletException("Servlet is missing");
        }
        String pluginServletUrl = pluginName + relativeUrl;
        servlets.put((pluginName + relativeUrl).toLowerCase(), servlet);
        return PLUGINS_WEBROOT + pluginServletUrl;
    }

    public static GenericServlet unregisterServlet(Plugin plugin, String url) throws ServletException {
        String pluginName = pluginManager.getPluginDirectory(plugin).getName();
        if (url == null) {
            throw new ServletException("Servlet URL is missing");
        }
        String fullUrl = pluginName + url;
        GenericServlet servlet = servlets.remove(fullUrl.toLowerCase());
        return servlet;
    }

    private void handleJSP(String pathInfo, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String jspURL = pathInfo.substring(1);
        GenericServlet servlet = servlets.get(jspURL.toLowerCase());
        if (servlet != null) {
            servlet.service((ServletRequest)request, (ServletResponse)response);
        } else {
            response.setStatus(404);
        }
    }

    private void handleServlet(String pathInfo, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        GenericServlet servlet = this.getServlet(pathInfo);
        if (servlet != null) {
            servlet.service((ServletRequest)request, (ServletResponse)response);
        } else {
            response.setStatus(404);
        }
    }

    private GenericServlet getServlet(String pathInfo) {
        GenericServlet servlet = servlets.get(pathInfo = pathInfo.substring(1).toLowerCase());
        if (servlet == null) {
            for (String key : servlets.keySet()) {
                int index = key.indexOf("/*");
                String searchkey = key;
                if (index != -1) {
                    searchkey = key.substring(0, index);
                }
                if (!searchkey.startsWith(pathInfo) && !pathInfo.startsWith(searchkey)) continue;
                servlet = servlets.get(key);
                break;
            }
        }
        return servlet;
    }

    private void handleOtherRequest(String pathInfo, HttpServletResponse response) throws IOException {
        String[] parts = pathInfo.split("/");
        if (parts.length < 3) {
            response.setStatus(404);
            return;
        }
        String contextPath = "";
        int index = pathInfo.indexOf(parts[1]);
        if (index != -1) {
            contextPath = pathInfo.substring(index + parts[1].length());
        }
        File pluginDirectory = new File(JiveGlobals.getHomeDirectory(), "plugins");
        File file = new File(pluginDirectory, parts[1] + File.separator + "web" + contextPath);
        Plugin plugin = pluginManager.getPlugin(parts[1]);
        PluginDevEnvironment environment = pluginManager.getDevEnvironment(plugin);
        if (environment != null) {
            file = new File(environment.getWebRoot(), contextPath);
        }
        if (!file.exists()) {
            response.setStatus(404);
            return;
        }
        String contentType = "image/gif";
        if (pathInfo.endsWith(".png")) {
            contentType = "image/png";
        } else if (pathInfo.endsWith(".swf")) {
            contentType = "application/x-shockwave-flash";
        } else if (pathInfo.endsWith(".css")) {
            contentType = "text/css";
        } else if (pathInfo.endsWith(".js")) {
            contentType = "text/javascript";
        } else if (pathInfo.endsWith(".html") || pathInfo.endsWith(".htm")) {
            contentType = "text/html";
        }
        response.setContentType(contentType);
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
             ServletOutputStream out = response.getOutputStream();){
            int len;
            response.setContentLength((int)file.length());
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) != -1) {
                out.write(buf, 0, len);
            }
        }
    }

    private boolean handleDevJSP(String pathInfo, HttpServletRequest request, HttpServletResponse response) {
        String jspURL = pathInfo.substring(1);
        int fileSeperator = jspURL.indexOf("/");
        if (fileSeperator != -1) {
            File jspFile;
            String filename;
            int indexOfPeriod;
            String pluginName = jspURL.substring(0, fileSeperator);
            Plugin plugin = pluginManager.getPlugin(pluginName);
            PluginDevEnvironment environment = pluginManager.getDevEnvironment(plugin);
            if (environment == null) {
                return false;
            }
            File webDir = environment.getWebRoot();
            if (webDir == null || !webDir.exists()) {
                return false;
            }
            File pluginDirectory = pluginManager.getPluginDirectory(plugin);
            File compilationDir = new File(pluginDirectory, "classes");
            compilationDir.mkdirs();
            String jsp = jspURL.substring(fileSeperator + 1);
            int indexOfLastSlash = jsp.lastIndexOf("/");
            String relativeDir = "";
            if (indexOfLastSlash != -1) {
                relativeDir = jsp.substring(0, indexOfLastSlash);
                relativeDir = relativeDir.replaceAll("//", ".") + '.';
            }
            if ((indexOfPeriod = (filename = (jspFile = new File(webDir, jsp)).getName()).indexOf(".")) != -1) {
                filename = "dev" + StringUtils.randomString(4);
            }
            JspC jspc = new JspC();
            if (!jspFile.exists()) {
                return false;
            }
            try {
                jspc.setJspFiles(jspFile.getCanonicalPath());
            }
            catch (IOException e) {
                Log.error(e.getMessage(), (Throwable)e);
            }
            jspc.setOutputDir(compilationDir.getAbsolutePath());
            jspc.setClassName(filename);
            jspc.setCompile(true);
            jspc.setClassPath(PluginServlet.getClasspathForPlugin(plugin));
            jspc.execute();
            try {
                Object servletInstance = pluginManager.loadClass(plugin, "org.apache.jsp." + relativeDir + filename).newInstance();
                HttpServlet servlet = (HttpServlet)servletInstance;
                servlet.init(servletConfig);
                servlet.service((ServletRequest)request, (ServletResponse)response);
                return true;
            }
            catch (Exception e) {
                Log.error(e.getMessage(), (Throwable)e);
            }
        }
        return false;
    }

    private static String getClasspathForPlugin(Plugin plugin) {
        StringBuilder classpath = new StringBuilder();
        File pluginDirectory = pluginManager.getPluginDirectory(plugin);
        PluginDevEnvironment pluginEnv = pluginManager.getDevEnvironment(plugin);
        PluginClassLoader pluginClassloader = pluginManager.getPluginClassloader(plugin);
        for (URL url : pluginClassloader.getURLs()) {
            File file = new File(url.getFile());
            classpath.append(file.getAbsolutePath()).append(';');
        }
        File libDirectory = new File(pluginDirectory, "lib");
        File[] libs = libDirectory.listFiles();
        int no = libs != null ? libs.length : 0;
        for (int i = 0; i < no; ++i) {
            File libFile = libs[i];
            classpath.append(libFile.getAbsolutePath()).append(';');
        }
        File openfireRoot = pluginDirectory.getParentFile().getParentFile().getParentFile();
        File openfireLib = new File(openfireRoot, "target//lib");
        classpath.append(openfireLib.getAbsolutePath()).append("//servlet-api.jar;");
        classpath.append(openfireLib.getAbsolutePath()).append("//openfire.jar;");
        classpath.append(openfireLib.getAbsolutePath()).append("//jasper-compiler.jar;");
        classpath.append(openfireLib.getAbsolutePath()).append("//jasper-runtime.jar;");
        if (pluginEnv.getClassesDir() != null) {
            classpath.append(pluginEnv.getClassesDir().getAbsolutePath()).append(';');
        }
        return classpath.toString();
    }
}

