/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.container;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Deque;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.container.PluginManager;
import org.jivesoftware.openfire.container.PluginMetadataHelper;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginMonitor {
    private static final Logger Log = LoggerFactory.getLogger(PluginMonitor.class);
    private final PluginManager pluginManager;
    private ScheduledExecutorService executor;
    private boolean isTaskRunning = false;

    public PluginMonitor(PluginManager pluginManager) {
        this.pluginManager = pluginManager;
    }

    public void start() {
        if (this.executor != null) {
            this.executor.shutdown();
        }
        this.executor = new ScheduledThreadPoolExecutor(1);
        if (Boolean.getBoolean("developmentMode")) {
            this.executor.scheduleWithFixedDelay(new MonitorTask(), 0L, 5L, TimeUnit.SECONDS);
        } else {
            this.executor.scheduleWithFixedDelay(new MonitorTask(), 0L, 20L, TimeUnit.SECONDS);
        }
    }

    public void stop() {
        if (this.executor != null) {
            this.executor.shutdown();
        }
    }

    public boolean isTaskRunning() {
        return this.isTaskRunning;
    }

    public void runNow(boolean blockUntilDone) {
        Future<?> future = this.executor.submit(new MonitorTask());
        if (blockUntilDone) {
            try {
                future.get();
            }
            catch (Exception e) {
                Log.warn("An exception occurred while waiting for a check of the plugin directory to complete.", (Throwable)e);
            }
        }
    }

    private class MonitorTask
    implements Runnable {
        private MonitorTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            PluginMonitor pluginMonitor = PluginMonitor.this;
            synchronized (pluginMonitor) {
                PluginMonitor.this.isTaskRunning = true;
                try {
                    Path pluginsDirectory = PluginMonitor.this.pluginManager.getPluginsDirectory();
                    if (!Files.isDirectory(pluginsDirectory, new LinkOption[0]) || !Files.isReadable(pluginsDirectory)) {
                        Log.error("Unable to process plugins. The plugins directory does not exist (or is no directory): {}", (Object)pluginsDirectory);
                        return;
                    }
                    final HashSet<String> jarSet = new HashSet<String>();
                    try (DirectoryStream<Path> ds = Files.newDirectoryStream(pluginsDirectory, (DirectoryStream.Filter<? super Path>)new DirectoryStream.Filter<Path>(){

                        @Override
                        public boolean accept(Path path) throws IOException {
                            if (Files.isDirectory(path, new LinkOption[0])) {
                                return false;
                            }
                            String fileName = path.getFileName().toString().toLowerCase();
                            return fileName.endsWith(".jar") || fileName.endsWith(".war");
                        }
                    });){
                        for (Path jarFile : ds) {
                            String fileName = jarFile.getFileName().toString();
                            String canonicalPluginName = fileName.substring(0, fileName.length() - 4).toLowerCase();
                            jarSet.add(canonicalPluginName);
                            Path dir = pluginsDirectory.resolve(canonicalPluginName);
                            if (Files.exists(dir, new LinkOption[0]) && Files.getLastModifiedTime(jarFile, new LinkOption[0]).toMillis() > Files.getLastModifiedTime(dir, new LinkOption[0]).toMillis()) {
                                if (!PluginMonitor.this.pluginManager.isExecuted()) {
                                    int n = 0;
                                    while (!PluginManager.deleteDir(dir) && n++ < 5) {
                                        Thread.sleep(1000L);
                                    }
                                } else {
                                    PluginMonitor.this.pluginManager.unloadPlugin(canonicalPluginName);
                                }
                            }
                            if (!Files.notExists(dir, new LinkOption[0])) continue;
                            this.unzipPlugin(canonicalPluginName, jarFile, dir);
                        }
                    }
                    ds = Files.newDirectoryStream(pluginsDirectory, (DirectoryStream.Filter<? super Path>)new DirectoryStream.Filter<Path>(){

                        @Override
                        public boolean accept(Path path) throws IOException {
                            if (!Files.isDirectory(path, new LinkOption[0])) {
                                return false;
                            }
                            String pluginName = PluginMetadataHelper.getCanonicalName(path);
                            return !pluginName.equals("admin") && !jarSet.contains(pluginName);
                        }
                    });
                    var5_6 = null;
                    try {
                        for (Path path : ds) {
                            String pluginName = PluginMetadataHelper.getCanonicalName(path);
                            Log.info("Plugin '{}' was removed from the file system.", (Object)pluginName);
                            PluginMonitor.this.pluginManager.unloadPlugin(pluginName);
                        }
                    }
                    catch (Throwable throwable) {
                        var5_6 = throwable;
                        throw throwable;
                    }
                    finally {
                        if (ds != null) {
                            if (var5_6 != null) {
                                try {
                                    ds.close();
                                }
                                catch (Throwable throwable) {
                                    var5_6.addSuppressed(throwable);
                                }
                            } else {
                                ds.close();
                            }
                        }
                    }
                    ds = Files.newDirectoryStream(pluginsDirectory, (DirectoryStream.Filter<? super Path>)new DirectoryStream.Filter<Path>(){

                        @Override
                        public boolean accept(Path path) throws IOException {
                            return Files.isDirectory(path, new LinkOption[0]);
                        }
                    });
                    var5_6 = null;
                    try {
                        HashSet<Object> devPlugins = new HashSet<Object>();
                        String devPluginDirs = System.getProperty("pluginDirs");
                        if (devPluginDirs != null) {
                            StringTokenizer st = new StringTokenizer(devPluginDirs, ",");
                            while (st.hasMoreTokens()) {
                                try {
                                    String devPluginDir = st.nextToken().trim();
                                    Path devPluginPath = Paths.get(devPluginDir, new String[0]);
                                    if (Files.exists(devPluginPath, new LinkOption[0]) && Files.isDirectory(devPluginPath, new LinkOption[0])) {
                                        devPlugins.add(devPluginPath);
                                        continue;
                                    }
                                    Log.error("Unable to load a dev plugin as its path (as supplied in the 'pluginDirs' system property) does not exist, or is not a directory. Offending path: [{}] (parsed from raw value [{}])", (Object)devPluginPath, (Object)devPluginDir);
                                }
                                catch (InvalidPathException ex) {
                                    Log.error("Unable to load a dev plugin as an invalid path was added to the 'pluginDirs' system property.", (Throwable)ex);
                                }
                            }
                        }
                        Deque<List<Path>> dirs = this.sortPluginDirs(ds, devPlugins);
                        ArrayList<4> parallelProcesses = new ArrayList<4>();
                        for (final List list : dirs) {
                            parallelProcesses.add(new Callable<Integer>(){

                                @Override
                                public Integer call() throws Exception {
                                    int loaded = 0;
                                    for (Path path : list) {
                                        String canonicalName = PluginMetadataHelper.getCanonicalName(path);
                                        if (PluginMonitor.this.pluginManager.getPlugin(canonicalName) != null || !PluginMonitor.this.pluginManager.loadPlugin(canonicalName, path)) continue;
                                        ++loaded;
                                    }
                                    return loaded;
                                }
                            });
                        }
                        if (PluginMonitor.this.pluginManager.getPlugin("admin") == null) {
                            PluginMonitor.this.pluginManager.loadPlugin("admin", dirs.getFirst().get(0));
                        }
                        int parallelProcessMax = JiveGlobals.getIntProperty("plugins.loading.max-parallel", 4);
                        int n = PluginMonitor.this.pluginManager.isExecuted() ? 1 : parallelProcessMax;
                        ExecutorService executorService = Executors.newFixedThreadPool(n);
                        try {
                            List futures = executorService.invokeAll(parallelProcesses);
                            int pluginsLoaded = 0;
                            for (Future future : futures) {
                                pluginsLoaded += ((Integer)future.get()).intValue();
                            }
                            if (pluginsLoaded > 0 && !XMPPServer.getInstance().isSetupMode()) {
                                Log.info("Finished processing all plugins.");
                            }
                        }
                        finally {
                            executorService.shutdown();
                        }
                        PluginMonitor.this.pluginManager.firePluginsMonitored();
                    }
                    catch (Throwable throwable) {
                        var5_6 = throwable;
                        throw throwable;
                    }
                    finally {
                        if (ds != null) {
                            if (var5_6 != null) {
                                try {
                                    ds.close();
                                }
                                catch (Throwable throwable) {
                                    var5_6.addSuppressed(throwable);
                                }
                            } else {
                                ds.close();
                            }
                        }
                    }
                }
                catch (Throwable e) {
                    Log.error("An unexpected exception occurred:", e);
                }
                finally {
                    PluginMonitor.this.isTaskRunning = false;
                }
            }
        }

        private void unzipPlugin(String pluginName, Path file, Path dir) {
            try (JarFile zipFile = new JarFile(file.toFile());){
                if (((ZipFile)zipFile).getEntry("plugin.xml") == null) {
                    return;
                }
                Files.createDirectory(dir, new FileAttribute[0]);
                Files.setLastModifiedTime(dir, Files.getLastModifiedTime(file, new LinkOption[0]));
                Log.debug("Extracting plugin '{}'...", (Object)pluginName);
                Enumeration<? extends ZipEntry> e = ((ZipFile)zipFile).entries();
                while (e.hasMoreElements()) {
                    JarEntry entry = (JarEntry)e.nextElement();
                    Path entryFile = dir.resolve(entry.getName());
                    if (entry.getName().toLowerCase().endsWith("manifest.mf") || entry.isDirectory()) continue;
                    Files.createDirectories(entryFile.getParent(), new FileAttribute[0]);
                    InputStream zin = ((ZipFile)zipFile).getInputStream(entry);
                    Throwable throwable = null;
                    try {
                        Files.copy(zin, entryFile, StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (zin == null) continue;
                        if (throwable != null) {
                            try {
                                zin.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        zin.close();
                    }
                }
                Log.debug("Successfully extracted plugin '{}'.", (Object)pluginName);
            }
            catch (Exception e) {
                Log.error("An exception occurred while trying to extract plugin '{}':", (Object)pluginName, (Object)e);
            }
        }

        @SafeVarargs
        private final Deque<List<Path>> sortPluginDirs(Iterable<Path> ... dirs) {
            HashMap<String, Set<Path>> byParent = new HashMap<String, Set<Path>>();
            for (Iterable<Path> iterable : dirs) {
                Iterator<Path> iterator = iterable.iterator();
                while (iterator.hasNext()) {
                    Path dir = iterator.next();
                    String parent = PluginMetadataHelper.getParentPlugin(dir);
                    if (!byParent.containsKey(parent)) {
                        byParent.put(parent, new HashSet());
                    }
                    ((Set)byParent.get(parent)).add(dir);
                }
            }
            Node root = new Node();
            this.populateTree(root, byParent);
            for (Map.Entry entry : byParent.entrySet()) {
                if (((Set)entry.getValue()).isEmpty()) continue;
                for (Path path : (Set)entry.getValue()) {
                    String name = PluginMetadataHelper.getCanonicalName(path);
                    Log.warn("Unable to load plugin '{}' as its defined parent plugin '{}' is not installed.", (Object)name, entry.getKey());
                }
            }
            ArrayDeque<List<Path>> result = new ArrayDeque<List<Path>>();
            for (Node noParentPlugin : root.children) {
                ArrayList<Path> hierarchy = new ArrayList<Path>();
                this.walkTree(noParentPlugin, hierarchy);
                if (noParentPlugin.getName().equals("admin")) {
                    result.addFirst(hierarchy);
                    continue;
                }
                result.addLast(hierarchy);
            }
            return result;
        }

        private void populateTree(Node parent, Map<String, Set<Path>> byParent) {
            String parentName = parent.path == null ? null : PluginMetadataHelper.getCanonicalName(parent.path);
            Set<Path> children = byParent.remove(parentName);
            if (children != null) {
                for (Path child : children) {
                    Node node = new Node();
                    node.path = child;
                    if (!parent.children.add(node)) {
                        Log.warn("Detected plugin duplicates for name: '{}'. Only one plugin will be loaded.", (Object)node.getName());
                    }
                    this.populateTree(node, byParent);
                }
            }
        }

        private void walkTree(Node node, List<Path> result) {
            result.add(node.path);
            if (node.children != null) {
                for (Node child : node.children) {
                    this.walkTree(child, result);
                }
            }
        }

        class Node {
            Path path;
            SortedSet<Node> children = new TreeSet<Node>(new Comparator<Node>(){

                @Override
                public int compare(Node o1, Node o2) {
                    return o1.getName().compareToIgnoreCase(o2.getName());
                }
            });

            Node() {
            }

            String getName() {
                return PluginMetadataHelper.getCanonicalName(this.path);
            }
        }
    }
}

