/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.container;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.jar.JarFile;
import java.util.zip.ZipException;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.jivesoftware.admin.AdminConsole;
import org.jivesoftware.database.DbConnectionManager;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.container.Plugin;
import org.jivesoftware.openfire.container.PluginCacheConfigurator;
import org.jivesoftware.openfire.container.PluginCacheRegistry;
import org.jivesoftware.openfire.container.PluginClassLoader;
import org.jivesoftware.openfire.container.PluginDevEnvironment;
import org.jivesoftware.openfire.container.PluginListener;
import org.jivesoftware.openfire.container.PluginManagerListener;
import org.jivesoftware.openfire.container.PluginMetadata;
import org.jivesoftware.openfire.container.PluginMetadataHelper;
import org.jivesoftware.openfire.container.PluginMonitor;
import org.jivesoftware.openfire.container.PluginServlet;
import org.jivesoftware.util.JavaSpecVersion;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.LocaleUtils;
import org.jivesoftware.util.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginManager {
    private static final Logger Log = LoggerFactory.getLogger(PluginManager.class);
    private final Path pluginDirectory;
    private final Map<String, Plugin> pluginsLoaded = new TreeMap<String, Plugin>(String.CASE_INSENSITIVE_ORDER);
    private final Map<Plugin, PluginClassLoader> classloaders = new HashMap<Plugin, PluginClassLoader>();
    private final Map<String, Path> pluginDirs = new HashMap<String, Path>();
    private final Map<String, PluginMetadata> pluginMetadata = new TreeMap<String, PluginMetadata>(String.CASE_INSENSITIVE_ORDER);
    private final Map<Plugin, PluginDevEnvironment> pluginDevelopment = new HashMap<Plugin, PluginDevEnvironment>();
    private final Map<Plugin, List<String>> parentPluginMap = new HashMap<Plugin, List<String>>();
    private final Map<Plugin, String> childPluginMap = new HashMap<Plugin, String>();
    private final Set<PluginListener> pluginListeners = new CopyOnWriteArraySet<PluginListener>();
    private final Set<PluginManagerListener> pluginManagerListeners = new CopyOnWriteArraySet<PluginManagerListener>();
    private final Map<String, Integer> failureToLoadCount = new HashMap<String, Integer>();
    private final PluginMonitor pluginMonitor;
    private boolean executed = false;

    public PluginManager(File pluginDir) {
        this.pluginDirectory = pluginDir.toPath();
        this.pluginMonitor = new PluginMonitor(this);
    }

    public synchronized void start() {
        this.pluginMonitor.start();
    }

    public synchronized void shutdown() {
        Log.info("Shutting down. Unloading all loaded plugins...");
        this.pluginMonitor.stop();
        for (Map.Entry<String, Plugin> plugin : this.pluginsLoaded.entrySet()) {
            try {
                plugin.getValue().destroyPlugin();
                Log.info("Unloaded plugin '{}'.", (Object)plugin.getKey());
            }
            catch (Exception e) {
                Log.error("An exception occurred while trying to unload plugin '{}':", (Object)plugin.getKey(), (Object)e);
            }
        }
        this.pluginsLoaded.clear();
        this.pluginDirs.clear();
        this.pluginMetadata.clear();
        this.classloaders.clear();
        this.pluginDevelopment.clear();
        this.childPluginMap.clear();
        this.failureToLoadCount.clear();
    }

    public Path getPluginsDirectory() {
        return this.pluginDirectory;
    }

    public boolean installPlugin(InputStream in, String pluginFilename) {
        if (pluginFilename == null || pluginFilename.isEmpty()) {
            Log.error("Error installing plugin: pluginFilename was null or empty.");
            return false;
        }
        if (in == null) {
            Log.error("Error installing plugin '{}': Input stream was null.", (Object)pluginFilename);
            return false;
        }
        try {
            pluginFilename = Paths.get(pluginFilename, new String[0]).getFileName().toString();
            Path absolutePath = this.pluginDirectory.resolve(pluginFilename);
            Path partFile = this.pluginDirectory.resolve(pluginFilename + ".part");
            Files.copy(in, partFile, StandardCopyOption.REPLACE_EXISTING);
            try {
                JarFile file = new JarFile(partFile.toFile());
                Throwable throwable = null;
                if (file != null) {
                    if (throwable != null) {
                        try {
                            file.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    } else {
                        file.close();
                    }
                }
            }
            catch (ZipException e) {
                Files.deleteIfExists(partFile);
                throw e;
            }
            Files.move(partFile, absolutePath, StandardCopyOption.REPLACE_EXISTING);
            this.pluginMonitor.runNow(true);
        }
        catch (IOException e) {
            Log.error("An exception occurred while installing new version of plugin '{}':", (Object)pluginFilename, (Object)e);
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isInstalled(final String canonicalName) {
        DirectoryStream.Filter<Path> filter = new DirectoryStream.Filter<Path>(){

            @Override
            public boolean accept(Path entry) throws IOException {
                String name = entry.getFileName().toString();
                return Files.exists(entry, new LinkOption[0]) && !Files.isDirectory(entry, new LinkOption[0]) && (name.equalsIgnoreCase(canonicalName + ".jar") || name.equalsIgnoreCase(canonicalName + ".war"));
            }
        };
        try (DirectoryStream<Path> paths = Files.newDirectoryStream(this.pluginDirectory, (DirectoryStream.Filter<? super Path>)filter);){
            boolean bl = paths.iterator().hasNext();
            return bl;
        }
        catch (IOException e) {
            Log.error("Unable to determine if plugin '{}' is installed.", (Object)canonicalName, (Object)e);
            return this.pluginsLoaded.containsKey(canonicalName);
        }
    }

    public boolean isExtracted(String canonicalName) {
        return this.pluginMetadata.containsKey(canonicalName);
    }

    public boolean isLoaded(String canonicalName) {
        return this.pluginsLoaded.containsKey(canonicalName);
    }

    public Map<String, PluginMetadata> getMetadataExtractedPlugins() {
        return Collections.unmodifiableMap(this.pluginMetadata);
    }

    public PluginMetadata getMetadata(String canonicalName) {
        return this.pluginMetadata.get(canonicalName);
    }

    public Collection<Plugin> getPlugins() {
        return Collections.unmodifiableCollection(Arrays.asList(this.pluginsLoaded.values().toArray(new Plugin[this.pluginsLoaded.size()])));
    }

    public String getCanonicalName(Plugin plugin) {
        for (Map.Entry<String, Plugin> entry : this.pluginsLoaded.entrySet()) {
            if (!entry.getValue().equals(plugin)) continue;
            return entry.getKey();
        }
        return null;
    }

    public Plugin getPlugin(String canonicalName) {
        return this.pluginsLoaded.get(canonicalName.toLowerCase());
    }

    @Deprecated
    public File getPluginDirectory(Plugin plugin) {
        return this.getPluginPath(plugin).toFile();
    }

    public Path getPluginPath(Plugin plugin) {
        String canonicalName = this.getCanonicalName(plugin);
        if (canonicalName != null) {
            return this.pluginDirs.get(canonicalName);
        }
        return null;
    }

    public boolean isExecuted() {
        return this.executed;
    }

    boolean loadPlugin(String canonicalName, Path pluginDir) {
        PluginMetadata metadata = PluginMetadata.getInstance(pluginDir);
        this.pluginMetadata.put(canonicalName, metadata);
        if (XMPPServer.getInstance().isSetupMode() && !canonicalName.equals("admin")) {
            return false;
        }
        if (this.failureToLoadCount.containsKey(canonicalName) && this.failureToLoadCount.get(canonicalName) > JiveGlobals.getIntProperty("plugins.loading.retries", 5)) {
            Log.debug("The unloaded file for plugin '{}' is silently ignored, as it has failed to load repeatedly.", (Object)canonicalName);
            return false;
        }
        Log.debug("Loading plugin '{}'...", (Object)canonicalName);
        try {
            Path customWebXML;
            Path webXML;
            PluginClassLoader pluginLoader;
            Version compareVersion;
            Path pluginConfig = pluginDir.resolve("plugin.xml");
            if (!Files.exists(pluginConfig, new LinkOption[0])) {
                Log.warn("Plugin '{}' could not be loaded: no plugin.xml file found.", (Object)canonicalName);
                this.failureToLoadCount.put(canonicalName, Integer.MAX_VALUE);
                return false;
            }
            Version currentServerVersion = XMPPServer.getInstance().getServerInfo().getVersion();
            if (metadata.getMinServerVersion() != null) {
                compareVersion = new Version(currentServerVersion.getMajor(), currentServerVersion.getMinor(), currentServerVersion.getMicro(), null, -1);
                if (metadata.getMinServerVersion().isNewerThan(compareVersion)) {
                    Log.warn("Ignoring plugin '{}': requires server version {}. Current server version is {}.", new Object[]{canonicalName, metadata.getMinServerVersion(), currentServerVersion});
                    this.failureToLoadCount.put(canonicalName, Integer.MAX_VALUE);
                    return false;
                }
            }
            if (metadata.getPriorToServerVersion() != null) {
                compareVersion = new Version(currentServerVersion.getMajor(), currentServerVersion.getMinor(), currentServerVersion.getMicro(), null, -1);
                if (!metadata.getPriorToServerVersion().isNewerThan(compareVersion)) {
                    Log.warn("Ignoring plugin '{}': compatible with server versions up to but excluding {}. Current server version is {}.", new Object[]{canonicalName, metadata.getPriorToServerVersion(), currentServerVersion});
                    this.failureToLoadCount.put(canonicalName, Integer.MAX_VALUE);
                    return false;
                }
            }
            if (metadata.getMinJavaVersion() != null) {
                JavaSpecVersion runtimeVersion = new JavaSpecVersion(System.getProperty("java.specification.version"));
                if (metadata.getMinJavaVersion().isNewerThan(runtimeVersion)) {
                    Log.warn("Ignoring plugin '{}': requires Java specification version {}. Openfire is currently running in Java {}.", new Object[]{canonicalName, metadata.getMinJavaVersion(), System.getProperty("java.specification.version")});
                    this.failureToLoadCount.put(canonicalName, Integer.MAX_VALUE);
                    return false;
                }
            }
            String devModeClassesDir = System.getProperty(canonicalName + ".classes");
            String devModewebRoot = System.getProperty(canonicalName + ".webRoot");
            boolean devMode = devModewebRoot != null || devModeClassesDir != null;
            PluginDevEnvironment dev = devMode ? this.configurePluginDevEnvironment(pluginDir, devModeClassesDir, devModewebRoot) : null;
            String parentPluginName = null;
            Plugin parentPlugin = null;
            String parentCanonicalName = PluginMetadataHelper.getParentPlugin(pluginDir);
            if (parentCanonicalName != null) {
                for (Map.Entry<String, Plugin> entry : this.pluginsLoaded.entrySet()) {
                    if (!entry.getKey().equalsIgnoreCase(parentCanonicalName)) continue;
                    parentPluginName = entry.getKey();
                    parentPlugin = entry.getValue();
                    break;
                }
                if (parentPlugin == null) {
                    Log.info("Unable to load plugin '{}': parent plugin '{}' has not been loaded.", (Object)canonicalName, (Object)parentCanonicalName);
                    Integer count = this.failureToLoadCount.get(canonicalName);
                    if (count == null) {
                        count = 0;
                    }
                    count = count + 1;
                    this.failureToLoadCount.put(canonicalName, count);
                    return false;
                }
                pluginLoader = this.classloaders.get(parentPlugin);
            } else {
                pluginLoader = new PluginClassLoader();
            }
            pluginLoader.addDirectory(pluginDir.toFile(), devMode);
            if (dev != null && dev.getClassesDir() != null) {
                pluginLoader.addURLFile(dev.getClassesDir().toURI().toURL());
            }
            SAXReader saxReader = new SAXReader();
            saxReader.setEncoding("UTF-8");
            Document pluginXML = saxReader.read(pluginConfig.toFile());
            String className = pluginXML.selectSingleNode("/plugin/class").getText().trim();
            Plugin plugin = (Plugin)pluginLoader.loadClass(className).newInstance();
            this.classloaders.put(plugin, pluginLoader);
            this.pluginsLoaded.put(canonicalName, plugin);
            this.pluginDirs.put(canonicalName, pluginDir);
            if (dev != null) {
                this.pluginDevelopment.put(plugin, dev);
            }
            if (parentPlugin != null) {
                List<String> childrenPlugins = this.parentPluginMap.get(parentPlugin);
                if (childrenPlugins == null) {
                    childrenPlugins = new ArrayList<String>();
                    this.parentPluginMap.put(parentPlugin, childrenPlugins);
                }
                childrenPlugins.add(canonicalName);
                this.childPluginMap.put(plugin, parentPluginName);
            }
            if (!DbConnectionManager.getSchemaManager().checkPluginSchema(plugin)) {
                Log.error("Error while loading plugin '{}': {}", (Object)canonicalName, (Object)LocaleUtils.getLocalizedString("upgrade.database.failure"));
            }
            if (Files.exists(webXML = pluginDir.resolve("web").resolve("WEB-INF").resolve("web.xml"), new LinkOption[0])) {
                PluginServlet.registerServlets(this, plugin, webXML.toFile());
            }
            if (Files.exists(customWebXML = pluginDir.resolve("web").resolve("WEB-INF").resolve("web-custom.xml"), new LinkOption[0])) {
                PluginServlet.registerServlets(this, plugin, customWebXML.toFile());
            }
            this.configureCaches(pluginDir, canonicalName);
            ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(pluginLoader);
            plugin.initializePlugin(this, pluginDir.toFile());
            Log.debug("Initialized plugin '{}'.", (Object)canonicalName);
            Thread.currentThread().setContextClassLoader(oldLoader);
            Element adminElement = (Element)pluginXML.selectSingleNode("/plugin/adminconsole");
            if (adminElement != null) {
                String[] elementNames;
                Element imageEl;
                Element appName = (Element)adminElement.selectSingleNode("/plugin/adminconsole/global/appname");
                if (appName != null) {
                    appName.addAttribute("plugin", canonicalName);
                }
                if ((imageEl = (Element)adminElement.selectSingleNode("/plugin/adminconsole/global/logo-image")) != null) {
                    imageEl.setText("plugins/" + canonicalName + "/" + imageEl.getText());
                    imageEl.addAttribute("plugin", canonicalName);
                }
                if ((imageEl = (Element)adminElement.selectSingleNode("/plugin/adminconsole/global/login-image")) != null) {
                    imageEl.setText("plugins/" + canonicalName + "/" + imageEl.getText());
                    imageEl.addAttribute("plugin", canonicalName);
                }
                List urls = adminElement.selectNodes("//@url");
                for (Object url : urls) {
                    Attribute attr = (Attribute)url;
                    attr.setValue("plugins/" + canonicalName + "/" + attr.getValue());
                }
                for (String elementName : elementNames = new String[]{"tab", "sidebar", "item"}) {
                    List values = adminElement.selectNodes("//" + elementName);
                    for (Object value : values) {
                        Element element = (Element)value;
                        if (element.attribute("name") == null && element.attribute("value") == null) continue;
                        element.addAttribute("plugin", canonicalName);
                    }
                }
                AdminConsole.addModel(canonicalName, adminElement);
            }
            this.firePluginCreatedEvent(canonicalName, plugin);
            Log.info("Successfully loaded plugin '{}'.", (Object)canonicalName);
            return true;
        }
        catch (Throwable e) {
            Log.error("An exception occurred while loading plugin '{}':", (Object)canonicalName, (Object)e);
            Integer count = this.failureToLoadCount.get(canonicalName);
            if (count == null) {
                count = 0;
            }
            count = count + 1;
            this.failureToLoadCount.put(canonicalName, count);
            return false;
        }
    }

    private PluginDevEnvironment configurePluginDevEnvironment(Path pluginDir, String classesDir, String webRoot) throws IOException {
        String pluginName = pluginDir.getFileName().toString();
        Path compilationClassesDir = pluginDir.resolve("classes");
        if (Files.notExists(compilationClassesDir, new LinkOption[0])) {
            Files.createDirectory(compilationClassesDir, new FileAttribute[0]);
        }
        compilationClassesDir.toFile().deleteOnExit();
        PluginDevEnvironment dev = new PluginDevEnvironment();
        Log.info("Plugin '{}' is running in development mode.", (Object)pluginName);
        if (webRoot != null) {
            Path webRootDir = Paths.get(webRoot, new String[0]);
            if (Files.notExists(webRootDir, new LinkOption[0])) {
                webRootDir = pluginDir.resolve(webRoot);
            }
            if (Files.exists(webRootDir, new LinkOption[0])) {
                dev.setWebRoot(webRootDir.toFile());
            }
        }
        if (classesDir != null) {
            Path classes = Paths.get(classesDir, new String[0]);
            if (Files.notExists(classes, new LinkOption[0])) {
                classes = pluginDir.resolve(classesDir);
            }
            if (Files.exists(classes, new LinkOption[0])) {
                dev.setClassesDir(classes.toFile());
            }
        }
        return dev;
    }

    private void configureCaches(Path pluginDir, String pluginName) {
        Path cacheConfig = pluginDir.resolve("cache-config.xml");
        if (Files.exists(cacheConfig, new LinkOption[0])) {
            PluginCacheConfigurator configurator = new PluginCacheConfigurator();
            try {
                configurator.setInputStream(new BufferedInputStream(Files.newInputStream(cacheConfig, new OpenOption[0])));
                configurator.configure(pluginName);
            }
            catch (Exception e) {
                Log.error("An exception occurred while trying to configure caches for plugin '{}':", (Object)pluginName, (Object)e);
            }
        }
    }

    public void deletePlugin(final String pluginName) {
        Log.debug("Deleting plugin '{}'...", (Object)pluginName);
        try (DirectoryStream<Path> ds = Files.newDirectoryStream(this.getPluginsDirectory(), (DirectoryStream.Filter<? super Path>)new DirectoryStream.Filter<Path>(){

            @Override
            public boolean accept(Path path) throws IOException {
                if (Files.isDirectory(path, new LinkOption[0])) {
                    return false;
                }
                String fileName = path.getFileName().toString().toLowerCase();
                return fileName.equals(pluginName + ".jar") || fileName.equals(pluginName + ".war");
            }
        });){
            for (Path pluginFile : ds) {
                try {
                    Files.delete(pluginFile);
                    this.pluginMonitor.runNow(true);
                }
                catch (IOException ex) {
                    Log.warn("Unable to delete plugin '{}', as the plugin jar/war file cannot be deleted. File path: {}", new Object[]{pluginName, pluginFile, ex});
                }
            }
        }
        catch (Throwable e) {
            Log.error("An unexpected exception occurred while deleting plugin '{}'.", (Object)pluginName, (Object)e);
        }
    }

    public boolean reloadPlugin(String pluginName) {
        Log.debug("Reloading plugin '{}'...");
        Plugin plugin = this.getPlugin(pluginName);
        if (plugin == null) {
            Log.warn("Unable to reload plugin '{}'. No such plugin loaded.", (Object)pluginName);
            return false;
        }
        Path path = this.getPluginPath(plugin);
        if (path == null) {
            throw new IllegalStateException("Unable to determine installation path of plugin: " + pluginName);
        }
        try {
            Files.setLastModifiedTime(path, FileTime.fromMillis(0L));
        }
        catch (IOException e) {
            Log.warn("Unable to reload plugin '{}'. Unable to reset the 'last modified time' of the plugin path. Try removing and restoring the plugin jar file manually.");
            return false;
        }
        this.pluginMonitor.runNow(false);
        return true;
    }

    void unloadPlugin(String canonicalName) {
        Log.debug("Unloading plugin '{}'...", (Object)canonicalName);
        this.failureToLoadCount.remove(canonicalName);
        Plugin plugin = this.pluginsLoaded.get(canonicalName);
        if (plugin != null) {
            Path customWebXML;
            Path webXML;
            this.pluginDevelopment.remove(plugin);
            if (this.parentPluginMap.containsKey(plugin)) {
                String[] childPlugins;
                for (String childPlugin : childPlugins = this.parentPluginMap.get(plugin).toArray(new String[this.parentPluginMap.get(plugin).size()])) {
                    Log.debug("Unloading child plugin: '{}'.", (Object)childPlugin);
                    this.childPluginMap.remove(this.pluginsLoaded.get(childPlugin));
                    this.unloadPlugin(childPlugin);
                }
                this.parentPluginMap.remove(plugin);
            }
            if (Files.exists(webXML = this.pluginDirectory.resolve(canonicalName).resolve("web").resolve("WEB-INF").resolve("web.xml"), new LinkOption[0])) {
                AdminConsole.removeModel(canonicalName);
                PluginServlet.unregisterServlets(webXML.toFile());
            }
            if (Files.exists(customWebXML = this.pluginDirectory.resolve(canonicalName).resolve("web").resolve("WEB-INF").resolve("web-custom.xml"), new LinkOption[0])) {
                PluginServlet.unregisterServlets(customWebXML.toFile());
            }
            try {
                plugin.destroyPlugin();
                Log.debug("Destroyed plugin '{}'.", (Object)canonicalName);
            }
            catch (Exception e) {
                Log.error("An exception occurred while unloading plugin '{}':", (Object)canonicalName, (Object)e);
            }
        }
        this.pluginsLoaded.remove(canonicalName);
        Path pluginFile = this.pluginDirs.remove(canonicalName);
        PluginClassLoader pluginLoader = this.classloaders.remove(plugin);
        PluginMetadata metadata = this.pluginMetadata.remove(canonicalName);
        if (pluginLoader != null) {
            pluginLoader.unloadJarFiles();
        } else {
            Log.warn("No plugin loader found for '{}'.", (Object)canonicalName);
        }
        Path dir = this.pluginDirectory.resolve(canonicalName);
        try {
            Thread.sleep(2000L);
            System.gc();
            int count = 0;
            while (!PluginManager.deleteDir(dir) && count++ < 5) {
                Log.warn("Error unloading plugin '{}'. Will attempt again momentarily.", (Object)canonicalName);
                Thread.sleep(8000L);
                System.gc();
            }
        }
        catch (InterruptedException e) {
            Log.debug("Stopped waiting for plugin '{}' to be fully unloaded.", (Object)canonicalName, (Object)e);
        }
        if (plugin != null && Files.notExists(dir, new LinkOption[0])) {
            PluginCacheRegistry.getInstance().unregisterCaches(canonicalName);
            if (this.childPluginMap.containsKey(plugin)) {
                String parentPluginName = this.childPluginMap.get(plugin);
                Plugin parentPlugin = this.pluginsLoaded.get(parentPluginName);
                List<String> childrenPlugins = this.parentPluginMap.get(parentPlugin);
                childrenPlugins.remove(canonicalName);
                this.childPluginMap.remove(plugin);
                if (parentPlugin instanceof PluginListener) {
                    PluginListener listener = (PluginListener)((Object)parentPlugin);
                    listener.pluginDestroyed(canonicalName, plugin);
                }
                this.unloadPlugin(parentPluginName);
            }
            this.firePluginDestroyedEvent(canonicalName, plugin);
            Log.info("Successfully unloaded plugin '{}'.", (Object)canonicalName);
        } else if (plugin != null) {
            Log.info("Restore references since we failed to remove the plugin '{}'.", (Object)canonicalName);
            this.pluginsLoaded.put(canonicalName, plugin);
            this.pluginDirs.put(canonicalName, pluginFile);
            this.classloaders.put(plugin, pluginLoader);
            this.pluginMetadata.put(canonicalName, metadata);
        }
    }

    public Class loadClass(Plugin plugin, String className) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        PluginClassLoader loader = this.classloaders.get(plugin);
        return loader.loadClass(className);
    }

    public PluginDevEnvironment getDevEnvironment(Plugin plugin) {
        return this.pluginDevelopment.get(plugin);
    }

    @Deprecated
    public String getName(Plugin plugin) {
        return PluginMetadataHelper.getName(plugin);
    }

    @Deprecated
    public String getDescription(Plugin plugin) {
        return PluginMetadataHelper.getDescription(plugin);
    }

    @Deprecated
    public String getAuthor(Plugin plugin) {
        return PluginMetadataHelper.getAuthor(plugin);
    }

    @Deprecated
    public String getVersion(Plugin plugin) {
        return PluginMetadataHelper.getVersion(plugin).getVersionString();
    }

    @Deprecated
    public String getMinServerVersion(Plugin plugin) {
        return PluginMetadataHelper.getMinServerVersion(plugin).getVersionString();
    }

    @Deprecated
    public String getDatabaseKey(Plugin plugin) {
        return PluginMetadataHelper.getDatabaseKey(plugin);
    }

    @Deprecated
    public int getDatabaseVersion(Plugin plugin) {
        return PluginMetadataHelper.getDatabaseVersion(plugin);
    }

    @Deprecated
    public String getLicense(Plugin plugin) {
        return PluginMetadataHelper.getLicense(plugin);
    }

    public PluginClassLoader getPluginClassloader(Plugin plugin) {
        return this.classloaders.get(plugin);
    }

    static boolean deleteDir(Path dir) {
        try {
            if (Files.isDirectory(dir, new LinkOption[0])) {
                Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        try {
                            Files.deleteIfExists(file);
                        }
                        catch (IOException e) {
                            Log.debug("Plugin removal: could not delete: {}", (Object)file);
                            throw e;
                        }
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                        try {
                            Files.deleteIfExists(dir);
                        }
                        catch (IOException e) {
                            Log.debug("Plugin removal: could not delete: {}", (Object)dir);
                            throw e;
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            return Files.notExists(dir, new LinkOption[0]) || Files.deleteIfExists(dir);
        }
        catch (IOException e) {
            return Files.notExists(dir, new LinkOption[0]);
        }
    }

    public void addPluginListener(PluginListener listener) {
        this.pluginListeners.add(listener);
    }

    public void removePluginListener(PluginListener listener) {
        this.pluginListeners.remove(listener);
    }

    public void addPluginManagerListener(PluginManagerListener listener) {
        this.pluginManagerListeners.add(listener);
        if (this.isExecuted()) {
            this.firePluginsMonitored();
        }
    }

    public void removePluginManagerListener(PluginManagerListener listener) {
        this.pluginManagerListeners.remove(listener);
    }

    void firePluginCreatedEvent(String name, Plugin plugin) {
        for (PluginListener listener : this.pluginListeners) {
            try {
                listener.pluginCreated(name, plugin);
            }
            catch (Exception ex) {
                Log.warn("An exception was thrown when one of the pluginManagerListeners was notified of a 'created' event for plugin '{}'!", (Object)name, (Object)ex);
            }
        }
    }

    void firePluginDestroyedEvent(String name, Plugin plugin) {
        for (PluginListener listener : this.pluginListeners) {
            try {
                listener.pluginDestroyed(name, plugin);
            }
            catch (Exception ex) {
                Log.warn("An exception was thrown when one of the pluginManagerListeners was notified of a 'destroyed' event for plugin '{}'!", (Object)name, (Object)ex);
            }
        }
    }

    void firePluginsMonitored() {
        if (!XMPPServer.getInstance().isSetupMode()) {
            this.executed = true;
        }
        for (PluginManagerListener listener : this.pluginManagerListeners) {
            try {
                listener.pluginsMonitored();
            }
            catch (Exception ex) {
                Log.warn("An exception was thrown when one of the pluginManagerListeners was notified of a 'monitored' event!", (Throwable)ex);
            }
        }
    }

    public boolean isMonitorTaskRunning() {
        return this.pluginMonitor.isTaskRunning();
    }
}

