/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.component;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.dom4j.Element;
import org.jivesoftware.openfire.PacketException;
import org.jivesoftware.openfire.PacketRouter;
import org.jivesoftware.openfire.RoutableChannelHandler;
import org.jivesoftware.openfire.RoutingTable;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.component.ComponentEventListener;
import org.jivesoftware.openfire.component.NotifyComponentInfo;
import org.jivesoftware.openfire.component.NotifyComponentRegistered;
import org.jivesoftware.openfire.component.NotifyComponentUnregistered;
import org.jivesoftware.openfire.container.BasicModule;
import org.jivesoftware.openfire.disco.IQDiscoItemsHandler;
import org.jivesoftware.openfire.session.ComponentSession;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.cache.CacheFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.component.Component;
import org.xmpp.component.ComponentException;
import org.xmpp.component.ComponentManager;
import org.xmpp.component.ComponentManagerFactory;
import org.xmpp.component.IQResultListener;
import org.xmpp.packet.IQ;
import org.xmpp.packet.JID;
import org.xmpp.packet.Packet;
import org.xmpp.packet.Presence;

public class InternalComponentManager
extends BasicModule
implements ComponentManager,
RoutableChannelHandler {
    private static final Logger Log = LoggerFactory.getLogger(InternalComponentManager.class);
    private final Map<String, RoutableComponents> routables = new ConcurrentHashMap<String, RoutableComponents>();
    private Map<String, IQ> componentInfo = new ConcurrentHashMap<String, IQ>();
    private Map<JID, JID> presenceMap = new ConcurrentHashMap<JID, JID>();
    private List<ComponentEventListener> listeners = new CopyOnWriteArrayList<ComponentEventListener>();
    private static InternalComponentManager instance;
    private JID serviceAddress;
    private String serverDomain;
    private RoutingTable routingTable;

    public InternalComponentManager() {
        super("Internal Component Manager");
        instance = this;
    }

    public static InternalComponentManager getInstance() {
        return instance;
    }

    @Override
    public void initialize(XMPPServer server) {
        super.initialize(server);
        this.routingTable = server.getRoutingTable();
    }

    @Override
    public void start() {
        ComponentManagerFactory.setComponentManager((ComponentManager)instance);
        XMPPServer server = XMPPServer.getInstance();
        this.serverDomain = server.getServerInfo().getXMPPDomain();
        this.serviceAddress = new JID(null, "component." + this.serverDomain, null);
        if (!server.isSetupMode()) {
            server.getRoutingTable().addComponentRoute(this.getAddress(), this);
        }
    }

    @Override
    public void stop() {
        super.stop();
        if (this.getAddress() != null) {
            XMPPServer.getInstance().getRoutingTable().removeComponentRoute(this.getAddress());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addComponent(String subdomain, Component component) throws ComponentException {
        Map<String, RoutableComponents> map = this.routables;
        synchronized (map) {
            RoutableComponents routable = this.routables.get(subdomain);
            if (routable != null && routable.hasComponent(component).booleanValue()) {
                return;
            }
            Log.debug("InternalComponentManager: Registering component for domain: " + subdomain);
            JID componentJID = new JID(subdomain + "." + this.serverDomain);
            boolean notifyListeners = false;
            if (routable != null) {
                routable.addComponent(component);
            } else {
                routable = new RoutableComponents(componentJID, component);
                this.routables.put(subdomain, routable);
                if (!this.routingTable.hasComponentRoute(componentJID)) {
                    notifyListeners = true;
                }
                this.routingTable.addComponentRoute(componentJID, routable);
            }
            try {
                component.initialize(componentJID, (ComponentManager)this);
                component.start();
                if (notifyListeners) {
                    this.notifyComponentRegistered(componentJID);
                    CacheFactory.doClusterTask(new NotifyComponentRegistered(componentJID));
                }
                this.checkPresences();
                this.checkDiscoSupport(component, componentJID);
                Log.debug("InternalComponentManager: Component registered for domain: " + subdomain);
            }
            catch (Exception e) {
                routable.removeComponent(component);
                if (e instanceof ComponentException) {
                    throw (ComponentException)((Object)e);
                }
                throw new ComponentException((Throwable)e);
            }
            finally {
                if (routable.numberOfComponents() == 0) {
                    this.routables.remove(subdomain);
                    XMPPServer.getInstance().getRoutingTable().removeComponentRoute(componentJID);
                }
            }
        }
    }

    void notifyComponentRegistered(JID componentJID) {
        for (ComponentEventListener listener : this.listeners) {
            listener.componentRegistered(componentJID);
        }
    }

    public void removeComponent(String subdomain) {
        RoutableComponents components = null;
        if (this.routables == null || (components = this.routables.get(subdomain)) == null) {
            return;
        }
        ArrayList<Component> componentsToRemove = new ArrayList<Component>(components.getComponents());
        for (Component component : componentsToRemove) {
            this.removeComponent(subdomain, component);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeComponent(String subdomain, Component component) {
        if (component == null) {
            return;
        }
        Map<String, RoutableComponents> map = this.routables;
        synchronized (map) {
            Log.debug("InternalComponentManager: Unregistering component for domain: " + subdomain);
            RoutableComponents routable = this.routables.get(subdomain);
            routable.removeComponent(component);
            if (routable.numberOfComponents() == 0) {
                this.routables.remove(subdomain);
                JID componentJID = new JID(subdomain + "." + this.serverDomain);
                this.routingTable.removeComponentRoute(componentJID);
                component.shutdown();
                if (!this.routingTable.hasComponentRoute(componentJID)) {
                    IQDiscoItemsHandler iqDiscoItemsHandler = XMPPServer.getInstance().getIQDiscoItemsHandler();
                    if (iqDiscoItemsHandler != null) {
                        iqDiscoItemsHandler.removeComponentItem(componentJID.toBareJID());
                    }
                    this.removeComponentInfo(componentJID);
                    this.notifyComponentUnregistered(componentJID);
                    CacheFactory.doClusterTask(new NotifyComponentUnregistered(componentJID));
                }
                Log.debug("InternalComponentManager: Component unregistered for domain: " + subdomain);
            } else {
                Log.debug("InternalComponentManager: Other components still tied to domain: " + subdomain);
            }
        }
    }

    void notifyComponentUnregistered(JID componentJID) {
        for (ComponentEventListener listener : this.listeners) {
            listener.componentUnregistered(componentJID);
        }
    }

    void removeComponentInfo(JID componentJID) {
        this.componentInfo.remove(componentJID.getDomain());
    }

    public void sendPacket(Component component, Packet packet) {
        if (packet != null && packet.getFrom() == null) {
            throw new IllegalArgumentException("Packet with no FROM address was received from component.");
        }
        PacketRouter router = XMPPServer.getInstance().getPacketRouter();
        if (router != null) {
            router.route(packet);
        }
    }

    public IQ query(Component component, IQ packet, long timeout) throws ComponentException {
        final LinkedBlockingQueue answer = new LinkedBlockingQueue(8);
        XMPPServer.getInstance().getIQRouter().addIQResultListener(packet.getID(), new IQResultListener(){

            public void receivedAnswer(IQ packet) {
                answer.offer(packet);
            }

            public void answerTimeout(String packetId) {
                Log.warn("An answer to a previously sent IQ stanza was never received. Packet id: " + packetId);
            }
        });
        this.sendPacket(component, (Packet)packet);
        IQ reply = null;
        try {
            reply = (IQ)answer.poll(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return reply;
    }

    public void query(Component component, IQ packet, IQResultListener listener) throws ComponentException {
        XMPPServer.getInstance().getIQRouter().addIQResultListener(packet.getID(), listener);
        this.sendPacket(component, (Packet)packet);
    }

    public void addListener(ComponentEventListener listener) {
        this.listeners.add(listener);
        for (String domain : this.routingTable.getComponentsDomains()) {
            JID componentJID = new JID(domain);
            listener.componentRegistered(componentJID);
            IQ disco = this.componentInfo.get(domain);
            if (disco == null) continue;
            listener.componentInfoReceived(disco);
        }
    }

    public void removeListener(ComponentEventListener listener) {
        this.listeners.remove(listener);
    }

    public String getProperty(String name) {
        return JiveGlobals.getProperty(name);
    }

    public void setProperty(String name, String value) {
    }

    public String getServerName() {
        return this.serverDomain;
    }

    public String getHomeDirectory() {
        return JiveGlobals.getHomeDirectory();
    }

    public boolean isExternalMode() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Component> getComponents(JID componentJID) {
        Map<String, RoutableComponents> map = this.routables;
        synchronized (map) {
            if (componentJID.getNode() != null) {
                return Collections.emptyList();
            }
            RoutableComponents routable = this.routables.get(componentJID.getDomain());
            if (routable != null) {
                return routable.getComponents();
            }
            String serverName = componentJID.getDomain();
            int index = serverName.lastIndexOf("." + this.serverDomain);
            if (index > -1 && (routable = this.routables.get(serverName.substring(0, index))) != null) {
                return routable.getComponents();
            }
            return Collections.emptyList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasComponent(JID componentJID) {
        Map<String, RoutableComponents> map = this.routables;
        synchronized (map) {
            if (componentJID.getNode() != null || componentJID.getResource() != null) {
                return false;
            }
            return this.routingTable.hasComponentRoute(componentJID);
        }
    }

    public void addPresenceRequest(JID prober, JID probee) {
        this.presenceMap.put(prober, probee);
    }

    private void checkPresences() {
        for (JID prober : this.presenceMap.keySet()) {
            JID probee = this.presenceMap.get(prober);
            if (!this.routingTable.hasComponentRoute(probee)) continue;
            Presence presence = new Presence();
            presence.setFrom(prober);
            presence.setTo(probee);
            this.routingTable.routePacket(probee, (Packet)presence, false);
            this.presenceMap.remove(prober);
        }
    }

    private void checkDiscoSupport(Component component, JID componentJID) {
        IQ iq = new IQ(IQ.Type.get);
        iq.setFrom(this.getAddress());
        iq.setTo(componentJID);
        iq.setChildElement("query", "http://jabber.org/protocol/disco#info");
        component.processPacket((Packet)iq);
    }

    @Override
    public JID getAddress() {
        return this.serviceAddress;
    }

    @Override
    public void process(Packet packet) throws PacketException {
        String namespace;
        IQ iq;
        Element childElement;
        List<Component> components = this.getComponents(packet.getFrom());
        if (!components.isEmpty() && packet instanceof IQ && IQ.Type.result == ((IQ)packet).getType() && (childElement = (iq = (IQ)packet).getChildElement()) != null && "http://jabber.org/protocol/disco#info".equals(namespace = childElement.getNamespaceURI())) {
            Element identity = childElement.element("identity");
            if (identity == null) {
                return;
            }
            try {
                XMPPServer.getInstance().getIQDiscoItemsHandler().addComponentItem(packet.getFrom().toBareJID(), identity.attributeValue("name"));
                for (Component component : components) {
                    if (!(component instanceof ComponentSession.ExternalComponent)) continue;
                    ComponentSession.ExternalComponent externalComponent = (ComponentSession.ExternalComponent)component;
                    externalComponent.setName(identity.attributeValue("name"));
                    externalComponent.setType(identity.attributeValue("type"));
                    externalComponent.setCategory(identity.attributeValue("category"));
                }
            }
            catch (Exception e) {
                Log.error("Error processing disco packet of components: " + components + " - " + packet.toXML(), (Throwable)e);
            }
            this.addComponentInfo(iq);
            this.notifyComponentInfo(iq);
            CacheFactory.doClusterTask(new NotifyComponentInfo(iq));
        }
    }

    void notifyComponentInfo(IQ iq) {
        for (ComponentEventListener listener : this.listeners) {
            listener.componentInfoReceived(iq);
        }
    }

    void addComponentInfo(IQ iq) {
        this.componentInfo.put(iq.getFrom().getDomain(), iq);
    }

    private static class RoutableComponents
    implements RoutableChannelHandler {
        private JID jid;
        private final List<Component> components = new ArrayList<Component>();

        public RoutableComponents(JID jid, Component component) {
            this.jid = jid;
            this.addComponent(component);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addComponent(Component component) {
            List<Component> list = this.components;
            synchronized (list) {
                this.components.add(component);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeComponent(Component component) {
            List<Component> list = this.components;
            synchronized (list) {
                this.components.remove(component);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeAllComponents() {
            List<Component> list = this.components;
            synchronized (list) {
                this.components.clear();
            }
        }

        public Boolean hasComponent(Component component) {
            return this.components.contains(component);
        }

        public Integer numberOfComponents() {
            return this.components.size();
        }

        public List<Component> getComponents() {
            return this.components;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Component getNextComponent() {
            Component component;
            List<Component> list = this.components;
            synchronized (list) {
                component = this.components.get(0);
                Collections.rotate(this.components, 1);
            }
            return component;
        }

        @Override
        public JID getAddress() {
            return this.jid;
        }

        @Override
        public void process(Packet packet) throws PacketException {
            Component component = this.getNextComponent();
            component.processPacket(packet);
        }
    }
}

