/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.component;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jivesoftware.database.DbConnectionManager;
import org.jivesoftware.openfire.ConnectionManager;
import org.jivesoftware.openfire.SessionManager;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.component.ExternalComponentConfiguration;
import org.jivesoftware.openfire.component.ExternalComponentManagerListener;
import org.jivesoftware.openfire.session.ComponentSession;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.ModificationNotAllowedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalComponentManager {
    private static final Logger Log = LoggerFactory.getLogger(ExternalComponentManager.class);
    private static final String ADD_CONFIGURATION = "INSERT INTO ofExtComponentConf (subdomain,wildcard,secret,permission) VALUES (?,?,?,?)";
    private static final String DELETE_CONFIGURATION = "DELETE FROM ofExtComponentConf WHERE subdomain=? and wildcard=?";
    private static final String LOAD_CONFIGURATION = "SELECT secret,permission FROM ofExtComponentConf where subdomain=? AND wildcard=0";
    private static final String LOAD_WILDCARD_CONFIGURATION = "SELECT secret,permission FROM ofExtComponentConf where ? like subdomain AND wildcard=1";
    private static final String LOAD_CONFIGURATIONS = "SELECT subdomain,wildcard,secret FROM ofExtComponentConf where permission=?";
    private static List<ExternalComponentManagerListener> listeners = new CopyOnWriteArrayList<ExternalComponentManagerListener>();

    @Deprecated
    public static void setServiceEnabled(boolean enabled) throws ModificationNotAllowedException {
        for (ExternalComponentManagerListener listener : listeners) {
            listener.serviceEnabled(enabled);
        }
        ConnectionManager connectionManager = XMPPServer.getInstance().getConnectionManager();
        connectionManager.enableComponentListener(enabled);
    }

    @Deprecated
    public static boolean isServiceEnabled() {
        ConnectionManager connectionManager = XMPPServer.getInstance().getConnectionManager();
        return connectionManager.isComponentListenerEnabled();
    }

    @Deprecated
    public static void setServicePort(int port) throws ModificationNotAllowedException {
        for (ExternalComponentManagerListener listener : listeners) {
            listener.portChanged(port);
        }
        ConnectionManager connectionManager = XMPPServer.getInstance().getConnectionManager();
        connectionManager.setComponentListenerPort(port);
    }

    @Deprecated
    public static int getServicePort() {
        ConnectionManager connectionManager = XMPPServer.getInstance().getConnectionManager();
        return connectionManager.getComponentListenerPort();
    }

    public static void allowAccess(ExternalComponentConfiguration configuration) throws ModificationNotAllowedException {
        for (ExternalComponentManagerListener listener : listeners) {
            listener.componentAllowed(configuration.getSubdomain(), configuration);
        }
        ExternalComponentManager.deleteConfigurationFromDB(configuration);
        configuration.setPermission(ExternalComponentConfiguration.Permission.allowed);
        ExternalComponentManager.addConfiguration(configuration);
    }

    public static void blockAccess(String subdomain) throws ModificationNotAllowedException {
        for (ExternalComponentManagerListener listener : listeners) {
            listener.componentBlocked(subdomain);
        }
        ExternalComponentManager.deleteConfigurationFromDB(ExternalComponentManager.getConfiguration(subdomain, false));
        ExternalComponentConfiguration config = new ExternalComponentConfiguration(subdomain, false, ExternalComponentConfiguration.Permission.blocked, null);
        ExternalComponentManager.addConfiguration(config);
        String domain = subdomain + "." + XMPPServer.getInstance().getServerInfo().getXMPPDomain();
        ComponentSession session = SessionManager.getInstance().getComponentSession(domain);
        if (session != null) {
            session.close();
        }
    }

    public static boolean canAccess(String subdomain) {
        ExternalComponentConfiguration.Permission permission = null;
        ExternalComponentConfiguration config = ExternalComponentManager.getConfiguration(subdomain, true);
        if (config != null) {
            permission = config.getPermission();
        }
        if (PermissionPolicy.blacklist == ExternalComponentManager.getPermissionPolicy()) {
            return ExternalComponentConfiguration.Permission.blocked != permission;
        }
        return ExternalComponentConfiguration.Permission.allowed == permission;
    }

    public static boolean hasConfiguration(String subdomain) {
        return ExternalComponentManager.getConfiguration(subdomain, true) != null;
    }

    public static Collection<ExternalComponentConfiguration> getAllowedComponents() {
        return ExternalComponentManager.getConfigurations(ExternalComponentConfiguration.Permission.allowed);
    }

    public static Collection<ExternalComponentConfiguration> getBlockedComponents() {
        return ExternalComponentManager.getConfigurations(ExternalComponentConfiguration.Permission.blocked);
    }

    public static void updateComponentSecret(String subdomain, String secret) throws ModificationNotAllowedException {
        for (ExternalComponentManagerListener listener : listeners) {
            listener.componentSecretUpdated(subdomain, secret);
        }
        ExternalComponentConfiguration configuration = ExternalComponentManager.getConfiguration(subdomain, false);
        if (configuration != null) {
            configuration.setPermission(ExternalComponentConfiguration.Permission.allowed);
            configuration.setSecret(secret);
            ExternalComponentManager.deleteConfigurationFromDB(configuration);
        } else {
            configuration = new ExternalComponentConfiguration(subdomain, false, ExternalComponentConfiguration.Permission.allowed, secret);
        }
        ExternalComponentManager.addConfiguration(configuration);
    }

    public static void deleteConfiguration(String subdomain) throws ModificationNotAllowedException {
        for (ExternalComponentManagerListener listener : listeners) {
            listener.componentConfigurationDeleted(subdomain);
        }
        ExternalComponentManager.deleteConfigurationFromDB(ExternalComponentManager.getConfiguration(subdomain, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deleteConfigurationFromDB(ExternalComponentConfiguration configuration) {
        if (configuration == null) {
            return;
        }
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(DELETE_CONFIGURATION);
            pstmt.setString(1, configuration.getSubdomain() + (configuration.isWildcard() ? "%" : ""));
            pstmt.setInt(2, configuration.isWildcard() ? 1 : 0);
            pstmt.executeUpdate();
        }
        catch (SQLException sqle) {
            try {
                Log.error(sqle.getMessage(), (Throwable)sqle);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, con);
                throw throwable;
            }
            DbConnectionManager.closeConnection(pstmt, con);
        }
        DbConnectionManager.closeConnection(pstmt, con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addConfiguration(ExternalComponentConfiguration configuration) {
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(ADD_CONFIGURATION);
            pstmt.setString(1, configuration.getSubdomain() + (configuration.isWildcard() ? "%" : ""));
            pstmt.setInt(2, configuration.isWildcard() ? 1 : 0);
            pstmt.setString(3, configuration.getSecret());
            pstmt.setString(4, configuration.getPermission().toString());
            pstmt.executeUpdate();
        }
        catch (SQLException sqle) {
            try {
                Log.error(sqle.getMessage(), (Throwable)sqle);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, con);
                throw throwable;
            }
            DbConnectionManager.closeConnection(pstmt, con);
        }
        DbConnectionManager.closeConnection(pstmt, con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ExternalComponentConfiguration getConfiguration(String subdomain, boolean useWildcard) {
        ExternalComponentConfiguration configuration = null;
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(LOAD_CONFIGURATION);
            pstmt.setString(1, subdomain);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                configuration = new ExternalComponentConfiguration(subdomain, false, ExternalComponentConfiguration.Permission.valueOf(rs.getString(2)), rs.getString(1));
            }
            DbConnectionManager.closeConnection(rs, pstmt, con);
        }
        catch (SQLException sqle) {
            Log.error(sqle.getMessage(), (Throwable)sqle);
        }
        finally {
            DbConnectionManager.closeConnection(rs, pstmt, con);
        }
        if (configuration == null && useWildcard) {
            try {
                con = DbConnectionManager.getConnection();
                pstmt = con.prepareStatement(LOAD_WILDCARD_CONFIGURATION);
                pstmt.setString(1, subdomain);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    configuration = new ExternalComponentConfiguration(subdomain, true, ExternalComponentConfiguration.Permission.valueOf(rs.getString(2)), rs.getString(1));
                }
            }
            catch (SQLException sqle) {
                Log.error(sqle.getMessage(), (Throwable)sqle);
            }
            finally {
                DbConnectionManager.closeConnection(rs, pstmt, con);
            }
        }
        return configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection<ExternalComponentConfiguration> getConfigurations(ExternalComponentConfiguration.Permission permission) {
        ArrayList<ExternalComponentConfiguration> answer = new ArrayList<ExternalComponentConfiguration>();
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(LOAD_CONFIGURATIONS);
            pstmt.setString(1, permission.toString());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                String subdomain = rs.getString(1);
                boolean wildcard = rs.getInt(2) == 1;
                subdomain = wildcard ? subdomain.substring(0, subdomain.length() - 1) : subdomain;
                ExternalComponentConfiguration configuration = new ExternalComponentConfiguration(subdomain, wildcard, permission, rs.getString(3));
                answer.add(configuration);
            }
            DbConnectionManager.closeConnection(rs, pstmt, con);
        }
        catch (SQLException sqle) {
            Log.error(sqle.getMessage(), (Throwable)sqle);
        }
        finally {
            DbConnectionManager.closeConnection(rs, pstmt, con);
        }
        return answer;
    }

    public static String getDefaultSecret() {
        return JiveGlobals.getProperty("xmpp.component.defaultSecret");
    }

    public static void setDefaultSecret(String defaultSecret) throws ModificationNotAllowedException {
        for (ExternalComponentManagerListener listener : listeners) {
            listener.defaultSecretChanged(defaultSecret);
        }
        JiveGlobals.setProperty("xmpp.component.defaultSecret", defaultSecret);
    }

    public static String getSecretForComponent(String subdomain) {
        String secret = null;
        ExternalComponentConfiguration config = ExternalComponentManager.getConfiguration(subdomain, true);
        if (config != null) {
            secret = config.getSecret();
        }
        String string = secret = secret == null ? ExternalComponentManager.getDefaultSecret() : secret;
        if (secret == null) {
            Log.error("Setup for external components is incomplete. Property xmpp.component.defaultSecret does not exist.");
        }
        return secret;
    }

    public static PermissionPolicy getPermissionPolicy() {
        try {
            return PermissionPolicy.valueOf(JiveGlobals.getProperty("xmpp.component.permission", PermissionPolicy.blacklist.toString()));
        }
        catch (Exception e) {
            Log.error(e.getMessage(), (Throwable)e);
            return PermissionPolicy.blacklist;
        }
    }

    public static void setPermissionPolicy(PermissionPolicy policy) throws ModificationNotAllowedException {
        for (ExternalComponentManagerListener listener : listeners) {
            listener.permissionPolicyChanged(policy);
        }
        JiveGlobals.setProperty("xmpp.component.permission", policy.toString());
        block1: for (ComponentSession session : SessionManager.getInstance().getComponentSessions()) {
            for (String domain : session.getExternalComponent().getSubdomains()) {
                if (ExternalComponentManager.canAccess(domain)) continue;
                session.close();
                continue block1;
            }
        }
    }

    public static void setPermissionPolicy(String policy) throws ModificationNotAllowedException {
        ExternalComponentManager.setPermissionPolicy(PermissionPolicy.valueOf(policy));
    }

    public static void addListener(ExternalComponentManagerListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        listeners.add(listener);
    }

    public static void removeListener(ExternalComponentManagerListener listener) {
        listeners.remove(listener);
    }

    public static enum PermissionPolicy {
        blacklist,
        whitelist;

    }
}

