/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.commands.event;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;
import org.jivesoftware.openfire.commands.AdHocCommand;
import org.jivesoftware.openfire.commands.SessionData;
import org.jivesoftware.openfire.component.InternalComponentManager;
import org.jivesoftware.openfire.vcard.VCardEventDispatcher;
import org.jivesoftware.openfire.vcard.VCardManager;
import org.xmpp.forms.DataForm;
import org.xmpp.forms.FormField;
import org.xmpp.packet.JID;

public class VCardDeleting
extends AdHocCommand {
    @Override
    public String getCode() {
        return "http://jabber.org/protocol/event#vcard-deleting";
    }

    @Override
    public String getDefaultLabel() {
        return "Deleting a VCard";
    }

    @Override
    public int getMaxStages(SessionData data) {
        return 1;
    }

    @Override
    public void execute(SessionData sessionData, Element command) {
        String username;
        Element note = command.addElement("note");
        Map<String, List<String>> data = sessionData.getData();
        try {
            username = this.get(data, "username", 0);
        }
        catch (NullPointerException npe) {
            note.addAttribute("type", "error");
            note.setText("Username required parameter.");
            return;
        }
        Element vCard = VCardManager.getInstance().getVCard(username);
        if (vCard == null) {
            note.addAttribute("type", "error");
            note.setText("VCard not found.");
            return;
        }
        VCardEventDispatcher.dispatchVCardDeleted(username, vCard);
        note.addAttribute("type", "info");
        note.setText("Operation finished successfully");
    }

    @Override
    protected void addStageInformation(SessionData data, Element command) {
        DataForm form = new DataForm(DataForm.Type.form);
        form.setTitle("Dispatching a vCard deleting event.");
        form.addInstruction("Fill out this form to dispatch a vCard deleting event.");
        FormField field = form.addField();
        field.setType(FormField.Type.hidden);
        field.setVariable("FORM_TYPE");
        field.addValue((Object)"http://jabber.org/protocol/admin");
        field = form.addField();
        field.setType(FormField.Type.text_single);
        field.setLabel("The username of the user who's vCard is being deleted");
        field.setVariable("username");
        field.setRequired(true);
        command.add(form.getElement());
    }

    @Override
    protected List<AdHocCommand.Action> getActions(SessionData data) {
        return Collections.singletonList(AdHocCommand.Action.complete);
    }

    @Override
    protected AdHocCommand.Action getExecuteAction(SessionData data) {
        return AdHocCommand.Action.complete;
    }

    @Override
    public boolean hasPermission(JID requester) {
        return super.hasPermission(requester) || InternalComponentManager.getInstance().hasComponent(requester);
    }
}

