/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.commands.event;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;
import org.jivesoftware.openfire.commands.AdHocCommand;
import org.jivesoftware.openfire.commands.SessionData;
import org.jivesoftware.openfire.component.InternalComponentManager;
import org.jivesoftware.openfire.event.UserEventDispatcher;
import org.jivesoftware.openfire.user.User;
import org.jivesoftware.openfire.user.UserManager;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.xmpp.forms.DataForm;
import org.xmpp.forms.FormField;
import org.xmpp.packet.JID;

public class UserModified
extends AdHocCommand {
    @Override
    public String getCode() {
        return "http://jabber.org/protocol/event#user-modified";
    }

    @Override
    public String getDefaultLabel() {
        return "User modified";
    }

    @Override
    public int getMaxStages(SessionData data) {
        return 1;
    }

    @Override
    public void execute(SessionData sessionData, Element command) {
        String type;
        String username;
        Element note = command.addElement("note");
        Map<String, List<String>> data = sessionData.getData();
        try {
            username = this.get(data, "username", 0);
        }
        catch (NullPointerException npe) {
            note.addAttribute("type", "error");
            note.setText("Username required parameter.");
            return;
        }
        try {
            type = this.get(data, "changeType", 0);
        }
        catch (NullPointerException npe) {
            note.addAttribute("type", "error");
            note.setText("Change type required parameter.");
            return;
        }
        String valueVariable = null;
        String valueVariableName = null;
        if ("nameModified".equals(type) || "emailModified".equals(type) || "creationDateModified".equals(type) || "modificationDateModified".equals(type)) {
            valueVariable = "originalValue";
            valueVariableName = "Original value";
        } else if ("propertyModified".equals(type) || "propertyAdded".equals(type) || "propertyDeleted".equals(type)) {
            valueVariable = "propertyKey";
            valueVariableName = "Property key";
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (valueVariable != null) {
            try {
                String value = this.get(data, valueVariable, 0);
                params.put(valueVariable, value);
            }
            catch (NullPointerException npe) {
                note.addAttribute("type", "error");
                note.setText(valueVariableName + " required parameter.");
                return;
            }
        }
        params.put("type", type);
        try {
            User user = UserManager.getUserProvider().loadUser(username);
            UserEventDispatcher.dispatchEvent(user, UserEventDispatcher.EventType.user_modified, params);
        }
        catch (UserNotFoundException e) {
            note.addAttribute("type", "error");
            note.setText("User not found.");
            return;
        }
        note.addAttribute("type", "info");
        note.setText("Operation finished successfully");
    }

    @Override
    protected void addStageInformation(SessionData data, Element command) {
        DataForm form = new DataForm(DataForm.Type.form);
        form.setTitle("Dispatching a user updated event.");
        form.addInstruction("Fill out this form to dispatch a user updated event.");
        FormField field = form.addField();
        field.setType(FormField.Type.hidden);
        field.setVariable("FORM_TYPE");
        field.addValue((Object)"http://jabber.org/protocol/admin");
        field = form.addField();
        field.setType(FormField.Type.text_single);
        field.setLabel("The username of the user that was updated");
        field.setVariable("username");
        field.setRequired(true);
        field.setType(FormField.Type.list_single);
        field.setLabel("Change type");
        field.setVariable("changeType");
        field.addOption("Name modified", "nameModified");
        field.addOption("Email modified", "emailModified");
        field.addOption("Password modified", "passwordModified");
        field.addOption("Creation date modified", "creationDateModified");
        field.addOption("Modification date modified", "modificationDateModified");
        field.addOption("Property modified", "propertyModified");
        field.addOption("Property added", "propertyAdded");
        field.addOption("Property deleted", "propertyDeleted");
        field.addOption("Other", "other");
        field.setRequired(true);
        field = form.addField();
        field.setType(FormField.Type.text_single);
        field.setLabel("Original value");
        field.setVariable("originalValue");
        field = form.addField();
        field.setType(FormField.Type.text_single);
        field.setLabel("Name of the property");
        field.setVariable("propertyKey");
        command.add(form.getElement());
    }

    @Override
    protected List<AdHocCommand.Action> getActions(SessionData data) {
        return Collections.singletonList(AdHocCommand.Action.complete);
    }

    @Override
    protected AdHocCommand.Action getExecuteAction(SessionData data) {
        return AdHocCommand.Action.complete;
    }

    @Override
    public boolean hasPermission(JID requester) {
        return super.hasPermission(requester) || InternalComponentManager.getInstance().hasComponent(requester);
    }
}

