/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.commands.admin.user;

import java.util.Collections;
import java.util.List;
import org.dom4j.Element;
import org.jivesoftware.openfire.commands.AdHocCommand;
import org.jivesoftware.openfire.commands.SessionData;
import org.jivesoftware.openfire.user.User;
import org.jivesoftware.openfire.user.UserManager;
import org.xmpp.forms.DataForm;
import org.xmpp.forms.FormField;
import org.xmpp.packet.JID;

public class UserProperties
extends AdHocCommand {
    @Override
    public String getCode() {
        return "http://jabber.org/protocol/admin#get-user-properties";
    }

    @Override
    public String getDefaultLabel() {
        return "Get User Properties";
    }

    @Override
    public int getMaxStages(SessionData data) {
        return 1;
    }

    @Override
    public void execute(SessionData data, Element command) {
        DataForm form = new DataForm(DataForm.Type.result);
        FormField field = form.addField();
        field.setType(FormField.Type.hidden);
        field.setVariable("FORM_TYPE");
        field.addValue((Object)"http://jabber.org/protocol/admin");
        List<String> accounts = data.getData().get("accountjids");
        if (accounts != null && accounts.size() > 0) {
            this.populateResponseFields(form, accounts);
        }
        command.add(form.getElement());
    }

    private void populateResponseFields(DataForm form, List<String> accounts) {
        FormField jidField = form.addField();
        jidField.setVariable("accountjids");
        FormField emailField = form.addField();
        emailField.setVariable("email");
        FormField nameField = form.addField();
        nameField.setVariable("name");
        UserManager manager = UserManager.getInstance();
        for (String account : accounts) {
            User user;
            try {
                JID jid = new JID(account);
                user = manager.getUser(jid.getNode());
            }
            catch (Exception ex) {
                continue;
            }
            jidField.addValue((Object)account);
            emailField.addValue((Object)user.getEmail());
            nameField.addValue((Object)user.getName());
        }
    }

    @Override
    protected void addStageInformation(SessionData data, Element command) {
        DataForm form = new DataForm(DataForm.Type.form);
        form.setTitle("Retrieve Users' Information");
        form.addInstruction("Fill out this form to retrieve users' information.");
        FormField field = form.addField();
        field.setType(FormField.Type.hidden);
        field.setVariable("FORM_TYPE");
        field.addValue((Object)"http://jabber.org/protocol/admin");
        field = form.addField();
        field.setType(FormField.Type.jid_multi);
        field.setLabel("The list of Jabber IDs to retrive the information");
        field.setVariable("accountjids");
        field.setRequired(true);
        command.add(form.getElement());
    }

    @Override
    protected List<AdHocCommand.Action> getActions(SessionData data) {
        return Collections.singletonList(AdHocCommand.Action.complete);
    }

    @Override
    protected AdHocCommand.Action getExecuteAction(SessionData data) {
        return AdHocCommand.Action.complete;
    }
}

