/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.commands.admin.group;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.dom4j.Element;
import org.jivesoftware.openfire.commands.AdHocCommand;
import org.jivesoftware.openfire.commands.SessionData;
import org.jivesoftware.openfire.group.Group;
import org.jivesoftware.openfire.group.GroupManager;
import org.jivesoftware.openfire.group.GroupNotFoundException;
import org.xmpp.forms.DataForm;
import org.xmpp.forms.FormField;

public class UpdateGroup
extends AdHocCommand {
    @Override
    protected void addStageInformation(SessionData data, Element command) {
        DataForm form = new DataForm(DataForm.Type.form);
        if (data.getStage() == 0) {
            form.setTitle("Update group configuration");
            form.addInstruction("Fill out this form to specify the group to update.");
            FormField field = form.addField();
            field.setType(FormField.Type.hidden);
            field.setVariable("FORM_TYPE");
            field.addValue((Object)"http://jabber.org/protocol/admin");
            field = form.addField();
            field.setType(FormField.Type.text_single);
            field.setLabel("Group Name");
            field.setVariable("group");
            field.setRequired(true);
        } else {
            Group group;
            if (GroupManager.getInstance().isReadOnly()) {
                Element note = command.addElement("note");
                note.addAttribute("type", "error");
                note.setText("Groups are read only");
                return;
            }
            try {
                group = GroupManager.getInstance().getGroup(data.getData().get("group").get(0));
            }
            catch (GroupNotFoundException e) {
                Element note = command.addElement("note");
                note.addAttribute("type", "error");
                note.setText("Group not found");
                return;
            }
            form.setTitle("Update group configuration");
            form.addInstruction("Fill out this form with the new group configuration.");
            FormField field = form.addField();
            field.setType(FormField.Type.hidden);
            field.setVariable("FORM_TYPE");
            field.addValue((Object)"http://jabber.org/protocol/admin");
            field = form.addField();
            field.setType(FormField.Type.text_multi);
            field.setLabel("Description");
            field.setVariable("desc");
            if (group.getDescription() != null) {
                field.addValue((Object)group.getDescription());
            }
            field = form.addField();
            field.setType(FormField.Type.list_single);
            field.setLabel("Shared group visibility");
            field.setVariable("showInRoster");
            field.addValue((Object)"nobody");
            field.addOption("Disable sharing group in rosters", "nobody");
            field.addOption("Show group in all users' rosters", "everybody");
            field.addOption("Show group in group members' rosters", "onlyGroup");
            field.addOption("Show group to members' rosters of these groups", "spefgroups");
            field.setRequired(true);
            String showInRoster = (String)group.getProperties().get("sharedRoster.showInRoster");
            if (showInRoster != null) {
                if ("onlyGroup".equals(showInRoster) && ((String)group.getProperties().get("sharedRoster.groupList")).trim().length() > 0) {
                    showInRoster = "spefgroups";
                }
                field.addValue((Object)showInRoster);
            }
            field = form.addField();
            field.setType(FormField.Type.list_multi);
            field.setVariable("groupList");
            for (Group otherGroup : GroupManager.getInstance().getGroups()) {
                field.addOption(otherGroup.getName(), otherGroup.getName());
            }
            String groupList = (String)group.getProperties().get("sharedRoster.groupList");
            if (groupList != null) {
                ArrayList<String> groups = new ArrayList<String>();
                StringTokenizer tokenizer = new StringTokenizer(groupList, ",\t\n\r\f");
                while (tokenizer.hasMoreTokens()) {
                    String tok = tokenizer.nextToken().trim();
                    groups.add(tok.trim());
                }
                for (String othergroup : groups) {
                    field.addValue((Object)othergroup);
                }
            }
            field = form.addField();
            field.setType(FormField.Type.text_single);
            field.setLabel("Group Display Name");
            field.setVariable("displayName");
            String displayName = (String)group.getProperties().get("sharedRoster.displayName");
            if (displayName != null) {
                field.addValue((Object)displayName);
            }
        }
        command.add(form.getElement());
    }

    @Override
    public void execute(SessionData data, Element command) {
        String showInRoster;
        Group group;
        Element note = command.addElement("note");
        try {
            group = GroupManager.getInstance().getGroup(data.getData().get("group").get(0));
        }
        catch (GroupNotFoundException e) {
            note.addAttribute("type", "error");
            note.setText("Group not found");
            return;
        }
        List<String> desc = data.getData().get("desc");
        if (desc != null) {
            group.setDescription(desc.get(0));
        }
        if ("nobody".equals(showInRoster = data.getData().get("showInRoster").get(0))) {
            group.getProperties().put("sharedRoster.showInRoster", "nobody");
            group.getProperties().put("sharedRoster.displayName", " ");
            group.getProperties().put("sharedRoster.groupList", " ");
        } else {
            if ("spefgroups".equals(showInRoster)) {
                showInRoster = "onlyGroup";
            }
            List<String> displayName = data.getData().get("displayName");
            List<String> groupList = data.getData().get("groupList");
            if (displayName != null) {
                group.getProperties().put("sharedRoster.showInRoster", showInRoster);
                group.getProperties().put("sharedRoster.displayName", displayName.get(0));
                if (groupList != null) {
                    StringBuilder buf = new StringBuilder();
                    String sep = "";
                    for (String groupName : groupList) {
                        buf.append(sep).append(groupName);
                        sep = ",";
                    }
                    group.getProperties().put("sharedRoster.groupList", buf.toString());
                }
            }
        }
        note.addAttribute("type", "info");
        note.setText("Operation finished successfully");
    }

    @Override
    public String getCode() {
        return "http://jabber.org/protocol/admin#update-group";
    }

    @Override
    public String getDefaultLabel() {
        return "Update group configuration";
    }

    @Override
    protected List<AdHocCommand.Action> getActions(SessionData data) {
        if (data.getStage() == 0) {
            return Collections.singletonList(AdHocCommand.Action.next);
        }
        if (data.getStage() == 1) {
            return Arrays.asList(AdHocCommand.Action.next, AdHocCommand.Action.prev, AdHocCommand.Action.complete);
        }
        return Collections.singletonList(AdHocCommand.Action.complete);
    }

    @Override
    protected AdHocCommand.Action getExecuteAction(SessionData data) {
        if (data.getStage() == 0) {
            return AdHocCommand.Action.next;
        }
        return AdHocCommand.Action.complete;
    }

    @Override
    public int getMaxStages(SessionData data) {
        return 2;
    }
}

