/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.commands;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.dom4j.Element;
import org.dom4j.QName;
import org.jivesoftware.openfire.commands.AdHocCommand;
import org.jivesoftware.openfire.commands.SessionData;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.StringUtils;
import org.xmpp.forms.DataForm;
import org.xmpp.forms.FormField;
import org.xmpp.packet.IQ;
import org.xmpp.packet.PacketError;

public class AdHocCommandManager {
    private static final String NAMESPACE = "http://jabber.org/protocol/commands";
    private Map<String, AdHocCommand> commands = new ConcurrentHashMap<String, AdHocCommand>();
    private Map<String, AtomicInteger> sessionsCounter = new ConcurrentHashMap<String, AtomicInteger>();
    private Map<String, SessionData> sessions = new ConcurrentHashMap<String, SessionData>();

    public void addCommand(AdHocCommand command) {
        this.commands.put(command.getCode(), command);
    }

    public boolean removeCommand(AdHocCommand command) {
        return this.commands.remove(command.getCode()) != null;
    }

    public Collection<AdHocCommand> getCommands() {
        return this.commands.values();
    }

    public AdHocCommand getCommand(String code) {
        return this.commands.get(code);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IQ process(IQ packet) {
        IQ reply = IQ.createResultIQ((IQ)packet);
        Element iqCommand = packet.getChildElement();
        if (!IQ.Type.set.equals((Object)packet.getType())) {
            reply.setChildElement(iqCommand.createCopy());
            reply.setError(PacketError.Condition.bad_request);
            return reply;
        }
        String sessionid = iqCommand.attributeValue("sessionid");
        String commandCode = iqCommand.attributeValue("node");
        String from = packet.getFrom().toString();
        AdHocCommand command = this.commands.get(commandCode);
        if (sessionid == null) {
            if (command == null) {
                reply.setChildElement(iqCommand.createCopy());
                reply.setError(PacketError.Condition.item_not_found);
            } else {
                if (!command.hasPermission(packet.getFrom())) {
                    reply.setChildElement(iqCommand.createCopy());
                    reply.setError(PacketError.Condition.forbidden);
                    return reply;
                }
                sessionid = StringUtils.randomString(15);
                Element childElement = reply.setChildElement("command", NAMESPACE);
                if (command.getMaxStages(null) == 0) {
                    command.execute(null, childElement);
                    childElement.addAttribute("sessionid", sessionid);
                    childElement.addAttribute("node", commandCode);
                    childElement.addAttribute("status", AdHocCommand.Status.completed.name());
                } else {
                    AtomicInteger counter = this.sessionsCounter.get(from);
                    if (counter == null) {
                        String string = from.intern();
                        synchronized (string) {
                            counter = this.sessionsCounter.get(from);
                            if (counter == null) {
                                counter = new AtomicInteger(0);
                                this.sessionsCounter.put(from, counter);
                            }
                        }
                    }
                    int limit = JiveGlobals.getIntProperty("xmpp.command.limit", 100);
                    if (counter.incrementAndGet() > limit) {
                        counter.decrementAndGet();
                        reply.setChildElement(iqCommand.createCopy());
                        reply.setError(PacketError.Condition.not_allowed);
                        return reply;
                    }
                    SessionData session = new SessionData(sessionid, packet.getFrom());
                    this.sessions.put(sessionid, session);
                    childElement.addAttribute("sessionid", sessionid);
                    childElement.addAttribute("node", commandCode);
                    childElement.addAttribute("status", AdHocCommand.Status.executing.name());
                    command.addNextStageInformation(session, childElement);
                }
            }
        } else {
            String action = iqCommand.attributeValue("action");
            SessionData session = this.sessions.get(sessionid);
            if (session == null) {
                reply.setChildElement(iqCommand.createCopy());
                reply.setError(PacketError.Condition.bad_request);
                return reply;
            }
            int timeout = JiveGlobals.getIntProperty("xmpp.command.timeout", 600000);
            if (System.currentTimeMillis() - session.getCreationStamp() > (long)timeout) {
                this.removeSessionData(sessionid, from);
                reply.setChildElement(iqCommand.createCopy());
                reply.setError(PacketError.Condition.not_allowed);
                return reply;
            }
            String string = sessionid.intern();
            synchronized (string) {
                Element childElement;
                if (AdHocCommand.Action.cancel.name().equals(action)) {
                    this.removeSessionData(sessionid, from);
                    childElement = reply.setChildElement("command", NAMESPACE);
                    childElement.addAttribute("sessionid", sessionid);
                    childElement.addAttribute("node", commandCode);
                    childElement.addAttribute("status", AdHocCommand.Status.canceled.name());
                }
                if (action == null || AdHocCommand.Action.execute.name().equals(action)) {
                    action = session.getExecuteAction().name();
                }
                if (!session.isValidAction(action)) {
                    reply.setChildElement(iqCommand.createCopy());
                    reply.setError(PacketError.Condition.bad_request);
                    return reply;
                }
                if (AdHocCommand.Action.prev.name().equals(action)) {
                    childElement = reply.setChildElement("command", NAMESPACE);
                    childElement.addAttribute("sessionid", sessionid);
                    childElement.addAttribute("node", commandCode);
                    childElement.addAttribute("status", AdHocCommand.Status.executing.name());
                    command.addPreviousStageInformation(session, childElement);
                } else if (AdHocCommand.Action.next.name().equals(action)) {
                    this.saveCompletedForm(iqCommand, session);
                    childElement = reply.setChildElement("command", NAMESPACE);
                    childElement.addAttribute("sessionid", sessionid);
                    childElement.addAttribute("node", commandCode);
                    childElement.addAttribute("status", AdHocCommand.Status.executing.name());
                    command.addNextStageInformation(session, childElement);
                } else if (AdHocCommand.Action.complete.name().equals(action)) {
                    this.saveCompletedForm(iqCommand, session);
                    childElement = reply.setChildElement("command", NAMESPACE);
                    command.execute(session, childElement);
                    childElement.addAttribute("sessionid", sessionid);
                    childElement.addAttribute("node", commandCode);
                    childElement.addAttribute("status", AdHocCommand.Status.completed.name());
                    this.removeSessionData(sessionid, from);
                }
            }
        }
        return reply;
    }

    private void saveCompletedForm(Element iqCommand, SessionData session) {
        Element formElement = iqCommand.element(QName.get((String)"x", (String)"jabber:x:data"));
        if (formElement != null) {
            HashMap<String, List<String>> data = new HashMap<String, List<String>>();
            DataForm dataForm = new DataForm(formElement);
            for (FormField field : dataForm.getFields()) {
                data.put(field.getVariable(), field.getValues());
            }
            session.addStageForm(data);
        }
    }

    private void removeSessionData(String sessionid, String from) {
        this.sessions.remove(sessionid);
        if (this.sessionsCounter.get(from).decrementAndGet() <= 0) {
            this.sessionsCounter.remove(from);
        }
    }

    public void stop() {
        this.sessions.clear();
        this.sessionsCounter.clear();
    }
}

