/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.commands;

import java.util.List;
import java.util.Map;
import org.dom4j.Element;
import org.jivesoftware.openfire.admin.AdminManager;
import org.jivesoftware.openfire.commands.SessionData;
import org.xmpp.packet.JID;

public abstract class AdHocCommand {
    private String label = this.getDefaultLabel();

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public boolean hasPermission(JID requester) {
        return AdminManager.getInstance().isUserAdmin(requester, false);
    }

    public abstract String getCode();

    public abstract String getDefaultLabel();

    public abstract int getMaxStages(SessionData var1);

    public abstract void execute(SessionData var1, Element var2);

    protected abstract void addStageInformation(SessionData var1, Element var2);

    protected abstract List<Action> getActions(SessionData var1);

    protected abstract Action getExecuteAction(SessionData var1);

    public void addNextStageInformation(SessionData data, Element command) {
        data.setStage(data.getStage() + 1);
        this.addStageInformation(data, command);
        this.addStageActions(data, command);
    }

    public void addPreviousStageInformation(SessionData data, Element command) {
        data.setStage(data.getStage() - 1);
        this.addStageInformation(data, command);
        this.addStageActions(data, command);
    }

    protected void addStageActions(SessionData data, Element command) {
        Element actions = command.addElement("actions");
        List<Action> validActions = this.getActions(data);
        for (Action action : validActions) {
            actions.addElement(action.name());
        }
        Action executeAction = this.getExecuteAction(data);
        actions.addAttribute("execute", executeAction.name());
        data.setAllowedActions(validActions);
        data.setExecuteAction(executeAction);
    }

    protected String get(Map<String, List<String>> data, String key, int value) {
        List<String> list = data.get(key);
        if (list == null) {
            return null;
        }
        return list.get(value);
    }

    public static enum Action {
        execute,
        cancel,
        prev,
        next,
        complete;

    }

    public static enum Status {
        executing,
        completed,
        canceled;

    }
}

