/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.cluster;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jivesoftware.util.StringUtils;
import org.jivesoftware.util.cache.ExternalizableUtil;

public class NodeID
implements Externalizable {
    private static List<NodeID> instances = new ArrayList<NodeID>();
    private byte[] nodeID;

    public static synchronized NodeID getInstance(byte[] nodeIdBytes) {
        for (NodeID nodeID : instances) {
            if (!nodeID.equals(nodeIdBytes)) continue;
            return nodeID;
        }
        NodeID answer = new NodeID(nodeIdBytes);
        instances.add(answer);
        return answer;
    }

    public static synchronized void deleteInstance(byte[] nodeIdBytes) {
        NodeID toDelete = null;
        for (NodeID nodeID : instances) {
            if (!nodeID.equals(nodeIdBytes)) continue;
            toDelete = nodeID;
            break;
        }
        if (toDelete != null) {
            instances.remove(toDelete);
        }
    }

    public NodeID() {
    }

    private NodeID(byte[] nodeIdBytes) {
        this.nodeID = nodeIdBytes;
    }

    public boolean equals(byte[] anotherID) {
        return Arrays.equals(this.nodeID, anotherID);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeID that = (NodeID)o;
        return Arrays.equals(this.nodeID, that.nodeID);
    }

    public int hashCode() {
        return Arrays.hashCode(this.nodeID);
    }

    public String toString() {
        return StringUtils.getString(this.nodeID);
    }

    public byte[] toByteArray() {
        return this.nodeID;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        ExternalizableUtil.getInstance().writeByteArray(out, this.nodeID);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.nodeID = ExternalizableUtil.getInstance().readByteArray(in);
    }
}

