/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.auth;

import com.cenqua.shaj.Shaj;
import com.cenqua.shaj.log.Log;
import java.io.File;
import java.lang.reflect.Field;
import java.net.URL;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.auth.AuthProvider;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.user.NativeUserProvider;
import org.jivesoftware.openfire.user.UserAlreadyExistsException;
import org.jivesoftware.openfire.user.UserManager;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.jivesoftware.openfire.user.UserProvider;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeAuthProvider
implements AuthProvider {
    private static final Logger Log = LoggerFactory.getLogger(NativeAuthProvider.class);
    private String domain;

    public NativeAuthProvider() {
        JiveGlobals.migrateProperty("nativeAuth.domain");
        this.domain = JiveGlobals.getProperty("nativeAuth.domain");
        try {
            String binaryPath = new URL(Shaj.class.getProtectionDomain().getCodeSource().getLocation(), ".").openConnection().getPermission().getName();
            binaryPath = new File(binaryPath).getCanonicalPath();
            String newLibPath = binaryPath + File.pathSeparator + System.getProperty("java.library.path");
            System.setProperty("java.library.path", newLibPath);
            Field fieldSysPath = ClassLoader.class.getDeclaredField("sys_paths");
            fieldSysPath.setAccessible(true);
            fieldSysPath.set(System.class.getClassLoader(), null);
        }
        catch (Exception e) {
            Log.error(e.getMessage(), (Throwable)e);
        }
        Log.Factory.setInstance((Log)new Log(){

            public boolean isDebug() {
                return Log.isDebugEnabled();
            }

            public void error(String string) {
                Log.error(string);
            }

            public void error(String string, Throwable throwable) {
                Log.error(string, throwable);
            }

            public void debug(String string) {
                Log.debug("NativeAuthProvider: " + string);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void authenticate(String username, String password) throws UnauthorizedException {
        if (username.contains("@")) {
            int index = username.indexOf("@");
            String domain = username.substring(index + 1);
            if (domain.equals(XMPPServer.getInstance().getServerInfo().getXMPPDomain())) {
                username = username.substring(0, index);
            } else {
                throw new UnauthorizedException();
            }
        }
        try {
            NativeAuthProvider index = this;
            synchronized (index) {
                if (!Shaj.checkPassword((String)this.domain, (String)username, (String)password)) {
                    throw new UnauthorizedException();
                }
            }
        }
        catch (UnauthorizedException ue) {
            throw ue;
        }
        catch (Exception e) {
            throw new UnauthorizedException(e);
        }
        UserManager userManager = UserManager.getInstance();
        try {
            userManager.getUser(username);
        }
        catch (UserNotFoundException unfe) {
            try {
                Log.debug("Automatically creating new user account for " + username);
                UserProvider provider = UserManager.getUserProvider();
                if (!(provider instanceof NativeUserProvider)) {
                    Log.error("Error: not using NativeUserProvider so authentication with NativeAuthProvider will likely fail. Using: " + provider.getClass().getName());
                }
                UserManager.getUserProvider().createUser(username, StringUtils.randomString(8), null, null);
            }
            catch (UserAlreadyExistsException userAlreadyExistsException) {
                // empty catch block
            }
        }
    }

    @Override
    public String getPassword(String username) throws UserNotFoundException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setPassword(String username, String password) throws UserNotFoundException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsPasswordRetrieval() {
        return false;
    }

    @Override
    public boolean isScramSupported() {
        return false;
    }

    @Override
    public String getSalt(String username) throws UnsupportedOperationException, UserNotFoundException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getIterations(String username) throws UnsupportedOperationException, UserNotFoundException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getServerKey(String username) throws UnsupportedOperationException, UserNotFoundException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getStoredKey(String username) throws UnsupportedOperationException, UserNotFoundException {
        throw new UnsupportedOperationException();
    }
}

