/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.auth;

import java.util.StringTokenizer;
import java.util.Vector;
import org.jivesoftware.openfire.admin.AdminManager;
import org.jivesoftware.openfire.auth.AuthorizationPolicy;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAuthorizationPolicy
implements AuthorizationPolicy {
    private static final Logger Log = LoggerFactory.getLogger(DefaultAuthorizationPolicy.class);
    private Vector<String> approvedRealms = new Vector();
    private boolean proxyAuth = false;

    public DefaultAuthorizationPolicy() {
        String realmList = JiveGlobals.getProperty("sasl.approvedRealms");
        if (realmList != null) {
            StringTokenizer st = new StringTokenizer(realmList, " ,\t\n\r\f");
            while (st.hasMoreTokens()) {
                this.approvedRealms.add(st.nextToken());
            }
        }
        this.proxyAuth = JiveGlobals.getBooleanProperty("sasl.proxyAuth", false);
    }

    @Override
    public boolean authorize(String username, String authenID) {
        boolean authorized = false;
        String userUser = username;
        String userRealm = null;
        String authenUser = authenID;
        String authenRealm = null;
        if (username.contains("@")) {
            userUser = username.substring(0, username.lastIndexOf("@"));
            userRealm = username.substring(username.lastIndexOf("@") + 1);
        }
        if (authenID.contains("@")) {
            authenUser = authenID.substring(0, authenID.lastIndexOf("@"));
            authenRealm = authenID.substring(authenID.lastIndexOf("@") + 1);
        }
        if (!(this.proxyAuth && AdminManager.getInstance().isUserAdmin(authenUser, true) || userUser.equals(authenUser))) {
            if (JiveGlobals.getBooleanProperty("xmpp.auth.ignorecase", true)) {
                if (!userUser.toLowerCase().equals(authenUser.toLowerCase())) {
                    if (Log.isDebugEnabled()) {
                        Log.debug("DefaultAuthorizationPolicy: usernames don't match (" + userUser + " " + authenUser + ")");
                    }
                    return false;
                }
            } else {
                Log.debug("DefaultAuthorizationPolicy: usernames don't match (" + userUser + " " + authenUser + ")");
                return false;
            }
        }
        Log.debug("DefaultAuthorizationPolicy: Checking authenID realm");
        if (authenRealm != null) {
            if (authenRealm.equals(JiveGlobals.getProperty("xmpp.domain"))) {
                Log.debug("DefaultAuthorizationPolicy: authenRealm = xmpp.domain");
                authorized = true;
            } else if (authenRealm.equals(JiveGlobals.getProperty("sasl.realm"))) {
                Log.debug("DefaultAuthorizationPolicy: authenRealm = sasl.realm");
                authorized = true;
            } else {
                for (String realm : this.approvedRealms) {
                    if (authenRealm.equals(realm)) {
                        if (Log.isDebugEnabled()) {
                            Log.debug("DefaultAuthorizationPolicy: authenRealm = " + realm + " which is approved");
                        }
                        authorized = true;
                        continue;
                    }
                    if (!Log.isDebugEnabled()) continue;
                    Log.debug("DefaultAuthorizationPolicy: authenRealm != " + realm + " which is approved");
                }
            }
        } else {
            authorized = true;
        }
        if (!authorized) {
            return false;
        }
        authorized = false;
        if (userRealm != null) {
            if (userRealm.equals(JiveGlobals.getProperty("xmpp.domain"))) {
                Log.debug("DefaultAuthorizationPolicy: userRealm = xmpp.domain");
                authorized = true;
            } else if (authenRealm != null && authenRealm.equals(userRealm)) {
                if (Log.isDebugEnabled()) {
                    Log.debug("DefaultAuthorizationPolicy: userRealm = " + authenRealm + " which is approved");
                }
                authorized = true;
            }
        } else {
            authorized = true;
        }
        return authorized;
    }

    @Override
    public String name() {
        return "Default Policy";
    }

    @Override
    public String description() {
        return "Different clients perform authentication differently, so this policy will authorize any principal to a requested user that match specific conditions that are considered secure defaults for most installations.";
    }
}

