/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.auth;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.security.sasl.SaslException;
import javax.xml.bind.DatatypeConverter;
import org.jivesoftware.database.DbConnectionManager;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.auth.AuthFactory;
import org.jivesoftware.openfire.auth.AuthProvider;
import org.jivesoftware.openfire.auth.ScramUtils;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAuthProvider
implements AuthProvider {
    private static final Logger Log = LoggerFactory.getLogger(DefaultAuthProvider.class);
    private static final String LOAD_PASSWORD = "SELECT plainPassword,encryptedPassword FROM ofUser WHERE username=?";
    private static final String TEST_PASSWORD = "SELECT plainPassword,encryptedPassword,iterations,salt,storedKey,serverKey FROM ofUser WHERE username=?";
    private static final String UPDATE_PASSWORD = "UPDATE ofUser SET plainPassword=?, encryptedPassword=?, storedKey=?, serverKey=?, salt=?, iterations=? WHERE username=?";
    private static final SecureRandom random = new SecureRandom();

    private UserInfo getUserInfo(String username) throws UnsupportedOperationException, UserNotFoundException {
        return this.getUserInfo(username, false);
    }

    private UserInfo getUserInfo(String username, boolean recurse) throws UnsupportedOperationException, UserNotFoundException {
        UserInfo userInfo;
        UserInfo userInfo2;
        ResultSet rs;
        PreparedStatement pstmt;
        Connection con;
        block10: {
            boolean scramOnly;
            if (!this.isScramSupported()) {
                throw new UnsupportedOperationException();
            }
            con = null;
            pstmt = null;
            rs = null;
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(TEST_PASSWORD);
            pstmt.setString(1, username);
            rs = pstmt.executeQuery();
            if (!rs.next()) {
                throw new UserNotFoundException(username);
            }
            userInfo2 = new UserInfo();
            userInfo2.plainText = rs.getString(1);
            userInfo2.encrypted = rs.getString(2);
            userInfo2.iterations = rs.getInt(3);
            userInfo2.salt = rs.getString(4);
            userInfo2.storedKey = rs.getString(5);
            userInfo2.serverKey = rs.getString(6);
            if (userInfo2.encrypted != null) {
                try {
                    userInfo2.plainText = AuthFactory.decryptPassword(userInfo2.encrypted);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
            }
            if (recurse || userInfo2.plainText == null || !(scramOnly = JiveGlobals.getBooleanProperty("user.scramHashedPasswordOnly")) && userInfo2.salt != null) break block10;
            this.setPassword(username, userInfo2.plainText);
            UserInfo userInfo3 = this.getUserInfo(username, true);
            DbConnectionManager.closeConnection(rs, pstmt, con);
            return userInfo3;
        }
        try {
            userInfo = userInfo2;
        }
        catch (SQLException sqle) {
            try {
                Log.error("User SQL failure:", (Throwable)sqle);
                throw new UserNotFoundException(sqle);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, pstmt, con);
                throw throwable;
            }
        }
        DbConnectionManager.closeConnection(rs, pstmt, con);
        return userInfo;
    }

    @Override
    public String getSalt(String username) throws UserNotFoundException {
        return this.getUserInfo((String)username).salt;
    }

    @Override
    public int getIterations(String username) throws UserNotFoundException {
        return this.getUserInfo((String)username).iterations;
    }

    @Override
    public String getStoredKey(String username) throws UserNotFoundException {
        return this.getUserInfo((String)username).storedKey;
    }

    @Override
    public String getServerKey(String username) throws UserNotFoundException {
        return this.getUserInfo((String)username).serverKey;
    }

    @Override
    public void authenticate(String username, String password) throws UnauthorizedException {
        if (username == null || password == null) {
            throw new UnauthorizedException();
        }
        if ((username = username.trim().toLowerCase()).contains("@")) {
            int index = username.indexOf("@");
            String domain = username.substring(index + 1);
            if (domain.equals(XMPPServer.getInstance().getServerInfo().getXMPPDomain())) {
                username = username.substring(0, index);
            } else {
                throw new UnauthorizedException();
            }
        }
        try {
            if (!this.checkPassword(username, password)) {
                throw new UnauthorizedException();
            }
        }
        catch (UserNotFoundException unfe) {
            throw new UnauthorizedException();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public String getPassword(String username) throws UserNotFoundException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean checkPassword(String username, String testPassword) throws UserNotFoundException {
        boolean bl;
        String storedKey;
        String salt;
        int iterations;
        ResultSet rs;
        PreparedStatement pstmt;
        Connection con;
        block18: {
            block17: {
                con = null;
                pstmt = null;
                rs = null;
                if (username.contains("@")) {
                    int index = username.indexOf("@");
                    String domain = username.substring(index + 1);
                    if (domain.equals(XMPPServer.getInstance().getServerInfo().getXMPPDomain())) {
                        username = username.substring(0, index);
                    } else {
                        throw new UserNotFoundException();
                    }
                }
                con = DbConnectionManager.getConnection();
                pstmt = con.prepareStatement(TEST_PASSWORD);
                pstmt.setString(1, username);
                rs = pstmt.executeQuery();
                if (!rs.next()) {
                    throw new UserNotFoundException(username);
                }
                String plainText = rs.getString(1);
                String encrypted = rs.getString(2);
                iterations = rs.getInt(3);
                salt = rs.getString(4);
                storedKey = rs.getString(5);
                if (encrypted != null) {
                    try {
                        plainText = AuthFactory.decryptPassword(encrypted);
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        // empty catch block
                    }
                }
                if (plainText == null) break block17;
                boolean scramOnly = JiveGlobals.getBooleanProperty("user.scramHashedPasswordOnly");
                if (scramOnly) {
                    this.setPassword(username, plainText);
                }
                boolean bl2 = testPassword.equals(plainText);
                DbConnectionManager.closeConnection(rs, pstmt, con);
                return bl2;
            }
            if (salt != null && iterations != 0 && storedKey != null) break block18;
            Log.warn("No available credentials for checkPassword.");
            boolean scramOnly = false;
            DbConnectionManager.closeConnection(rs, pstmt, con);
            return scramOnly;
        }
        byte[] saltShaker = DatatypeConverter.parseBase64Binary((String)salt);
        byte[] saltedPassword = null;
        byte[] clientKey = null;
        byte[] testStoredKey = null;
        try {
            saltedPassword = ScramUtils.createSaltedPassword(saltShaker, testPassword, iterations);
            clientKey = ScramUtils.computeHmac(saltedPassword, "Client Key");
            testStoredKey = MessageDigest.getInstance("SHA-1").digest(clientKey);
        }
        catch (NoSuchAlgorithmException | SaslException e) {
            Log.warn("Unable to check SCRAM values for PLAIN authentication.");
            boolean bl3 = false;
            DbConnectionManager.closeConnection(rs, pstmt, con);
            return bl3;
        }
        try {
            bl = DatatypeConverter.printBase64Binary((byte[])testStoredKey).equals(storedKey);
        }
        catch (SQLException sqle) {
            try {
                Log.error("User SQL failure:", (Throwable)sqle);
                throw new UserNotFoundException(sqle);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, pstmt, con);
                throw throwable;
            }
        }
        DbConnectionManager.closeConnection(rs, pstmt, con);
        return bl;
    }

    @Override
    public void setPassword(String username, String password) throws UserNotFoundException {
        boolean usePlainPassword = JiveGlobals.getBooleanProperty("user.usePlainPassword");
        boolean scramOnly = JiveGlobals.getBooleanProperty("user.scramHashedPasswordOnly");
        String encryptedPassword = null;
        if (username.contains("@")) {
            int index = username.indexOf("@");
            String domain = username.substring(index + 1);
            if (domain.equals(XMPPServer.getInstance().getServerInfo().getXMPPDomain())) {
                username = username.substring(0, index);
            } else {
                throw new UserNotFoundException();
            }
        }
        byte[] saltShaker = new byte[24];
        random.nextBytes(saltShaker);
        String salt = DatatypeConverter.printBase64Binary((byte[])saltShaker);
        int iterations = JiveGlobals.getIntProperty("sasl.scram-sha-1.iteration-count", 4096);
        byte[] saltedPassword = null;
        byte[] clientKey = null;
        byte[] storedKey = null;
        byte[] serverKey = null;
        try {
            saltedPassword = ScramUtils.createSaltedPassword(saltShaker, password, iterations);
            clientKey = ScramUtils.computeHmac(saltedPassword, "Client Key");
            storedKey = MessageDigest.getInstance("SHA-1").digest(clientKey);
            serverKey = ScramUtils.computeHmac(saltedPassword, "Server Key");
        }
        catch (NoSuchAlgorithmException | SaslException e) {
            Log.warn("Unable to persist values for SCRAM authentication.");
        }
        if (!scramOnly && !usePlainPassword) {
            try {
                encryptedPassword = AuthFactory.encryptPassword(password);
                password = null;
            }
            catch (UnsupportedOperationException e) {
                // empty catch block
            }
        }
        if (scramOnly) {
            encryptedPassword = null;
            password = null;
        }
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(UPDATE_PASSWORD);
            if (password == null) {
                pstmt.setNull(1, 12);
            } else {
                pstmt.setString(1, password);
            }
            if (encryptedPassword == null) {
                pstmt.setNull(2, 12);
            } else {
                pstmt.setString(2, encryptedPassword);
            }
            if (storedKey == null) {
                pstmt.setNull(3, 12);
            } else {
                pstmt.setString(3, DatatypeConverter.printBase64Binary((byte[])storedKey));
            }
            if (serverKey == null) {
                pstmt.setNull(4, 12);
            } else {
                pstmt.setString(4, DatatypeConverter.printBase64Binary((byte[])serverKey));
            }
            pstmt.setString(5, salt);
            pstmt.setInt(6, iterations);
            pstmt.setString(7, username);
            pstmt.executeUpdate();
        }
        catch (SQLException sqle) {
            try {
                throw new UserNotFoundException(sqle);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, con);
                throw throwable;
            }
        }
        DbConnectionManager.closeConnection(pstmt, con);
    }

    @Override
    public boolean supportsPasswordRetrieval() {
        boolean scramOnly = JiveGlobals.getBooleanProperty("user.scramHashedPasswordOnly");
        return !scramOnly;
    }

    @Override
    public boolean isScramSupported() {
        return true;
    }

    private class UserInfo {
        String plainText;
        String encrypted;
        int iterations;
        String salt;
        String storedKey;
        String serverKey;

        private UserInfo() {
        }
    }
}

