/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.admin;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jivesoftware.database.DbConnectionManager;
import org.jivesoftware.openfire.admin.AdminProvider;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;

public class JDBCAdminProvider
implements AdminProvider {
    private static final Logger Log = LoggerFactory.getLogger(JDBCAdminProvider.class);
    private final String getAdminsSQL;
    private final String insertAdminsSQL;
    private final String deleteAdminsSQL;
    private final String xmppDomain;
    private final boolean useConnectionProvider;
    private String connectionString;

    public JDBCAdminProvider() {
        JiveGlobals.migrateProperty("jdbcProvider.driver");
        JiveGlobals.migrateProperty("jdbcProvider.connectionString");
        JiveGlobals.migrateProperty("jdbcAdminProvider.getAdminsSQL");
        this.xmppDomain = JiveGlobals.getProperty("xmpp.domain");
        this.useConnectionProvider = JiveGlobals.getBooleanProperty("jdbcAdminProvider.useConnectionProvider");
        this.getAdminsSQL = JiveGlobals.getProperty("jdbcAdminProvider.getAdminsSQL");
        this.insertAdminsSQL = JiveGlobals.getProperty("jdbcAdminProvider.insertAdminsSQL", "");
        this.deleteAdminsSQL = JiveGlobals.getProperty("jdbcAdminProvider.deleteAdminsSQL", "");
        if (!this.useConnectionProvider) {
            String jdbcDriver = JiveGlobals.getProperty("jdbcProvider.driver");
            try {
                Class.forName(jdbcDriver).newInstance();
            }
            catch (Exception e) {
                Log.error("Unable to load JDBC driver: " + jdbcDriver, (Throwable)e);
                return;
            }
            this.connectionString = JiveGlobals.getProperty("jdbcProvider.connectionString");
        }
    }

    @Override
    public List<JID> getAdmins() {
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<JID> jids = new ArrayList<JID>();
        String string = this.getAdminsSQL;
        synchronized (string) {
            Object name;
            try {
                con = this.getConnection();
                pstmt = con.prepareStatement(this.getAdminsSQL);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    name = rs.getString(1);
                    jids.add(new JID((String)name + "@" + this.xmppDomain));
                }
                name = jids;
            }
            catch (SQLException e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    DbConnectionManager.closeConnection(rs, pstmt, con);
                    throw throwable;
                }
            }
            DbConnectionManager.closeConnection(rs, pstmt, con);
            return name;
        }
    }

    private void changeAdmins(Connection con, String sql, List<JID> admins) throws SQLException {
        if (!admins.isEmpty()) {
            try (PreparedStatement pstmt = con.prepareStatement(sql);){
                for (JID jid : admins) {
                    pstmt.setString(1, jid.getNode());
                    pstmt.execute();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAdmins(List<JID> newAdmins) {
        if (this.isReadOnly()) {
            throw new UnsupportedOperationException();
        }
        String string = this.getAdminsSQL;
        synchronized (string) {
            List<JID> currentAdmins = this.getAdmins();
            ArrayList<JID> adminsToAdd = new ArrayList<JID>(newAdmins);
            adminsToAdd.removeAll(currentAdmins);
            currentAdmins.removeAll(newAdmins);
            try (Connection con = this.getConnection();){
                this.changeAdmins(con, this.insertAdminsSQL, adminsToAdd);
                this.changeAdmins(con, this.deleteAdminsSQL, currentAdmins);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public boolean isReadOnly() {
        return this.insertAdminsSQL.isEmpty() || this.deleteAdminsSQL.isEmpty();
    }

    private Connection getConnection() throws SQLException {
        if (this.useConnectionProvider) {
            return DbConnectionManager.getConnection();
        }
        return DriverManager.getConnection(this.connectionString);
    }
}

