/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire;

import java.util.Comparator;
import java.util.Date;
import org.jivesoftware.openfire.session.ClientSession;

public class SessionResultFilter {
    public static final int DESCENDING = 0;
    public static final int ASCENDING = 1;
    public static final int NO_RESULT_LIMIT = -1;
    public static final int SORT_USER = 0;
    public static final int SORT_CREATION_DATE = 1;
    public static final int SORT_LAST_ACTIVITY_DATE = 2;
    public static final int SORT_NUM_CLIENT_PACKETS = 3;
    public static final int SORT_NUM_SERVER_PACKETS = 4;
    private int sortField = 2;
    private int sortOrder = 0;
    private String username = null;
    private int startIndex = 0;
    private int numResults = -1;
    private Date creationDateRangeMin = null;
    private Date creationDateRangeMax = null;
    private Date lastActivityDateRangeMin = null;
    private Date lastActivityDateRangeMax = null;

    public static SessionResultFilter createDefaultSessionFilter() {
        SessionResultFilter resultFilter = new SessionResultFilter();
        resultFilter.setSortField(0);
        resultFilter.setSortOrder(1);
        return resultFilter;
    }

    public int getSortField() {
        return this.sortField;
    }

    public void setSortField(int sortField) {
        this.sortField = sortField;
    }

    public int getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(int sortOrder) {
        if (sortOrder != 1 && sortOrder != 0) {
            throw new IllegalArgumentException();
        }
        this.sortOrder = sortOrder;
    }

    public int getNumResults() {
        return this.numResults;
    }

    public void setNumResults(int numResults) {
        if (numResults != -1 && numResults < 0) {
            throw new IllegalArgumentException("numResults cannot be less than 0.");
        }
        this.numResults = numResults;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(int startIndex) {
        if (startIndex < 0) {
            throw new IllegalArgumentException("A start index less than 0 is not valid.");
        }
        this.startIndex = startIndex;
    }

    public Comparator<ClientSession> getSortComparator() {
        return new SessionComparator();
    }

    public static Date roundDate(Date date, int seconds) {
        return new Date(SessionResultFilter.roundDate(date.getTime(), seconds));
    }

    public static long roundDate(long date, int seconds) {
        return date - date % (long)(1000 * seconds);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && object instanceof SessionResultFilter) {
            SessionResultFilter o = (SessionResultFilter)object;
            if (this.sortField != o.sortField) {
                return false;
            }
            if (this.sortOrder != o.sortOrder) {
                return false;
            }
            if (this.numResults != o.numResults) {
                return false;
            }
            if (!SessionResultFilter.compare(this.username, o.username)) {
                return false;
            }
            if (!SessionResultFilter.compare(this.creationDateRangeMin, o.creationDateRangeMin)) {
                return false;
            }
            if (!SessionResultFilter.compare(this.creationDateRangeMax, o.creationDateRangeMax)) {
                return false;
            }
            if (!SessionResultFilter.compare(this.lastActivityDateRangeMin, o.lastActivityDateRangeMin)) {
                return false;
            }
            return SessionResultFilter.compare(this.lastActivityDateRangeMax, o.lastActivityDateRangeMax);
        }
        return false;
    }

    private static boolean compare(Object one, Object two) {
        if (one == null && two != null) {
            return false;
        }
        return one == null || one.equals(two);
    }

    private class SessionComparator
    implements Comparator<ClientSession> {
        private SessionComparator() {
        }

        @Override
        public int compare(ClientSession lhs, ClientSession rhs) {
            int comparison;
            switch (SessionResultFilter.this.sortField) {
                case 1: {
                    comparison = lhs.getCreationDate().compareTo(rhs.getCreationDate());
                    break;
                }
                case 2: {
                    comparison = lhs.getLastActiveDate().compareTo(rhs.getCreationDate());
                    break;
                }
                case 3: {
                    comparison = (int)(lhs.getNumClientPackets() - rhs.getNumClientPackets());
                    break;
                }
                case 4: {
                    comparison = (int)(lhs.getNumServerPackets() - rhs.getNumServerPackets());
                    break;
                }
                case 0: {
                    String lUsername = lhs.isAnonymousUser() ? "" : lhs.getAddress().getNode();
                    String rUsername = rhs.isAnonymousUser() ? "" : rhs.getAddress().getNode();
                    comparison = this.compareString(lUsername, rUsername);
                    if (comparison != 0) break;
                    comparison = this.compareString(lhs.getAddress().getResource(), rhs.getAddress().getResource());
                    break;
                }
                default: {
                    comparison = 0;
                }
            }
            if (SessionResultFilter.this.sortOrder == 0) {
                comparison *= -1;
            }
            return comparison;
        }

        private int compareString(String lhs, String rhs) {
            if (lhs == null) {
                lhs = "";
            }
            if (rhs == null) {
                rhs = "";
            }
            return lhs.compareTo(rhs);
        }
    }
}

