/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire;

import org.dom4j.Element;
import org.jivesoftware.openfire.PacketRouter;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.multiplex.UnknownStanzaException;
import org.jivesoftware.openfire.net.SASLAuthentication;
import org.jivesoftware.openfire.session.LocalClientSession;
import org.xmpp.packet.IQ;
import org.xmpp.packet.Message;
import org.xmpp.packet.Packet;
import org.xmpp.packet.Presence;
import org.xmpp.packet.Roster;

public class SessionPacketRouter
implements PacketRouter {
    protected LocalClientSession session;
    private PacketRouter router;
    private boolean skipJIDValidation = false;

    public SessionPacketRouter(LocalClientSession session) {
        this.session = session;
        this.router = XMPPServer.getInstance().getPacketRouter();
    }

    public void setSkipJIDValidation(boolean skipJIDValidation) {
        this.skipJIDValidation = skipJIDValidation;
    }

    public void route(Element wrappedElement) throws UnknownStanzaException {
        String tag = wrappedElement.getName();
        if ("auth".equals(tag) || "response".equals(tag)) {
            SASLAuthentication.handle(this.session, wrappedElement);
        } else if ("iq".equals(tag)) {
            this.route(this.getIQ(wrappedElement));
        } else if ("message".equals(tag)) {
            this.route(new Message(wrappedElement, this.skipJIDValidation));
        } else if ("presence".equals(tag)) {
            this.route(new Presence(wrappedElement, this.skipJIDValidation));
        } else {
            throw new UnknownStanzaException();
        }
    }

    private IQ getIQ(Element doc) {
        Element query = doc.element("query");
        if (query != null && "jabber:iq:roster".equals(query.getNamespaceURI())) {
            return new Roster(doc);
        }
        return new IQ(doc, this.skipJIDValidation);
    }

    @Override
    public void route(Packet packet) {
        packet.setFrom(this.session.getAddress());
        if (packet instanceof IQ) {
            this.route((IQ)packet);
        } else if (packet instanceof Message) {
            this.route((Message)packet);
        } else if (packet instanceof Presence) {
            this.route((Presence)packet);
        }
    }

    @Override
    public void route(IQ packet) {
        packet.setFrom(this.session.getAddress());
        this.router.route(packet);
        this.session.incrementClientPacketCount();
    }

    @Override
    public void route(Message packet) {
        packet.setFrom(this.session.getAddress());
        this.router.route(packet);
        this.session.incrementClientPacketCount();
    }

    @Override
    public void route(Presence packet) {
        packet.setFrom(this.session.getAddress());
        this.router.route(packet);
        this.session.incrementClientPacketCount();
    }
}

