/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire;

import org.jivesoftware.openfire.MulticastRouter;
import org.jivesoftware.openfire.PresenceManager;
import org.jivesoftware.openfire.RoutingTable;
import org.jivesoftware.openfire.SessionManager;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.container.BasicModule;
import org.jivesoftware.openfire.entitycaps.EntityCapabilitiesManager;
import org.jivesoftware.openfire.handler.PresenceSubscribeHandler;
import org.jivesoftware.openfire.handler.PresenceUpdateHandler;
import org.jivesoftware.openfire.interceptor.InterceptorManager;
import org.jivesoftware.openfire.interceptor.PacketRejectedException;
import org.jivesoftware.openfire.session.ClientSession;
import org.jivesoftware.util.LocaleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;
import org.xmpp.packet.Message;
import org.xmpp.packet.Packet;
import org.xmpp.packet.PacketError;
import org.xmpp.packet.Presence;

public class PresenceRouter
extends BasicModule {
    private static final Logger Log = LoggerFactory.getLogger(PresenceRouter.class);
    private RoutingTable routingTable;
    private PresenceUpdateHandler updateHandler;
    private PresenceSubscribeHandler subscribeHandler;
    private PresenceManager presenceManager;
    private SessionManager sessionManager;
    private EntityCapabilitiesManager entityCapsManager;
    private MulticastRouter multicastRouter;
    private String serverName;

    public PresenceRouter() {
        super("XMPP Presence Router");
    }

    public void route(Presence packet) {
        block5: {
            if (packet == null) {
                throw new NullPointerException();
            }
            ClientSession session = this.sessionManager.getSession(packet.getFrom());
            try {
                InterceptorManager.getInstance().invokeInterceptors((Packet)packet, session, true, false);
                if (session == null || session.getStatus() != 1) {
                    this.handle(packet);
                } else {
                    packet.setTo(session.getAddress());
                    packet.setFrom((JID)null);
                    packet.setError(PacketError.Condition.not_authorized);
                    session.process((Packet)packet);
                }
                InterceptorManager.getInstance().invokeInterceptors((Packet)packet, session, true, true);
            }
            catch (PacketRejectedException e) {
                if (session == null) break block5;
                Presence reply = new Presence();
                reply.setID(packet.getID());
                reply.setTo(session.getAddress());
                reply.setFrom(packet.getTo());
                reply.setError(PacketError.Condition.not_allowed);
                session.process((Packet)reply);
                if (e.getRejectionMessage() == null || e.getRejectionMessage().trim().length() <= 0) break block5;
                Message notification = new Message();
                notification.setTo(session.getAddress());
                notification.setFrom(packet.getTo());
                notification.setBody(e.getRejectionMessage());
                session.process((Packet)notification);
            }
        }
    }

    private void handle(Presence packet) {
        block17: {
            JID recipientJID = packet.getTo();
            JID senderJID = packet.getFrom();
            if (recipientJID != null && recipientJID.getNode() == null && recipientJID.getResource() == null && this.serverName.equals(recipientJID.getDomain()) && packet.getElement().element("addresses") != null) {
                this.multicastRouter.route((Packet)packet);
                return;
            }
            try {
                if (recipientJID != null && !XMPPServer.getInstance().isLocal(recipientJID) && !XMPPServer.getInstance().isLocal(senderJID)) {
                    this.routingTable.routePacket(recipientJID, (Packet)packet, false);
                    return;
                }
                Presence.Type type = packet.getType();
                if (type == null || Presence.Type.unavailable == type) {
                    if (recipientJID == null || recipientJID.getDomain() == null || "".equals(recipientJID.getDomain()) || recipientJID.getNode() == null && recipientJID.getResource() == null && this.serverName.equals(recipientJID.getDomain())) {
                        this.entityCapsManager.process(packet);
                        this.updateHandler.process(packet);
                    } else {
                        ClientSession session;
                        if (senderJID != null && !this.serverName.equals(senderJID.getDomain()) && !this.routingTable.hasComponentRoute(senderJID)) {
                            this.entityCapsManager.process(packet);
                        }
                        if ((session = this.sessionManager.getSession(packet.getFrom())) != null && session.getStatus() == -1 && type == null) {
                            Log.warn("Rejected available presence: " + packet + " - " + session);
                            return;
                        }
                        for (JID jid : this.routingTable.getRoutes(recipientJID, senderJID)) {
                            this.updateHandler.directedPresenceSent(packet, jid, recipientJID.toString());
                            this.routingTable.routePacket(jid, (Packet)packet, false);
                        }
                    }
                } else if (Presence.Type.subscribe == type || Presence.Type.unsubscribe == type || Presence.Type.subscribed == type || Presence.Type.unsubscribed == type) {
                    this.subscribeHandler.process(packet);
                } else if (Presence.Type.probe == type) {
                    if (!XMPPServer.getInstance().isLocal(recipientJID)) {
                        this.routingTable.routePacket(recipientJID, (Packet)packet, false);
                    } else {
                        this.presenceManager.handleProbe(packet);
                    }
                } else {
                    this.routingTable.routePacket(recipientJID, (Packet)packet, false);
                }
            }
            catch (Exception e) {
                Log.error(LocaleUtils.getLocalizedString("admin.error.routing"), (Throwable)e);
                ClientSession session = this.sessionManager.getSession(packet.getFrom());
                if (session == null) break block17;
                session.close();
            }
        }
    }

    @Override
    public void initialize(XMPPServer server) {
        super.initialize(server);
        this.serverName = server.getServerInfo().getXMPPDomain();
        this.routingTable = server.getRoutingTable();
        this.updateHandler = server.getPresenceUpdateHandler();
        this.subscribeHandler = server.getPresenceSubscribeHandler();
        this.presenceManager = server.getPresenceManager();
        this.multicastRouter = server.getMulticastRouter();
        this.sessionManager = server.getSessionManager();
        this.entityCapsManager = EntityCapabilitiesManager.getInstance();
    }

    public void routingFailed(JID recipient, Packet packet) {
        Log.debug("Presence sent to unreachable address: " + packet.toXML());
    }
}

