/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire;

import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.io.SAXReader;
import org.jivesoftware.database.DbConnectionManager;
import org.jivesoftware.database.SequenceManager;
import org.jivesoftware.openfire.OfflineMessage;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.container.BasicModule;
import org.jivesoftware.openfire.event.UserEventDispatcher;
import org.jivesoftware.openfire.event.UserEventListener;
import org.jivesoftware.openfire.user.User;
import org.jivesoftware.openfire.user.UserManager;
import org.jivesoftware.util.LocaleUtils;
import org.jivesoftware.util.StringUtils;
import org.jivesoftware.util.XMPPDateTimeFormat;
import org.jivesoftware.util.cache.Cache;
import org.jivesoftware.util.cache.CacheFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;
import org.xmpp.packet.Message;

public class OfflineMessageStore
extends BasicModule
implements UserEventListener {
    private static final Logger Log = LoggerFactory.getLogger(OfflineMessageStore.class);
    private static final String INSERT_OFFLINE = "INSERT INTO ofOffline (username, messageID, creationDate, messageSize, stanza) VALUES (?, ?, ?, ?, ?)";
    private static final String LOAD_OFFLINE = "SELECT stanza, creationDate FROM ofOffline WHERE username=? ORDER BY creationDate ASC";
    private static final String LOAD_OFFLINE_MESSAGE = "SELECT stanza FROM ofOffline WHERE username=? AND creationDate=?";
    private static final String SELECT_SIZE_OFFLINE = "SELECT SUM(messageSize) FROM ofOffline WHERE username=?";
    private static final String SELECT_SIZE_ALL_OFFLINE = "SELECT SUM(messageSize) FROM ofOffline";
    private static final String DELETE_OFFLINE = "DELETE FROM ofOffline WHERE username=?";
    private static final String DELETE_OFFLINE_MESSAGE = "DELETE FROM ofOffline WHERE username=? AND creationDate=?";
    private static final int POOL_SIZE = 10;
    private Cache<String, Integer> sizeCache;
    private Pattern pattern = Pattern.compile("&\\#[\\d]+;");
    private BlockingQueue<SAXReader> xmlReaders = new LinkedBlockingQueue<SAXReader>(10);

    public static OfflineMessageStore getInstance() {
        return XMPPServer.getInstance().getOfflineMessageStore();
    }

    public OfflineMessageStore() {
        super("Offline Message Store");
        this.sizeCache = CacheFactory.createCache("Offline Message Size");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessage(Message message) {
        if (message == null) {
            return;
        }
        if (!OfflineMessageStore.shouldStoreMessage(message)) {
            return;
        }
        JID recipient = message.getTo();
        String username = recipient.getNode();
        if (username == null || !UserManager.getInstance().isRegisteredUser(recipient)) {
            return;
        }
        if (!XMPPServer.getInstance().getServerInfo().getXMPPDomain().equals(recipient.getDomain())) {
            return;
        }
        long messageID = SequenceManager.nextID(19);
        String msgXML = message.getElement().asXML();
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(INSERT_OFFLINE);
            pstmt.setString(1, username);
            pstmt.setLong(2, messageID);
            pstmt.setString(3, StringUtils.dateToMillis(new Date()));
            pstmt.setInt(4, msgXML.length());
            pstmt.setString(5, msgXML);
            pstmt.executeUpdate();
        }
        catch (Exception e) {
            try {
                Log.error(LocaleUtils.getLocalizedString("admin.error"), (Throwable)e);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, con);
                throw throwable;
            }
            DbConnectionManager.closeConnection(pstmt, con);
        }
        DbConnectionManager.closeConnection(pstmt, con);
        if (this.sizeCache.containsKey(username)) {
            int size = (Integer)this.sizeCache.get(username);
            this.sizeCache.put(username, size += msgXML.length());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<OfflineMessage> getMessages(String username, boolean delete) {
        ResultSet rs;
        PreparedStatement pstmt;
        Connection con;
        SAXReader xmlReader;
        ArrayList<OfflineMessage> messages;
        block19: {
            messages = new ArrayList<OfflineMessage>();
            xmlReader = null;
            con = null;
            pstmt = null;
            rs = null;
            try {
                xmlReader = this.xmlReaders.take();
                con = DbConnectionManager.getConnection();
                pstmt = con.prepareStatement(LOAD_OFFLINE);
                pstmt.setString(1, username);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    OfflineMessage message;
                    String msgXML = rs.getString(1);
                    Date creationDate = new Date(Long.parseLong(rs.getString(2).trim()));
                    try {
                        message = new OfflineMessage(creationDate, xmlReader.read((Reader)new StringReader(msgXML)).getRootElement());
                    }
                    catch (DocumentException e) {
                        Matcher matcher = this.pattern.matcher(msgXML);
                        if (matcher.find()) {
                            msgXML = matcher.replaceAll("");
                        }
                        try {
                            message = new OfflineMessage(creationDate, xmlReader.read((Reader)new StringReader(msgXML)).getRootElement());
                        }
                        catch (DocumentException de) {
                            Log.error("Failed to route packet (offline message): " + msgXML, (Throwable)de);
                            continue;
                        }
                    }
                    Element delaytest = message.getChildElement("delay", "urn:xmpp:delay");
                    if (delaytest == null) {
                        Element delay = message.addChildElement("delay", "urn:xmpp:delay");
                        delay.addAttribute("from", XMPPServer.getInstance().getServerInfo().getXMPPDomain());
                        delay.addAttribute("stamp", XMPPDateTimeFormat.format(creationDate));
                    }
                    messages.add(message);
                }
                if (!delete || messages.isEmpty()) break block19;
                PreparedStatement pstmt2 = null;
                try {
                    pstmt2 = con.prepareStatement(DELETE_OFFLINE);
                    pstmt2.setString(1, username);
                    pstmt2.executeUpdate();
                    this.removeUsernameFromSizeCache(username);
                }
                catch (Exception e) {
                    Log.error("Error deleting offline messages of username: " + username, (Throwable)e);
                }
                finally {
                    DbConnectionManager.closeStatement(pstmt2);
                }
            }
            catch (Exception e) {
                try {
                    Log.error("Error retrieving offline messages of username: " + username, (Throwable)e);
                }
                catch (Throwable throwable) {
                    DbConnectionManager.closeConnection(rs, pstmt, con);
                    if (xmlReader != null) {
                        this.xmlReaders.add(xmlReader);
                    }
                    throw throwable;
                }
                DbConnectionManager.closeConnection(rs, pstmt, con);
                if (xmlReader != null) {
                    this.xmlReaders.add(xmlReader);
                }
            }
        }
        DbConnectionManager.closeConnection(rs, pstmt, con);
        if (xmlReader != null) {
            this.xmlReaders.add(xmlReader);
        }
        return messages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OfflineMessage getMessage(String username, Date creationDate) {
        ResultSet rs;
        PreparedStatement pstmt;
        Connection con;
        OfflineMessage message;
        block6: {
            message = null;
            con = null;
            pstmt = null;
            rs = null;
            SAXReader xmlReader = null;
            try {
                xmlReader = this.xmlReaders.take();
                con = DbConnectionManager.getConnection();
                pstmt = con.prepareStatement(LOAD_OFFLINE_MESSAGE);
                pstmt.setString(1, username);
                pstmt.setString(2, StringUtils.dateToMillis(creationDate));
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    String msgXML = rs.getString(1);
                    message = new OfflineMessage(creationDate, xmlReader.read((Reader)new StringReader(msgXML)).getRootElement());
                    Element delay = message.addChildElement("delay", "urn:xmpp:delay");
                    delay.addAttribute("from", XMPPServer.getInstance().getServerInfo().getXMPPDomain());
                    delay.addAttribute("stamp", XMPPDateTimeFormat.format(creationDate));
                }
                if (xmlReader == null) break block6;
                this.xmlReaders.add(xmlReader);
            }
            catch (Exception e) {
                block7: {
                    try {
                        Log.error("Error retrieving offline messages of username: " + username + " creationDate: " + creationDate, (Throwable)e);
                        if (xmlReader == null) break block7;
                        this.xmlReaders.add(xmlReader);
                    }
                    catch (Throwable throwable) {
                        if (xmlReader != null) {
                            this.xmlReaders.add(xmlReader);
                        }
                        DbConnectionManager.closeConnection(rs, pstmt, con);
                        throw throwable;
                    }
                }
                DbConnectionManager.closeConnection(rs, pstmt, con);
            }
        }
        DbConnectionManager.closeConnection(rs, pstmt, con);
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteMessages(String username) {
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(DELETE_OFFLINE);
            pstmt.setString(1, username);
            pstmt.executeUpdate();
            this.removeUsernameFromSizeCache(username);
        }
        catch (Exception e) {
            try {
                Log.error("Error deleting offline messages of username: " + username, (Throwable)e);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, con);
                throw throwable;
            }
            DbConnectionManager.closeConnection(pstmt, con);
        }
        DbConnectionManager.closeConnection(pstmt, con);
    }

    private void removeUsernameFromSizeCache(String username) {
        if (this.sizeCache.containsKey(username)) {
            this.sizeCache.remove(username);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteMessage(String username, Date creationDate) {
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(DELETE_OFFLINE_MESSAGE);
            pstmt.setString(1, username);
            pstmt.setString(2, StringUtils.dateToMillis(creationDate));
            pstmt.executeUpdate();
            this.removeUsernameFromSizeCache(username);
        }
        catch (Exception e) {
            try {
                Log.error("Error deleting offline messages of username: " + username + " creationDate: " + creationDate, (Throwable)e);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, con);
                throw throwable;
            }
            DbConnectionManager.closeConnection(pstmt, con);
        }
        DbConnectionManager.closeConnection(pstmt, con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize(String username) {
        if (this.sizeCache.containsKey(username)) {
            return (Integer)this.sizeCache.get(username);
        }
        int size = 0;
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(SELECT_SIZE_OFFLINE);
            pstmt.setString(1, username);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                size = rs.getInt(1);
            }
            this.sizeCache.put(username, size);
            DbConnectionManager.closeConnection(rs, pstmt, con);
        }
        catch (Exception e) {
            Log.error(LocaleUtils.getLocalizedString("admin.error"), (Throwable)e);
        }
        finally {
            DbConnectionManager.closeConnection(rs, pstmt, con);
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize() {
        ResultSet rs;
        PreparedStatement pstmt;
        Connection con;
        int size;
        block4: {
            size = 0;
            con = null;
            pstmt = null;
            rs = null;
            try {
                con = DbConnectionManager.getConnection();
                pstmt = con.prepareStatement(SELECT_SIZE_ALL_OFFLINE);
                rs = pstmt.executeQuery();
                if (!rs.next()) break block4;
                size = rs.getInt(1);
            }
            catch (Exception e) {
                try {
                    Log.error(LocaleUtils.getLocalizedString("admin.error"), (Throwable)e);
                }
                catch (Throwable throwable) {
                    DbConnectionManager.closeConnection(rs, pstmt, con);
                    throw throwable;
                }
                DbConnectionManager.closeConnection(rs, pstmt, con);
            }
        }
        DbConnectionManager.closeConnection(rs, pstmt, con);
        return size;
    }

    public void userCreated(User user, Map params) {
    }

    public void userDeleting(User user, Map params) {
        this.deleteMessages(user.getUsername());
    }

    public void userModified(User user, Map params) {
    }

    @Override
    public void start() throws IllegalStateException {
        super.start();
        for (int i = 0; i < 10; ++i) {
            SAXReader xmlReader = new SAXReader();
            xmlReader.setEncoding("UTF-8");
            this.xmlReaders.add(xmlReader);
        }
        UserEventDispatcher.addListener(this);
    }

    @Override
    public void stop() {
        super.stop();
        this.xmlReaders.clear();
        UserEventDispatcher.removeListener(this);
    }

    static boolean shouldStoreMessage(Message message) {
        if (message.getChildElement("no-store", "urn:xmpp:hints") != null) {
            return false;
        }
        switch (message.getType()) {
            case chat: {
                Iterator it = message.getElement().elementIterator();
                while (it.hasNext()) {
                    Element el;
                    Object item = it.next();
                    if (!(item instanceof Element) || Namespace.NO_NAMESPACE.equals((Object)(el = (Element)item).getNamespace()) || el.getNamespaceURI().equals("http://jabber.org/protocol/chatstates") || el.getQName().equals((Object)QName.get((String)"rtt", (String)"urn:xmpp:rtt:0"))) continue;
                    return true;
                }
                return message.getBody() != null && !message.getBody().isEmpty();
            }
            case groupchat: 
            case headline: {
                return false;
            }
            case error: {
                if (message.getChildElement("amp", "http://jabber.org/protocol/amp") != null) break;
                return false;
            }
        }
        return true;
    }
}

