/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jivesoftware.openfire.SessionManager;
import org.jivesoftware.openfire.StreamID;
import org.jivesoftware.openfire.session.LocalClientSession;
import org.jivesoftware.openfire.session.LocalComponentSession;
import org.jivesoftware.openfire.session.LocalConnectionMultiplexerSession;
import org.jivesoftware.openfire.session.LocalIncomingServerSession;
import org.jivesoftware.openfire.session.LocalSession;
import org.jivesoftware.util.LocaleUtils;
import org.jivesoftware.util.TaskEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LocalSessionManager {
    private static final Logger Log = LoggerFactory.getLogger(LocalSessionManager.class);
    private Map<String, LocalClientSession> preAuthenticatedSessions = new ConcurrentHashMap<String, LocalClientSession>();
    private List<LocalComponentSession> componentsSessions = new CopyOnWriteArrayList<LocalComponentSession>();
    private Map<String, LocalConnectionMultiplexerSession> connnectionManagerSessions = new ConcurrentHashMap<String, LocalConnectionMultiplexerSession>();
    private final Map<StreamID, LocalIncomingServerSession> incomingServerSessions = new ConcurrentHashMap<StreamID, LocalIncomingServerSession>();

    LocalSessionManager() {
    }

    public Map<String, LocalClientSession> getPreAuthenticatedSessions() {
        return this.preAuthenticatedSessions;
    }

    public List<LocalComponentSession> getComponentsSessions() {
        return this.componentsSessions;
    }

    public Map<String, LocalConnectionMultiplexerSession> getConnnectionManagerSessions() {
        return this.connnectionManagerSessions;
    }

    public LocalIncomingServerSession getIncomingServerSession(StreamID streamID) {
        return this.incomingServerSessions.get(streamID);
    }

    public Collection<LocalIncomingServerSession> getIncomingServerSessions() {
        return this.incomingServerSessions.values();
    }

    public void addIncomingServerSessions(StreamID streamID, LocalIncomingServerSession session) {
        this.incomingServerSessions.put(streamID, session);
    }

    public void removeIncomingServerSessions(StreamID streamID) {
        this.incomingServerSessions.remove(streamID);
    }

    public void start() {
        int period = 180000;
        TaskEngine.getInstance().scheduleAtFixedRate((TimerTask)new ServerCleanupTask(), period, (long)period);
    }

    public void stop() {
        try {
            HashSet<LocalSession> sessions = new HashSet<LocalSession>();
            sessions.addAll(this.preAuthenticatedSessions.values());
            sessions.addAll(this.componentsSessions);
            for (LocalIncomingServerSession incomingSession : this.incomingServerSessions.values()) {
                sessions.add(incomingSession);
            }
            for (LocalConnectionMultiplexerSession multiplexer : this.connnectionManagerSessions.values()) {
                sessions.add(multiplexer);
            }
            for (LocalSession session : sessions) {
                try {
                    if (session.isDetached()) continue;
                    session.getConnection().systemShutdown();
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class ServerCleanupTask
    extends TimerTask {
        private ServerCleanupTask() {
        }

        @Override
        public void run() {
            int idleTime = SessionManager.getInstance().getServerSessionIdleTime();
            if (idleTime == -1) {
                return;
            }
            long deadline = System.currentTimeMillis() - (long)idleTime;
            for (LocalIncomingServerSession session : LocalSessionManager.this.incomingServerSessions.values()) {
                try {
                    if (session.getLastActiveDate().getTime() >= deadline) continue;
                    session.close();
                }
                catch (Throwable e) {
                    Log.error(LocaleUtils.getLocalizedString("admin.error"), e);
                }
            }
        }
    }
}

