/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire;

import java.lang.management.ManagementFactory;
import java.util.Collections;
import java.util.HashMap;
import javax.management.remote.JMXAuthenticator;
import javax.management.remote.JMXPrincipal;
import javax.management.remote.JMXServiceURL;
import javax.security.auth.Subject;
import org.eclipse.jetty.jmx.ConnectorServer;
import org.eclipse.jetty.jmx.MBeanContainer;
import org.jivesoftware.openfire.admin.AdminManager;
import org.jivesoftware.openfire.auth.AuthFactory;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMXManager {
    private static final Logger Log = LoggerFactory.getLogger(JMXManager.class);
    private static final String XMPP_JMX_ENABLED = "xmpp.jmx.enabled";
    private static final String XMPP_JMX_SECURE = "xmpp.jmx.secure";
    private static final String XMPP_JMX_PORT = "xmpp.jmx.port";
    public static final int DEFAULT_PORT = 1099;
    private static JMXManager instance = null;
    private MBeanContainer mbContainer;
    private ConnectorServer jmxServer;

    public static boolean isSecure() {
        return JiveGlobals.getBooleanProperty(XMPP_JMX_SECURE, true);
    }

    public static void setSecure(boolean secure) {
        JiveGlobals.setProperty(XMPP_JMX_SECURE, String.valueOf(secure));
    }

    public static int getPort() {
        return JiveGlobals.getIntProperty(XMPP_JMX_PORT, 1099);
    }

    public static void setPort(int port) {
        JiveGlobals.setProperty(XMPP_JMX_PORT, String.valueOf(port));
    }

    public static boolean isEnabled() {
        return JiveGlobals.getBooleanProperty(XMPP_JMX_ENABLED, false);
    }

    public static void setEnabled(boolean enabled) {
        JiveGlobals.setProperty(XMPP_JMX_ENABLED, String.valueOf(enabled));
    }

    public static JMXManager getInstance() {
        if (instance == null) {
            instance = new JMXManager();
            if (JMXManager.isEnabled()) {
                instance.start();
            }
        }
        return instance;
    }

    private void start() {
        this.setContainer(new MBeanContainer(ManagementFactory.getPlatformMBeanServer()));
        int jmxPort = JMXManager.getPort();
        String jmxUrl = "/jndi/rmi://localhost:" + jmxPort + "/jmxrmi";
        HashMap<String, 1> env = new HashMap<String, 1>();
        if (JMXManager.isSecure()) {
            env.put("jmx.remote.authenticator", new JMXAuthenticator(){

                @Override
                public Subject authenticate(Object credentials) {
                    if (!(credentials instanceof String[])) {
                        if (credentials == null) {
                            throw new SecurityException("Credentials required");
                        }
                        throw new SecurityException("Credentials should be String[]");
                    }
                    String[] aCredentials = (String[])credentials;
                    if (aCredentials.length < 2) {
                        throw new SecurityException("Credentials should have at least two elements");
                    }
                    String username = aCredentials[0];
                    String password = aCredentials[1];
                    try {
                        AuthFactory.authenticate(username, password);
                    }
                    catch (Exception ex) {
                        Log.error("Authentication failed for " + username);
                        throw new SecurityException();
                    }
                    if (AdminManager.getInstance().isUserAdmin(username, true)) {
                        return new Subject(true, Collections.singleton(new JMXPrincipal(username)), Collections.EMPTY_SET, Collections.EMPTY_SET);
                    }
                    Log.error("Authorization failed for " + username);
                    throw new SecurityException();
                }
            });
        }
        try {
            this.jmxServer = new ConnectorServer(new JMXServiceURL("rmi", null, jmxPort, jmxUrl), env, "org.eclipse.jetty.jmx:name=rmiconnectorserver");
            this.jmxServer.start();
        }
        catch (Exception e) {
            Log.error("Failed to start JMX connector", (Throwable)e);
        }
    }

    public MBeanContainer getContainer() {
        return this.mbContainer;
    }

    public void setContainer(MBeanContainer mbContainer) {
        this.mbContainer = mbContainer;
    }
}

