/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jivesoftware.database.DbConnectionManager;
import org.jivesoftware.database.JiveID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SequenceManager {
    private static final Logger Log = LoggerFactory.getLogger(SequenceManager.class);
    private static final String CREATE_ID = "INSERT INTO ofID (id, idType) VALUES (1, ?)";
    private static final String LOAD_ID = "SELECT id FROM ofID WHERE idType=?";
    private static final String UPDATE_ID = "UPDATE ofID SET id=? WHERE idType=? AND id=?";
    private static Map<Integer, SequenceManager> managers = new ConcurrentHashMap<Integer, SequenceManager>();
    private int type;
    private long currentID;
    private long maxID;
    private int blockSize;

    public static long nextID(int type) {
        if (managers.containsKey(type)) {
            return managers.get(type).nextUniqueID();
        }
        SequenceManager manager = new SequenceManager(type, 1);
        return manager.nextUniqueID();
    }

    public static long nextID(Object o) {
        JiveID id = o.getClass().getAnnotation(JiveID.class);
        if (id == null) {
            Log.error("Annotation JiveID must be defined in the class " + o.getClass());
            throw new IllegalArgumentException("Annotation JiveID must be defined in the class " + o.getClass());
        }
        return SequenceManager.nextID(id.value());
    }

    public static void setBlockSize(int type, int blockSize) {
        if (managers.containsKey(type)) {
            SequenceManager.managers.get((Object)Integer.valueOf((int)type)).blockSize = blockSize;
        } else {
            new SequenceManager(type, blockSize);
        }
    }

    public SequenceManager(int seqType, int size) {
        managers.put(seqType, this);
        this.type = seqType;
        this.blockSize = size;
        this.currentID = 0L;
        this.maxID = 0L;
    }

    public synchronized long nextUniqueID() {
        if (this.currentID >= this.maxID) {
            this.getNextBlock(5);
        }
        long id = this.currentID++;
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getNextBlock(int count) {
        boolean success;
        boolean abortTransaction;
        ResultSet rs;
        PreparedStatement pstmt;
        Connection con;
        block10: {
            if (count == 0) {
                Log.error("Failed at last attempt to obtain an ID, aborting...");
                return;
            }
            con = null;
            pstmt = null;
            rs = null;
            abortTransaction = false;
            success = false;
            try {
                con = DbConnectionManager.getTransactionConnection();
                pstmt = con.prepareStatement(LOAD_ID);
                pstmt.setInt(1, this.type);
                rs = pstmt.executeQuery();
                long currentID = 1L;
                if (rs.next()) {
                    currentID = rs.getLong(1);
                } else {
                    this.createNewID(con, this.type);
                }
                DbConnectionManager.fastcloseStmt(rs, pstmt);
                long newID = currentID + (long)this.blockSize;
                pstmt = con.prepareStatement(UPDATE_ID);
                pstmt.setLong(1, newID);
                pstmt.setInt(2, this.type);
                pstmt.setLong(3, currentID);
                boolean bl = success = pstmt.executeUpdate() == 1;
                if (!success) break block10;
                this.currentID = currentID;
                this.maxID = newID;
            }
            catch (SQLException e) {
                try {
                    Log.error(e.getMessage(), (Throwable)e);
                    abortTransaction = true;
                }
                catch (Throwable throwable) {
                    DbConnectionManager.closeStatement(rs, pstmt);
                    DbConnectionManager.closeTransactionConnection(con, abortTransaction);
                    throw throwable;
                }
                DbConnectionManager.closeStatement(rs, pstmt);
                DbConnectionManager.closeTransactionConnection(con, abortTransaction);
            }
        }
        DbConnectionManager.closeStatement(rs, pstmt);
        DbConnectionManager.closeTransactionConnection(con, abortTransaction);
        if (!success) {
            Log.warn("WARNING: failed to obtain next ID block due to thread contention. Trying again...");
            try {
                Thread.sleep(75L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.getNextBlock(count - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createNewID(Connection con, int type) throws SQLException {
        Log.warn("Autocreating jiveID row for type '" + type + "'");
        PreparedStatement pstmt = null;
        try {
            pstmt = con.prepareStatement(CREATE_ID);
            pstmt.setInt(1, type);
            pstmt.execute();
        }
        finally {
            DbConnectionManager.closeStatement(pstmt);
        }
    }

    static {
        new SequenceManager(18, 5);
        new SequenceManager(19, 5);
        new SequenceManager(23, 5);
    }
}

