/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.database;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.jivesoftware.database.ConnectionProvider;
import org.jivesoftware.database.DbConnectionManager;
import org.jivesoftware.util.JiveGlobals;
import org.logicalcobwebs.proxool.ConnectionPoolDefinitionIF;
import org.logicalcobwebs.proxool.ProxoolException;
import org.logicalcobwebs.proxool.ProxoolFacade;
import org.logicalcobwebs.proxool.admin.SnapshotIF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConnectionProvider
implements ConnectionProvider {
    private static final Logger Log = LoggerFactory.getLogger(DefaultConnectionProvider.class);
    private Properties settings;
    private String driver;
    private String serverURL;
    private String proxoolURL;
    private String username;
    private String password;
    private int minConnections = 3;
    private int maxConnections = 10;
    private int activeTimeout = 900000;
    private String testSQL = "";
    private Boolean testBeforeUse = true;
    private Boolean testAfterUse = true;
    private double connectionTimeout = 0.5;
    private boolean mysqlUseUnicode;

    public DefaultConnectionProvider() {
        this.loadProperties();
    }

    @Override
    public boolean isPooled() {
        return true;
    }

    @Override
    public Connection getConnection() throws SQLException {
        try {
            Class.forName("org.logicalcobwebs.proxool.ProxoolDriver");
            return DriverManager.getConnection(this.proxoolURL, this.settings);
        }
        catch (ClassNotFoundException e) {
            throw new SQLException("DbConnectionProvider: Unable to find driver: " + e);
        }
    }

    @Override
    public void start() {
        this.proxoolURL = "proxool.openfire:" + this.getDriver() + ":" + this.getServerURL();
        this.settings = new Properties();
        this.settings.setProperty("proxool.maximum-active-time", Integer.toString(this.activeTimeout));
        this.settings.setProperty("proxool.maximum-connection-count", Integer.toString(this.getMaxConnections()));
        this.settings.setProperty("proxool.minimum-connection-count", Integer.toString(this.getMinConnections()));
        this.settings.setProperty("proxool.maximum-connection-lifetime", Integer.toString((int)(8.64E7 * this.getConnectionTimeout())));
        this.settings.setProperty("proxool.test-before-use", this.testBeforeUse.toString());
        this.settings.setProperty("proxool.test-after-use", this.testAfterUse.toString());
        this.settings.setProperty("proxool.house-keeping-test-sql", this.testSQL);
        this.settings.setProperty("user", this.getUsername());
        this.settings.setProperty("password", this.getPassword() != null ? this.getPassword() : "");
    }

    @Override
    public void restart() {
    }

    @Override
    public void destroy() {
        this.settings = null;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
        this.saveProperties();
    }

    public String getServerURL() {
        return this.serverURL;
    }

    public void setServerURL(String serverURL) {
        this.serverURL = serverURL;
        this.saveProperties();
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
        this.saveProperties();
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
        this.saveProperties();
    }

    public int getMinConnections() {
        return this.minConnections;
    }

    public void setMinConnections(int minConnections) {
        this.minConnections = minConnections;
        this.saveProperties();
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
        this.saveProperties();
    }

    public double getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(double connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        this.saveProperties();
    }

    public String getTestSQL() {
        return this.testSQL;
    }

    public void setTestSQL(String testSQL) {
        this.testSQL = testSQL;
    }

    public Boolean getTestBeforeUse() {
        return this.testBeforeUse;
    }

    public void setTestBeforeUse(Boolean testBeforeUse) {
        this.testBeforeUse = testBeforeUse;
    }

    public Boolean getTestAfterUse() {
        return this.testAfterUse;
    }

    public void setTestAfterUse(Boolean testAfterUse) {
        this.testAfterUse = testAfterUse;
    }

    public boolean isMysqlUseUnicode() {
        return this.mysqlUseUnicode;
    }

    private void loadProperties() {
        this.driver = JiveGlobals.getXMLProperty("database.defaultProvider.driver");
        this.serverURL = JiveGlobals.getXMLProperty("database.defaultProvider.serverURL");
        this.username = JiveGlobals.getXMLProperty("database.defaultProvider.username");
        this.password = JiveGlobals.getXMLProperty("database.defaultProvider.password");
        String minCons = JiveGlobals.getXMLProperty("database.defaultProvider.minConnections");
        String maxCons = JiveGlobals.getXMLProperty("database.defaultProvider.maxConnections");
        String conTimeout = JiveGlobals.getXMLProperty("database.defaultProvider.connectionTimeout");
        this.testSQL = JiveGlobals.getXMLProperty("database.defaultProvider.testSQL", DbConnectionManager.getTestSQL(this.driver));
        this.testBeforeUse = JiveGlobals.getXMLProperty("database.defaultProvider.testBeforeUse", false);
        this.testAfterUse = JiveGlobals.getXMLProperty("database.defaultProvider.testAfterUse", false);
        this.mysqlUseUnicode = Boolean.valueOf(JiveGlobals.getXMLProperty("database.mysql.useUnicode"));
        try {
            if (minCons != null) {
                this.minConnections = Integer.parseInt(minCons);
            }
            if (maxCons != null) {
                this.maxConnections = Integer.parseInt(maxCons);
            }
            if (conTimeout != null) {
                this.connectionTimeout = Double.parseDouble(conTimeout);
            }
        }
        catch (Exception e) {
            Log.error("Error: could not parse default pool properties. Make sure the values exist and are correct.", (Throwable)e);
        }
    }

    private void saveProperties() {
        JiveGlobals.setXMLProperty("database.defaultProvider.driver", this.driver);
        JiveGlobals.setXMLProperty("database.defaultProvider.serverURL", this.serverURL);
        JiveGlobals.setXMLProperty("database.defaultProvider.username", this.username);
        JiveGlobals.setXMLProperty("database.defaultProvider.password", this.password);
        JiveGlobals.setXMLProperty("database.defaultProvider.testSQL", this.testSQL);
        JiveGlobals.setXMLProperty("database.defaultProvider.testBeforeUse", this.testBeforeUse.toString());
        JiveGlobals.setXMLProperty("database.defaultProvider.testAfterUse", this.testAfterUse.toString());
        JiveGlobals.setXMLProperty("database.defaultProvider.minConnections", Integer.toString(this.minConnections));
        JiveGlobals.setXMLProperty("database.defaultProvider.maxConnections", Integer.toString(this.maxConnections));
        JiveGlobals.setXMLProperty("database.defaultProvider.connectionTimeout", Double.toString(this.connectionTimeout));
    }

    public String toString() {
        try {
            ConnectionPoolDefinitionIF poolDef = ProxoolFacade.getConnectionPoolDefinition((String)"openfire");
            SnapshotIF poolStats = ProxoolFacade.getSnapshot((String)"openfire", (boolean)true);
            return poolDef.getMinimumConnectionCount() + "," + poolDef.getMaximumConnectionCount() + "," + poolStats.getAvailableConnectionCount() + "," + poolStats.getActiveConnectionCount();
        }
        catch (ProxoolException e) {
            return "Default Connection Provider";
        }
    }
}

