/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.admin;

import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.dom4j.Element;
import org.jivesoftware.admin.AdminConsole;
import org.jivesoftware.util.StringUtils;

public class TabsTag
extends BodyTagSupport {
    private String bean;
    private String css;
    private String currentcss;
    private Boolean justlinks = false;

    public String getBean() {
        return this.bean;
    }

    public void setBean(String bean) {
        this.bean = bean;
    }

    public String getCss() {
        return this.clean(this.css);
    }

    public void setCss(String css) {
        this.css = css;
    }

    public String getCurrentcss() {
        return this.clean(this.currentcss);
    }

    public void setCurrentcss(String currentcss) {
        this.currentcss = currentcss;
    }

    public Boolean getJustlinks() {
        return this.justlinks;
    }

    public void setJustlinks(Boolean justlinks) {
        this.justlinks = justlinks;
    }

    public int doStartTag() throws JspException {
        return 2;
    }

    public int doEndTag() throws JspException {
        List tabs;
        Element subPage;
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        String pageID = (String)request.getAttribute("pageID");
        String subPageID = (String)request.getAttribute("subPageID");
        if (pageID == null && (subPage = AdminConsole.getElemnetByID(subPageID)) != null) {
            pageID = subPage.getParent().getParent().attributeValue("id");
        }
        if ((tabs = AdminConsole.getModel().selectNodes("//tab")).size() > 0) {
            JspWriter out = this.pageContext.getOut();
            StringBuilder buf = new StringBuilder();
            if (!this.justlinks.booleanValue()) {
                buf.append("<ul>");
            }
            String body = this.getBodyContent().getString();
            Element currentTab = null;
            if (pageID != null) {
                currentTab = (Element)AdminConsole.getModel().selectSingleNode("//*[@id='" + pageID + "']/ancestor::tab");
            }
            for (int i = 0; i < tabs.size(); ++i) {
                Element tab = (Element)tabs.get(i);
                String value = body;
                if (value != null) {
                    String pluginName = tab.attributeValue("plugin");
                    value = StringUtils.replace(value, "[id]", this.clean(tab.attributeValue("id")));
                    value = StringUtils.replace(value, "[url]", request.getContextPath() + "/" + this.clean(tab.attributeValue("url")));
                    value = StringUtils.replace(value, "[name]", this.clean(AdminConsole.getAdminText(tab.attributeValue("name"), pluginName)));
                    value = StringUtils.replace(value, "[description]", this.clean(AdminConsole.getAdminText(tab.attributeValue("description"), pluginName)));
                }
                String css = this.getCss();
                if (tab.equals(currentTab)) {
                    css = this.getCurrentcss();
                }
                if (!this.justlinks.booleanValue()) {
                    buf.append("<li class=\"").append(css).append("\">");
                }
                if (this.justlinks.booleanValue() && i > 0) {
                    buf.append(" | ");
                }
                buf.append(value);
                if (this.justlinks.booleanValue()) continue;
                buf.append("</li>");
            }
            if (!this.justlinks.booleanValue()) {
                buf.append("</ul>");
            }
            try {
                out.write(buf.toString());
            }
            catch (IOException ioe) {
                throw new JspException(ioe.getMessage());
            }
        }
        return 6;
    }

    private String clean(String in) {
        return in == null ? "" : StringUtils.replace(in, "'", "\\'");
    }
}

