/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.admin;

import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.TaskEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginLimitManager {
    private static final Logger Log = LoggerFactory.getLogger(LoginLimitManager.class);
    private long maxAttemptsPerIP;
    private long millisecondsBetweenPerIP;
    private long maxAttemptsPerUsername;
    private long millisecondsBetweenPerUsername;
    private Map<String, Long> attemptsPerIP = new ConcurrentHashMap<String, Long>();
    private Map<String, Long> attemptsPerUsername = new ConcurrentHashMap<String, Long>();

    public static LoginLimitManager getInstance() {
        return LoginLimitManagerContainer.instance;
    }

    private LoginLimitManager() {
        this.maxAttemptsPerIP = JiveGlobals.getLongProperty("adminConsole.maxAttemptsPerIP", 10L);
        this.millisecondsBetweenPerIP = JiveGlobals.getLongProperty("adminConsole.perIPAttemptResetInterval", 900000L);
        this.maxAttemptsPerUsername = JiveGlobals.getLongProperty("adminConsole.maxAttemptsPerUsername", 10L);
        this.millisecondsBetweenPerUsername = JiveGlobals.getLongProperty("adminConsole.perUsernameAttemptResetInterval", 900000L);
        TaskEngine.getInstance().scheduleAtFixedRate((TimerTask)new PerUsernameTask(), 0L, this.millisecondsBetweenPerUsername);
        TaskEngine.getInstance().scheduleAtFixedRate((TimerTask)new PerIPAddressTask(), 0L, this.millisecondsBetweenPerIP);
    }

    public boolean hasHitConnectionLimit(String username, String address) {
        if (this.attemptsPerIP.get(address) != null && this.attemptsPerIP.get(address) > this.maxAttemptsPerIP) {
            return true;
        }
        return this.attemptsPerUsername.get(username) != null && this.attemptsPerUsername.get(username) > this.maxAttemptsPerUsername;
    }

    public void recordFailedAttempt(String username, String address) {
        Log.warn("Failed admin console login attempt by " + username + " from " + address);
        Long cnt = 0L;
        if (this.attemptsPerIP.get(address) != null) {
            cnt = this.attemptsPerIP.get(address);
        }
        Long l = cnt;
        Long l2 = cnt = Long.valueOf(cnt + 1L);
        this.attemptsPerIP.put(address, cnt);
        if (cnt > this.maxAttemptsPerIP) {
            Log.warn("Login attempt limit breeched for address " + address);
        }
        cnt = 0L;
        if (this.attemptsPerUsername.get(username) != null) {
            cnt = this.attemptsPerUsername.get(username);
        }
        l = cnt;
        l2 = cnt = Long.valueOf(cnt + 1L);
        this.attemptsPerUsername.put(username, cnt);
        if (cnt > this.maxAttemptsPerUsername) {
            Log.warn("Login attempt limit breeched for username " + username);
        }
    }

    public void recordSuccessfulAttempt(String username, String address) {
        this.attemptsPerIP.remove(address);
        this.attemptsPerUsername.remove(username);
    }

    private class PerIPAddressTask
    extends TimerTask {
        private PerIPAddressTask() {
        }

        @Override
        public void run() {
            LoginLimitManager.this.attemptsPerIP.clear();
        }
    }

    private class PerUsernameTask
    extends TimerTask {
        private PerUsernameTask() {
        }

        @Override
        public void run() {
            LoginLimitManager.this.attemptsPerUsername.clear();
        }
    }

    private static class LoginLimitManagerContainer {
        private static LoginLimitManager instance = new LoginLimitManager();

        private LoginLimitManagerContainer() {
        }
    }
}

