/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.admin;

import java.io.IOException;
import java.io.StringWriter;
import java.util.Iterator;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;
import org.dom4j.io.OutputFormat;
import org.jivesoftware.openfire.ldap.LdapManager;
import org.jivesoftware.openfire.ldap.LdapVCardProvider;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapUserProfile {
    private static final Logger Log = LoggerFactory.getLogger(LdapUserProfile.class);
    private String name = "";
    private String email = "";
    private String fullName = "";
    private String nickname = "";
    private String birthday = "";
    private String photo = "";
    private String homeStreet = "";
    private String homeCity = "";
    private String homeState = "";
    private String homeZip = "";
    private String homeCountry = "";
    private String homePhone = "";
    private String homeMobile = "";
    private String homeFax = "";
    private String homePager = "";
    private String businessStreet = "";
    private String businessCity = "";
    private String businessState = "";
    private String businessZip = "";
    private String businessCountry = "";
    private String businessJobTitle = "";
    private String businessDepartment = "";
    private String businessPhone = "";
    private String businessMobile = "";
    private String businessFax = "";
    private String businessPager = "";
    private Boolean avatarStoredInDB = false;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getNickname() {
        return this.nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public String getBirthday() {
        return this.birthday;
    }

    public void setBirthday(String birthday) {
        this.birthday = birthday;
    }

    public String getPhoto() {
        return this.photo;
    }

    public void setPhoto(String photo) {
        this.photo = photo;
    }

    public String getHomeStreet() {
        return this.homeStreet;
    }

    public void setHomeStreet(String homeStreet) {
        this.homeStreet = homeStreet;
    }

    public String getHomeCity() {
        return this.homeCity;
    }

    public void setHomeCity(String homeCity) {
        this.homeCity = homeCity;
    }

    public String getHomeState() {
        return this.homeState;
    }

    public void setHomeState(String homeState) {
        this.homeState = homeState;
    }

    public String getHomeZip() {
        return this.homeZip;
    }

    public void setHomeZip(String homeZip) {
        this.homeZip = homeZip;
    }

    public String getHomeCountry() {
        return this.homeCountry;
    }

    public void setHomeCountry(String homeCountry) {
        this.homeCountry = homeCountry;
    }

    public String getHomePhone() {
        return this.homePhone;
    }

    public void setHomePhone(String homePhone) {
        this.homePhone = homePhone;
    }

    public String getHomeMobile() {
        return this.homeMobile;
    }

    public void setHomeMobile(String homeMobile) {
        this.homeMobile = homeMobile;
    }

    public String getHomeFax() {
        return this.homeFax;
    }

    public void setHomeFax(String homeFax) {
        this.homeFax = homeFax;
    }

    public String getHomePager() {
        return this.homePager;
    }

    public void setHomePager(String homePager) {
        this.homePager = homePager;
    }

    public String getBusinessStreet() {
        return this.businessStreet;
    }

    public void setBusinessStreet(String businessStreet) {
        this.businessStreet = businessStreet;
    }

    public String getBusinessCity() {
        return this.businessCity;
    }

    public void setBusinessCity(String businessCity) {
        this.businessCity = businessCity;
    }

    public String getBusinessState() {
        return this.businessState;
    }

    public void setBusinessState(String businessState) {
        this.businessState = businessState;
    }

    public String getBusinessZip() {
        return this.businessZip;
    }

    public void setBusinessZip(String businessZip) {
        this.businessZip = businessZip;
    }

    public String getBusinessCountry() {
        return this.businessCountry;
    }

    public void setBusinessCountry(String businessCountry) {
        this.businessCountry = businessCountry;
    }

    public String getBusinessJobTitle() {
        return this.businessJobTitle;
    }

    public void setBusinessJobTitle(String businessJobTitle) {
        this.businessJobTitle = businessJobTitle;
    }

    public String getBusinessDepartment() {
        return this.businessDepartment;
    }

    public void setBusinessDepartment(String businessDepartment) {
        this.businessDepartment = businessDepartment;
    }

    public String getBusinessPhone() {
        return this.businessPhone;
    }

    public void setBusinessPhone(String businessPhone) {
        this.businessPhone = businessPhone;
    }

    public String getBusinessMobile() {
        return this.businessMobile;
    }

    public void setBusinessMobile(String businessMobile) {
        this.businessMobile = businessMobile;
    }

    public String getBusinessFax() {
        return this.businessFax;
    }

    public void setBusinessFax(String businessFax) {
        this.businessFax = businessFax;
    }

    public String getBusinessPager() {
        return this.businessPager;
    }

    public void setBusinessPager(String businessPager) {
        this.businessPager = businessPager;
    }

    public Boolean getAvatarStoredInDB() {
        return this.avatarStoredInDB;
    }

    public void setAvatarStoredInDB(Boolean avatarStoredInDB) {
        this.avatarStoredInDB = avatarStoredInDB == null ? Boolean.valueOf(false) : avatarStoredInDB;
    }

    public void initForActiveDirectory() {
        this.name = "{cn}";
        this.email = "{mail}";
        this.fullName = "{displayName}";
        this.nickname = "";
        this.birthday = "";
        this.photo = "{jpegPhoto}";
        this.homeStreet = "{homePostalAddress}";
        this.homeCity = "";
        this.homeState = "";
        this.homeZip = "{homeZip}";
        this.homeCountry = "{co}";
        this.homePhone = "{homePhone}";
        this.homeMobile = "{mobile}";
        this.homeFax = "";
        this.homePager = "";
        this.businessStreet = "{streetAddress}";
        this.businessCity = "{l}";
        this.businessState = "{st}";
        this.businessZip = "{postalCode}";
        this.businessCountry = "{co}";
        this.businessJobTitle = "{title}";
        this.businessDepartment = "{department}";
        this.businessPhone = "{telephoneNumber}";
        this.businessMobile = "{mobile}";
        this.businessFax = "{facsimileTelephoneNumber}";
        this.businessPager = "{pager}";
        this.avatarStoredInDB = false;
    }

    public void initForOpenLDAP() {
        this.name = "{cn}";
        this.email = "{mail}";
        this.fullName = "{displayName}";
        this.nickname = "{uid}";
        this.birthday = "";
        this.photo = "{jpegPhoto}";
        this.homeStreet = "{homePostalAddress}";
        this.homeCity = "";
        this.homeState = "";
        this.homeZip = "";
        this.homeCountry = "";
        this.homePhone = "{homePhone}";
        this.homeMobile = "";
        this.homeFax = "";
        this.homePager = "";
        this.businessStreet = "{postalAddress}";
        this.businessCity = "{l}";
        this.businessState = "{st}";
        this.businessZip = "{postalCode}";
        this.businessCountry = "";
        this.businessJobTitle = "{title}";
        this.businessDepartment = "{departmentNumber}";
        this.businessPhone = "{telephoneNumber}";
        this.businessMobile = "{mobile}";
        this.businessFax = "";
        this.businessPager = "{pager}";
        this.avatarStoredInDB = false;
    }

    public void saveProperties() {
        String vcardXML;
        Element subelement;
        Element vCard = DocumentHelper.createElement((QName)QName.get((String)"vCard", (String)"vcard-temp"));
        if (this.name != null && this.name.trim().length() > 0) {
            subelement = vCard.addElement("N");
            subelement.addElement("GIVEN").setText(this.name.trim());
        }
        if (this.email != null && this.email.trim().length() > 0) {
            subelement = vCard.addElement("EMAIL");
            subelement.addElement("INTERNET");
            subelement.addElement("USERID").setText(this.email.trim());
        }
        vCard.addElement("FN").setText(this.fullName.trim());
        if (this.nickname != null && this.nickname.trim().length() > 0) {
            vCard.addElement("NICKNAME").setText(this.nickname.trim());
        }
        if (this.birthday != null && this.birthday.trim().length() > 0) {
            vCard.addElement("BDAY").setText(this.birthday.trim());
        }
        if (this.photo != null && this.photo.trim().length() > 0) {
            Element element = vCard.addElement("PHOTO");
            element.addElement("TYPE").setText("image/jpeg");
            element.addElement("BINVAL").setText(this.photo.trim());
        }
        subelement = vCard.addElement("ADR");
        subelement.addElement("HOME");
        if (this.homeStreet != null && this.homeStreet.trim().length() > 0) {
            subelement.addElement("STREET").setText(this.homeStreet.trim());
        }
        if (this.homeCity != null && this.homeCity.trim().length() > 0) {
            subelement.addElement("LOCALITY").setText(this.homeCity.trim());
        }
        if (this.homeState != null && this.homeState.trim().length() > 0) {
            subelement.addElement("REGION").setText(this.homeState.trim());
        }
        if (this.homeZip != null && this.homeZip.trim().length() > 0) {
            subelement.addElement("PCODE").setText(this.homeZip.trim());
        }
        if (this.homeCountry != null && this.homeCountry.trim().length() > 0) {
            subelement.addElement("CTRY").setText(this.homeCountry.trim());
        }
        subelement = vCard.addElement("ADR");
        subelement.addElement("WORK");
        if (this.businessStreet != null && this.businessStreet.trim().length() > 0) {
            subelement.addElement("STREET").setText(this.businessStreet.trim());
        }
        if (this.businessCity != null && this.businessCity.trim().length() > 0) {
            subelement.addElement("LOCALITY").setText(this.businessCity.trim());
        }
        if (this.businessState != null && this.businessState.trim().length() > 0) {
            subelement.addElement("REGION").setText(this.businessState.trim());
        }
        if (this.businessZip != null && this.businessZip.trim().length() > 0) {
            subelement.addElement("PCODE").setText(this.businessZip.trim());
        }
        if (this.businessCountry != null && this.businessCountry.trim().length() > 0) {
            subelement.addElement("CTRY").setText(this.businessCountry.trim());
        }
        if (this.homePhone != null && this.homePhone.trim().length() > 0) {
            subelement = vCard.addElement("TEL");
            subelement.addElement("HOME");
            subelement.addElement("VOICE");
            subelement.addElement("NUMBER").setText(this.homePhone.trim());
        }
        if (this.homeMobile != null && this.homeMobile.trim().length() > 0) {
            subelement = vCard.addElement("TEL");
            subelement.addElement("HOME");
            subelement.addElement("CELL");
            subelement.addElement("NUMBER").setText(this.homeMobile.trim());
        }
        if (this.homeFax != null && this.homeFax.trim().length() > 0) {
            subelement = vCard.addElement("TEL");
            subelement.addElement("HOME");
            subelement.addElement("FAX");
            subelement.addElement("NUMBER").setText(this.homeFax.trim());
        }
        if (this.homePager != null && this.homePager.trim().length() > 0) {
            subelement = vCard.addElement("TEL");
            subelement.addElement("HOME");
            subelement.addElement("PAGER");
            subelement.addElement("NUMBER").setText(this.homePager.trim());
        }
        if (this.businessPhone != null && this.businessPhone.trim().length() > 0) {
            subelement = vCard.addElement("TEL");
            subelement.addElement("WORK");
            subelement.addElement("VOICE");
            subelement.addElement("NUMBER").setText(this.businessPhone.trim());
        }
        if (this.businessMobile != null && this.businessMobile.trim().length() > 0) {
            subelement = vCard.addElement("TEL");
            subelement.addElement("WORK");
            subelement.addElement("CELL");
            subelement.addElement("NUMBER").setText(this.businessMobile.trim());
        }
        if (this.businessFax != null && this.businessFax.trim().length() > 0) {
            subelement = vCard.addElement("TEL");
            subelement.addElement("WORK");
            subelement.addElement("FAX");
            subelement.addElement("NUMBER").setText(this.businessFax.trim());
        }
        if (this.businessPager != null && this.businessPager.trim().length() > 0) {
            subelement = vCard.addElement("TEL");
            subelement.addElement("WORK");
            subelement.addElement("PAGER");
            subelement.addElement("NUMBER").setText(this.businessPager.trim());
        }
        if (this.businessJobTitle != null && this.businessJobTitle.trim().length() > 0) {
            vCard.addElement("TITLE").setText(this.businessJobTitle.trim());
        }
        if (this.businessDepartment != null && this.businessDepartment.trim().length() > 0) {
            vCard.addElement("ORG").addElement("ORGUNIT").setText(this.businessDepartment.trim());
        }
        StringWriter writer = new StringWriter();
        OutputFormat prettyPrinter = OutputFormat.createPrettyPrint();
        XMLWriter xmlWriter = new XMLWriter(writer, prettyPrinter);
        try {
            xmlWriter.write(vCard);
            vcardXML = writer.toString();
        }
        catch (IOException e) {
            Log.error("Error pretty formating XML", (Throwable)e);
            vcardXML = vCard.asXML();
        }
        StringBuilder sb = new StringBuilder(vcardXML.length());
        sb.append("<![CDATA[").append(vcardXML).append("]]>");
        JiveGlobals.setProperty("ldap.vcard-mapping", sb.toString());
        JiveGlobals.setProperty("provider.vcard.className", LdapVCardProvider.class.getName());
        LdapManager.getInstance().setNameField(this.name.replaceAll("(\\{)([\\d\\D&&[^}]]+)(})", "$2"));
        LdapManager.getInstance().setEmailField(this.email.replaceAll("(\\{)([\\d\\D&&[^}]]+)(})", "$2"));
        JiveGlobals.setProperty("ldap.override.avatar", this.avatarStoredInDB.toString());
    }

    public boolean loadFromProperties() {
        String xmlProperty = JiveGlobals.getProperty("ldap.vcard-mapping");
        if (xmlProperty == null || xmlProperty.trim().length() == 0) {
            return false;
        }
        try {
            Document document;
            Element vCard;
            Element element;
            if (xmlProperty.startsWith("<![CDATA[")) {
                xmlProperty = xmlProperty.substring(9, xmlProperty.length() - 3);
            }
            if ((element = (vCard = (document = DocumentHelper.parseText((String)xmlProperty)).getRootElement()).element("N")) != null) {
                this.name = element.elementTextTrim("GIVEN");
            }
            if ((element = vCard.element("EMAIL")) != null) {
                this.email = element.elementTextTrim("USERID");
            }
            if ((element = vCard.element("FN")) != null) {
                this.fullName = element.getTextTrim();
            }
            if ((element = vCard.element("NICKNAME")) != null) {
                this.nickname = element.getTextTrim();
            }
            if ((element = vCard.element("BDAY")) != null) {
                this.birthday = element.getTextTrim();
            }
            Iterator addresses = vCard.elementIterator("ADR");
            while (addresses.hasNext()) {
                element = (Element)addresses.next();
                if (element.element("HOME") != null) {
                    if (element.element("STREET") != null) {
                        this.homeStreet = element.elementTextTrim("STREET");
                    }
                    if (element.element("LOCALITY") != null) {
                        this.homeCity = element.elementTextTrim("LOCALITY");
                    }
                    if (element.element("REGION") != null) {
                        this.homeState = element.elementTextTrim("REGION");
                    }
                    if (element.element("PCODE") != null) {
                        this.homeZip = element.elementTextTrim("PCODE");
                    }
                    if (element.element("CTRY") == null) continue;
                    this.homeCountry = element.elementTextTrim("CTRY");
                    continue;
                }
                if (element.element("WORK") == null) continue;
                if (element.element("STREET") != null) {
                    this.businessStreet = element.elementTextTrim("STREET");
                }
                if (element.element("LOCALITY") != null) {
                    this.businessCity = element.elementTextTrim("LOCALITY");
                }
                if (element.element("REGION") != null) {
                    this.businessState = element.elementTextTrim("REGION");
                }
                if (element.element("PCODE") != null) {
                    this.businessZip = element.elementTextTrim("PCODE");
                }
                if (element.element("CTRY") == null) continue;
                this.businessCountry = element.elementTextTrim("CTRY");
            }
            Iterator telephones = vCard.elementIterator("TEL");
            while (telephones.hasNext()) {
                element = (Element)telephones.next();
                if (element.element("HOME") != null) {
                    if (element.element("VOICE") != null) {
                        this.homePhone = element.elementTextTrim("NUMBER");
                        continue;
                    }
                    if (element.element("CELL") != null) {
                        this.homeMobile = element.elementTextTrim("NUMBER");
                        continue;
                    }
                    if (element.element("FAX") != null) {
                        this.homeFax = element.elementTextTrim("NUMBER");
                        continue;
                    }
                    if (element.element("PAGER") == null) continue;
                    this.homePager = element.elementTextTrim("NUMBER");
                    continue;
                }
                if (element.element("WORK") == null) continue;
                if (element.element("VOICE") != null) {
                    this.businessPhone = element.elementTextTrim("NUMBER");
                    continue;
                }
                if (element.element("CELL") != null) {
                    this.businessMobile = element.elementTextTrim("NUMBER");
                    continue;
                }
                if (element.element("FAX") != null) {
                    this.businessFax = element.elementTextTrim("NUMBER");
                    continue;
                }
                if (element.element("PAGER") == null) continue;
                this.businessPager = element.elementTextTrim("NUMBER");
            }
            element = vCard.element("TITLE");
            if (element != null) {
                this.businessJobTitle = element.getTextTrim();
            }
            if ((element = vCard.element("ORG")) != null && element.element("ORGUNIT") != null) {
                this.businessDepartment = element.elementTextTrim("ORGUNIT");
            }
            this.avatarStoredInDB = JiveGlobals.getBooleanProperty("ldap.override.avatar", false);
        }
        catch (DocumentException e) {
            Log.error("Error loading vcard mappings from property", (Throwable)e);
            return false;
        }
        return true;
    }
}

