/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.gateway.impl.event;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.StreamSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperledger.fabric.gateway.ContractEvent;
import org.hyperledger.fabric.gateway.impl.event.ContractEventImpl;
import org.hyperledger.fabric.gateway.spi.Checkpointer;
import org.hyperledger.fabric.gateway.spi.CommitListener;
import org.hyperledger.fabric.sdk.BlockEvent;
import org.hyperledger.fabric.sdk.BlockInfo;
import org.hyperledger.fabric.sdk.ChaincodeEvent;
import org.hyperledger.fabric.sdk.Peer;

public final class Listeners {
    private static final Log LOG = LogFactory.getLog(Listeners.class);

    public static Consumer<BlockEvent> fromTransaction(Consumer<BlockEvent.TransactionEvent> listener) {
        return blockEvent -> blockEvent.getTransactionEvents().forEach(listener);
    }

    public static Consumer<BlockEvent> fromContract(Consumer<ContractEvent> listener) {
        return Listeners.fromTransaction(Listeners.transactionFromContract(listener));
    }

    private static Consumer<BlockEvent.TransactionEvent> transactionFromContract(Consumer<ContractEvent> listener) {
        return transactionEvent -> {
            if (transactionEvent.isValid()) {
                StreamSupport.stream(transactionEvent.getTransactionActionInfos().spliterator(), false).map(BlockInfo.TransactionEnvelopeInfo.TransactionActionInfo::getEvent).filter(Objects::nonNull).map(chaincodeEvent -> new ContractEventImpl((BlockEvent.TransactionEvent)transactionEvent, (ChaincodeEvent)chaincodeEvent)).forEach(listener);
            }
        };
    }

    public static Consumer<BlockEvent> checkpointBlock(Checkpointer checkpointer, Consumer<BlockEvent> listener) {
        return blockEvent -> {
            long eventBlockNumber = blockEvent.getBlockNumber();
            try {
                Checkpointer checkpointer2 = checkpointer;
                synchronized (checkpointer2) {
                    long checkpointBlockNumber = checkpointer.getBlockNumber();
                    if (-1L == checkpointBlockNumber) {
                        checkpointBlockNumber = eventBlockNumber;
                        checkpointer.setBlockNumber(checkpointBlockNumber);
                    }
                    if (eventBlockNumber == checkpointBlockNumber) {
                        listener.accept((BlockEvent)blockEvent);
                        checkpointer.setBlockNumber(eventBlockNumber + 1L);
                    } else {
                        LOG.debug((Object)("Reject block number " + eventBlockNumber + " for checkpointer " + checkpointer));
                    }
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
    }

    public static Consumer<BlockEvent> checkpointTransaction(Checkpointer checkpointer, Consumer<BlockEvent.TransactionEvent> listener) {
        Consumer<BlockEvent.TransactionEvent> transactionListener = transactionEvent -> {
            String transactionId = transactionEvent.getTransactionID();
            try {
                Checkpointer checkpointer2 = checkpointer;
                synchronized (checkpointer2) {
                    if (!checkpointer.getTransactionIds().contains(transactionId)) {
                        listener.accept((BlockEvent.TransactionEvent)transactionEvent);
                        checkpointer.addTransactionId(transactionId);
                    } else {
                        LOG.debug((Object)("Reject transaction ID " + transactionId + " for checkpointer " + checkpointer));
                    }
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
        return Listeners.checkpointBlock(checkpointer, Listeners.fromTransaction(transactionListener));
    }

    public static Consumer<BlockEvent> checkpointContract(Checkpointer checkpointer, Consumer<ContractEvent> listener) {
        return Listeners.checkpointTransaction(checkpointer, Listeners.transactionFromContract(listener));
    }

    public static Consumer<ContractEvent> contract(Consumer<ContractEvent> listener, String chaincodeId) {
        return contractEvent -> {
            if (contractEvent.getChaincodeId().equals(chaincodeId)) {
                listener.accept((ContractEvent)contractEvent);
            }
        };
    }

    public static Consumer<ContractEvent> contract(Consumer<ContractEvent> listener, String chaincodeId, Pattern namePattern) {
        return Listeners.contract(contractEvent -> {
            if (namePattern.matcher(contractEvent.getName()).matches()) {
                listener.accept((ContractEvent)contractEvent);
            }
        }, chaincodeId);
    }

    public static Consumer<BlockEvent.TransactionEvent> transaction(CommitListener listener, Collection<Peer> peers, String transactionId) {
        HashSet<Peer> peerSet = new HashSet<Peer>(peers);
        return transactionEvent -> {
            if (transactionEvent.getTransactionID().equals(transactionId) && peerSet.contains(transactionEvent.getPeer())) {
                listener.acceptCommit((BlockEvent.TransactionEvent)transactionEvent);
            }
        };
    }

    private Listeners() {
    }
}

