/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.traces;

import java.util.Properties;
import java.util.logging.Logger;
import org.hyperledger.fabric.traces.TracesProvider;
import org.hyperledger.fabric.traces.impl.DefaultTracesProvider;
import org.hyperledger.fabric.traces.impl.NullProvider;

public final class Traces {
    private static final String CHAINCODE_TRACES_ENABLED = "CHAINCODE_TRACES_ENABLED";
    private static final String CHAINCODE_TRACES_PROVIDER = "CHAINCODE_TRACES_PROVIDER";
    private static Logger logger = Logger.getLogger(Traces.class.getName());
    private static TracesProvider provider;

    private Traces() {
    }

    public static TracesProvider initialize(Properties props) {
        if (Boolean.parseBoolean((String)props.get(CHAINCODE_TRACES_ENABLED))) {
            try {
                logger.info("Traces enabled");
                if (props.containsKey(CHAINCODE_TRACES_PROVIDER)) {
                    String providerClass = (String)props.get(CHAINCODE_TRACES_PROVIDER);
                    Class<?> clazz = Class.forName(providerClass);
                    provider = (TracesProvider)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                logger.info("Using default traces provider");
                provider = new DefaultTracesProvider();
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to start traces", e);
            }
        } else {
            logger.info("Traces disabled");
            provider = new NullProvider();
        }
        provider.initialize(props);
        return provider;
    }

    public static TracesProvider getProvider() {
        if (provider == null) {
            throw new IllegalStateException("No provider set, this should have been set");
        }
        return provider;
    }
}

