/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.contract.routing.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.hyperledger.fabric.contract.metadata.TypeSchema;
import org.hyperledger.fabric.contract.routing.DataTypeDefinition;
import org.hyperledger.fabric.contract.routing.TypeRegistry;
import org.hyperledger.fabric.contract.routing.impl.DataTypeDefinitionImpl;

public final class TypeRegistryImpl
implements TypeRegistry {
    private static final TypeRegistryImpl INSTANCE = new TypeRegistryImpl();
    private final Map<String, DataTypeDefinition> components = new HashMap<String, DataTypeDefinition>();

    public static TypeRegistry getInstance() {
        return INSTANCE;
    }

    @Override
    public void addDataType(Class<?> cl) {
        DataTypeDefinitionImpl type = new DataTypeDefinitionImpl(cl);
        this.components.put(type.getSimpleName(), type);
    }

    @Override
    public Collection<DataTypeDefinition> getAllDataTypes() {
        return this.components.values();
    }

    @Override
    public void addDataType(DataTypeDefinition type) {
        this.components.put(type.getName(), type);
    }

    @Override
    public DataTypeDefinition getDataType(String name) {
        return this.components.get(name);
    }

    @Override
    public DataTypeDefinition getDataType(TypeSchema schema) {
        String ref = schema.getRef();
        String format = ref.substring(ref.lastIndexOf(47) + 1);
        return this.getDataType(format);
    }
}

