/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.shim.impl;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import org.hyperledger.fabric.metrics.TaskMetricsCollector;

public final class InvocationTaskExecutor
extends ThreadPoolExecutor
implements TaskMetricsCollector {
    private static Logger logger = Logger.getLogger(InvocationTaskExecutor.class.getName());
    private final AtomicInteger count = new AtomicInteger();

    public InvocationTaskExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory factory, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, factory, handler);
        this.prestartCoreThread();
        logger.info("Thread pool created");
    }

    @Override
    protected void beforeExecute(Thread thread, Runnable task) {
        super.beforeExecute(thread, task);
        this.count.incrementAndGet();
    }

    @Override
    protected void afterExecute(Runnable task, Throwable throwable) {
        this.count.decrementAndGet();
        super.afterExecute(task, throwable);
    }

    @Override
    public int getCurrentTaskCount() {
        return this.count.get();
    }

    @Override
    public int getCurrentQueueCount() {
        return this.getQueue().size();
    }
}

