/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.shim.impl;

import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.logging.Logger;
import org.hyperledger.fabric.protos.peer.ChaincodeMessage;
import org.hyperledger.fabric.protos.peer.ChaincodeSupportGrpc;
import org.hyperledger.fabric.shim.impl.InvocationTaskManager;
import org.hyperledger.fabric.traces.Traces;

public class ChaincodeSupportClient {
    private static final int DEFAULT_TIMEOUT = 5;
    private static final Logger LOGGER = Logger.getLogger(ChaincodeSupportClient.class.getName());
    private static Logger perflogger = Logger.getLogger("org.hyperledger.Performance");
    private final ManagedChannel channel;
    private final ChaincodeSupportGrpc.ChaincodeSupportStub stub;

    public ChaincodeSupportClient(ManagedChannelBuilder<?> channelBuilder) {
        ClientInterceptor interceptor = Traces.getProvider().createInterceptor();
        if (interceptor != null) {
            channelBuilder.intercept(new ClientInterceptor[]{interceptor});
        }
        this.channel = channelBuilder.build();
        this.stub = ChaincodeSupportGrpc.newStub((Channel)this.channel);
    }

    public void shutdown(InvocationTaskManager itm) {
        itm.shutdown();
        try {
            this.channel.shutdown();
            if (!this.channel.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.channel.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.channel.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public void start(InvocationTaskManager itm, final StreamObserver<ChaincodeMessage> requestObserver) throws IOException {
        if (requestObserver == null) {
            throw new IOException("StreamObserver 'requestObserver' for chat with peer can't be null");
        }
        if (itm == null) {
            throw new IOException("InnvocationTaskManager 'itm' can't be null");
        }
        Consumer<ChaincodeMessage> consumer = new Consumer<ChaincodeMessage>(){
            private final ReentrantLock lock = new ReentrantLock(true);

            @Override
            public void accept(ChaincodeMessage t) {
                this.lock.lock();
                perflogger.fine(() -> "> sendToPeer TX::" + t.getTxid());
                requestObserver.onNext((Object)t);
                perflogger.fine(() -> "< sendToPeer TX::" + t.getTxid());
                this.lock.unlock();
            }
        };
        itm.setResponseConsumer(consumer).register();
    }

    public ChaincodeSupportGrpc.ChaincodeSupportStub getStub() {
        return this.stub;
    }
}

