/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.shim.impl;

import com.google.protobuf.ByteString;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.hyperledger.fabric.protos.peer.ChaincodeEvent;
import org.hyperledger.fabric.protos.peer.ChaincodeID;
import org.hyperledger.fabric.protos.peer.ChaincodeMessage;
import org.hyperledger.fabric.protos.peer.DelState;
import org.hyperledger.fabric.protos.peer.GetState;
import org.hyperledger.fabric.protos.peer.GetStateMetadata;
import org.hyperledger.fabric.protos.peer.PutState;
import org.hyperledger.fabric.protos.peer.PutStateMetadata;
import org.hyperledger.fabric.protos.peer.Response;
import org.hyperledger.fabric.protos.peer.StateMetadata;
import org.hyperledger.fabric.shim.Chaincode;

public final class ChaincodeMessageFactory {
    private ChaincodeMessageFactory() {
    }

    protected static ChaincodeMessage newGetPrivateDataHashEventMessage(String channelId, String txId, String collection, String key) {
        return ChaincodeMessageFactory.newEventMessage(ChaincodeMessage.Type.GET_PRIVATE_DATA_HASH, channelId, txId, GetState.newBuilder().setCollection(collection).setKey(key).build().toByteString());
    }

    protected static ChaincodeMessage newGetStateEventMessage(String channelId, String txId, String collection, String key) {
        return ChaincodeMessageFactory.newEventMessage(ChaincodeMessage.Type.GET_STATE, channelId, txId, GetState.newBuilder().setCollection(collection).setKey(key).build().toByteString());
    }

    protected static ChaincodeMessage newGetStateMetadataEventMessage(String channelId, String txId, String collection, String key) {
        return ChaincodeMessageFactory.newEventMessage(ChaincodeMessage.Type.GET_STATE_METADATA, channelId, txId, GetStateMetadata.newBuilder().setCollection(collection).setKey(key).build().toByteString());
    }

    protected static ChaincodeMessage newPutStateEventMessage(String channelId, String txId, String collection, String key, ByteString value) {
        return ChaincodeMessageFactory.newEventMessage(ChaincodeMessage.Type.PUT_STATE, channelId, txId, PutState.newBuilder().setCollection(collection).setKey(key).setValue(value).build().toByteString());
    }

    protected static ChaincodeMessage newPutStateMetadataEventMessage(String channelId, String txId, String collection, String key, String metakey, ByteString value) {
        return ChaincodeMessageFactory.newEventMessage(ChaincodeMessage.Type.PUT_STATE_METADATA, channelId, txId, PutStateMetadata.newBuilder().setCollection(collection).setKey(key).setMetadata(StateMetadata.newBuilder().setMetakey(metakey).setValue(value).build()).build().toByteString());
    }

    protected static ChaincodeMessage newDeleteStateEventMessage(String channelId, String txId, String collection, String key) {
        return ChaincodeMessageFactory.newEventMessage(ChaincodeMessage.Type.DEL_STATE, channelId, txId, DelState.newBuilder().setCollection(collection).setKey(key).build().toByteString());
    }

    protected static ChaincodeMessage newPurgeStateEventMessage(String channelId, String txId, String collection, String key) {
        return ChaincodeMessageFactory.newEventMessage(ChaincodeMessage.Type.PURGE_PRIVATE_DATA, channelId, txId, DelState.newBuilder().setCollection(collection).setKey(key).build().toByteString());
    }

    protected static ChaincodeMessage newErrorEventMessage(String channelId, String txId, Throwable throwable) {
        return ChaincodeMessageFactory.newErrorEventMessage(channelId, txId, ChaincodeMessageFactory.printStackTrace(throwable));
    }

    protected static ChaincodeMessage newErrorEventMessage(String channelId, String txId, String message) {
        return ChaincodeMessageFactory.newErrorEventMessage(channelId, txId, message, null);
    }

    protected static ChaincodeMessage newErrorEventMessage(String channelId, String txId, String message, ChaincodeEvent event) {
        return ChaincodeMessageFactory.newEventMessage(ChaincodeMessage.Type.ERROR, channelId, txId, ByteString.copyFromUtf8((String)message), event);
    }

    protected static ChaincodeMessage newCompletedEventMessage(String channelId, String txId, Chaincode.Response response, ChaincodeEvent event) {
        ChaincodeMessage message = ChaincodeMessageFactory.newEventMessage(ChaincodeMessage.Type.COMPLETED, channelId, txId, ChaincodeMessageFactory.toProtoResponse(response).toByteString(), event);
        return message;
    }

    protected static ChaincodeMessage newInvokeChaincodeMessage(String channelId, String txId, ByteString payload) {
        return ChaincodeMessageFactory.newEventMessage(ChaincodeMessage.Type.INVOKE_CHAINCODE, channelId, txId, payload, null);
    }

    protected static ChaincodeMessage newRegisterChaincodeMessage(ChaincodeID chaincodeId) {
        return ChaincodeMessage.newBuilder().setType(ChaincodeMessage.Type.REGISTER).setPayload(chaincodeId.toByteString()).build();
    }

    protected static ChaincodeMessage newEventMessage(ChaincodeMessage.Type type, String channelId, String txId, ByteString payload) {
        return ChaincodeMessageFactory.newEventMessage(type, channelId, txId, payload, null);
    }

    protected static ChaincodeMessage newEventMessage(ChaincodeMessage.Type type, String channelId, String txId, ByteString payload, ChaincodeEvent event) {
        ChaincodeMessage.Builder builder = ChaincodeMessage.newBuilder().setType(type).setChannelId(channelId).setTxid(txId).setPayload(payload);
        if (event != null) {
            builder.setChaincodeEvent(event);
        }
        return builder.build();
    }

    private static Response toProtoResponse(Chaincode.Response response) {
        Response.Builder builder = Response.newBuilder();
        builder.setStatus(response.getStatus().getCode());
        if (response.getMessage() != null) {
            builder.setMessage(response.getMessage());
        }
        if (response.getPayload() != null) {
            builder.setPayload(ByteString.copyFrom((byte[])response.getPayload()));
        }
        return builder.build();
    }

    private static String printStackTrace(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        StringWriter buffer = new StringWriter();
        throwable.printStackTrace(new PrintWriter(buffer));
        return buffer.toString();
    }
}

