/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.contract;

import java.io.IOException;
import java.security.cert.CertificateException;
import org.hyperledger.fabric.contract.ClientIdentity;
import org.hyperledger.fabric.contract.ContractRuntimeException;
import org.hyperledger.fabric.shim.ChaincodeStub;
import org.json.JSONException;

public class Context {
    protected ChaincodeStub stub;
    protected ClientIdentity clientIdentity;

    public Context(ChaincodeStub stub) {
        this.stub = stub;
        try {
            this.clientIdentity = new ClientIdentity(stub);
        }
        catch (IOException | CertificateException | JSONException e) {
            throw new ContractRuntimeException("Could not create new client identity", e);
        }
    }

    public ChaincodeStub getStub() {
        return this.stub;
    }

    public ClientIdentity getClientIdentity() {
        return this.clientIdentity;
    }
}

