/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.shim.impl;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.function.Function;
import java.util.logging.Logger;
import org.hyperledger.fabric.protos.peer.ChaincodeShim;
import org.hyperledger.fabric.shim.impl.ChaincodeInvocationTask;
import org.hyperledger.fabric.shim.impl.QueryResultsIteratorImpl;
import org.hyperledger.fabric.shim.ledger.QueryResultsIteratorWithMetadata;

public final class QueryResultsIteratorWithMetadataImpl<T>
extends QueryResultsIteratorImpl<T>
implements QueryResultsIteratorWithMetadata<T> {
    private static Logger logger = Logger.getLogger(QueryResultsIteratorWithMetadataImpl.class.getName());
    private ChaincodeShim.QueryResponseMetadata metadata;

    public QueryResultsIteratorWithMetadataImpl(ChaincodeInvocationTask handler, String channelId, String txId, ByteString responseBuffer, Function<ChaincodeShim.QueryResultBytes, T> mapper) {
        super(handler, channelId, txId, responseBuffer, mapper);
        try {
            ChaincodeShim.QueryResponse queryResponse = ChaincodeShim.QueryResponse.parseFrom((ByteString)responseBuffer);
            this.metadata = ChaincodeShim.QueryResponseMetadata.parseFrom((ByteString)queryResponse.getMetadata());
        }
        catch (InvalidProtocolBufferException e) {
            logger.warning("can't parse response metadata");
            throw new RuntimeException(e);
        }
    }

    @Override
    public ChaincodeShim.QueryResponseMetadata getMetadata() {
        return this.metadata;
    }
}

