/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.contract.routing.impl;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ScanResult;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.hyperledger.fabric.Logger;
import org.hyperledger.fabric.contract.annotation.Serializer;
import org.hyperledger.fabric.contract.execution.SerializerInterface;

public class SerializerRegistryImpl {
    private static Logger logger = Logger.getLogger(SerializerRegistryImpl.class);
    private final Class<Serializer> annotationClass = Serializer.class;
    private final Map<String, SerializerInterface> contents = new HashMap<String, SerializerInterface>();

    public SerializerInterface getSerializer(String name, Serializer.TARGET target) {
        String key = name + ":" + (Object)((Object)target);
        return this.contents.get(key);
    }

    private SerializerInterface add(String name, Serializer.TARGET target, Class<SerializerInterface> clazz) {
        logger.debug(() -> "Adding new Class " + clazz.getCanonicalName() + " for " + (Object)((Object)target));
        try {
            String key = name + ":" + (Object)((Object)target);
            SerializerInterface newObj = clazz.newInstance();
            this.contents.put(key, newObj);
            return newObj;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    public void findAndSetContents() throws InstantiationException, IllegalAccessException {
        ClassGraph classGraph = new ClassGraph().enableClassInfo().enableAnnotationInfo();
        HashSet<String> seenClass = new HashSet<String>();
        try (ScanResult scanResult = classGraph.scan();){
            for (ClassInfo classInfo : scanResult.getClassesWithAnnotation(this.annotationClass.getCanonicalName())) {
                logger.debug("Found class with contract annotation: " + classInfo.getName());
                try {
                    Class cls = classInfo.loadClass();
                    logger.debug("Loaded class");
                    String className = cls.getCanonicalName();
                    if (seenClass.contains(className)) continue;
                    seenClass.add(className);
                    this.add(className, Serializer.TARGET.TRANSACTION, cls);
                }
                catch (IllegalArgumentException e) {
                    logger.debug("Failed to load class: " + e);
                }
            }
        }
    }
}

