/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.contract.execution;

import org.hyperledger.fabric.contract.execution.ExecutionService;
import org.hyperledger.fabric.contract.execution.InvocationRequest;
import org.hyperledger.fabric.contract.execution.SerializerInterface;
import org.hyperledger.fabric.contract.execution.impl.ContractExecutionService;
import org.hyperledger.fabric.contract.execution.impl.ContractInvocationRequest;
import org.hyperledger.fabric.shim.ChaincodeStub;

public class ExecutionFactory {
    private static ExecutionFactory rf;
    private static ExecutionService es;

    public static ExecutionFactory getInstance() {
        if (rf == null) {
            rf = new ExecutionFactory();
        }
        return rf;
    }

    public InvocationRequest createRequest(ChaincodeStub context) {
        return new ContractInvocationRequest(context);
    }

    public ExecutionService createExecutionService(SerializerInterface serializers) {
        if (es == null) {
            es = new ContractExecutionService(serializers);
        }
        return es;
    }
}

