/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.shim.impl;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Timestamp;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.hyperledger.fabric.protos.common.Common;
import org.hyperledger.fabric.protos.ledger.queryresult.KvQueryResult;
import org.hyperledger.fabric.protos.peer.Chaincode;
import org.hyperledger.fabric.protos.peer.ChaincodeEventPackage;
import org.hyperledger.fabric.protos.peer.ChaincodeShim;
import org.hyperledger.fabric.protos.peer.ProposalPackage;
import org.hyperledger.fabric.protos.peer.ProposalResponsePackage;
import org.hyperledger.fabric.protos.peer.TransactionPackage;
import org.hyperledger.fabric.shim.Chaincode;
import org.hyperledger.fabric.shim.ChaincodeStub;
import org.hyperledger.fabric.shim.impl.ChaincodeInvocationTask;
import org.hyperledger.fabric.shim.impl.ChaincodeMessageFactory;
import org.hyperledger.fabric.shim.impl.KeyModificationImpl;
import org.hyperledger.fabric.shim.impl.KeyValueImpl;
import org.hyperledger.fabric.shim.impl.QueryResultsIteratorImpl;
import org.hyperledger.fabric.shim.impl.QueryResultsIteratorWithMetadataImpl;
import org.hyperledger.fabric.shim.ledger.CompositeKey;
import org.hyperledger.fabric.shim.ledger.KeyModification;
import org.hyperledger.fabric.shim.ledger.KeyValue;
import org.hyperledger.fabric.shim.ledger.QueryResultsIterator;
import org.hyperledger.fabric.shim.ledger.QueryResultsIteratorWithMetadata;

class InvocationStubImpl
implements ChaincodeStub {
    private static final String UNSPECIFIED_START_KEY = new String(Character.toChars(1));
    private static final String UNSPECIFIED_END_KEY = "";
    private static final Logger LOGGER = Logger.getLogger(InvocationStubImpl.class.getName());
    public static final String MAX_UNICODE_RUNE = "\udbff\udfff";
    private static final String CORE_PEER_LOCALMSPID = "CORE_PEER_LOCALMSPID";
    private final String channelId;
    private final String txId;
    private final ChaincodeInvocationTask handler;
    private final List<ByteString> args;
    private final ProposalPackage.SignedProposal signedProposal;
    private final Instant txTimestamp;
    private final ByteString creator;
    private final Map<String, ByteString> transientMap;
    private final byte[] binding;
    private ChaincodeEventPackage.ChaincodeEvent event;
    private final Function<ChaincodeShim.QueryResultBytes, KvQueryResult.KV> queryResultBytesToKv = new Function<ChaincodeShim.QueryResultBytes, KvQueryResult.KV>(){

        @Override
        public KvQueryResult.KV apply(ChaincodeShim.QueryResultBytes queryResultBytes) {
            try {
                return KvQueryResult.KV.parseFrom((ByteString)queryResultBytes.getResultBytes());
            }
            catch (InvalidProtocolBufferException e) {
                throw new RuntimeException(e);
            }
        }
    };
    private final Function<ChaincodeShim.QueryResultBytes, KvQueryResult.KeyModification> queryResultBytesToKeyModification = new Function<ChaincodeShim.QueryResultBytes, KvQueryResult.KeyModification>(){

        @Override
        public KvQueryResult.KeyModification apply(ChaincodeShim.QueryResultBytes queryResultBytes) {
            try {
                return KvQueryResult.KeyModification.parseFrom((ByteString)queryResultBytes.getResultBytes());
            }
            catch (InvalidProtocolBufferException e) {
                throw new RuntimeException(e);
            }
        }
    };

    InvocationStubImpl(ChaincodeShim.ChaincodeMessage message, ChaincodeInvocationTask handler) throws InvalidProtocolBufferException {
        this.channelId = message.getChannelId();
        this.txId = message.getTxid();
        this.handler = handler;
        Chaincode.ChaincodeInput input = Chaincode.ChaincodeInput.parseFrom((ByteString)message.getPayload());
        this.args = Collections.unmodifiableList(input.getArgsList());
        this.signedProposal = message.getProposal();
        if (this.signedProposal == null || this.signedProposal.getProposalBytes().isEmpty()) {
            this.creator = null;
            this.txTimestamp = null;
            this.transientMap = Collections.emptyMap();
            this.binding = null;
        } else {
            try {
                ProposalPackage.Proposal proposal = ProposalPackage.Proposal.parseFrom((ByteString)this.signedProposal.getProposalBytes());
                Common.Header header = Common.Header.parseFrom((ByteString)proposal.getHeader());
                Common.ChannelHeader channelHeader = Common.ChannelHeader.parseFrom((ByteString)header.getChannelHeader());
                this.validateProposalType(channelHeader);
                Common.SignatureHeader signatureHeader = Common.SignatureHeader.parseFrom((ByteString)header.getSignatureHeader());
                ProposalPackage.ChaincodeProposalPayload chaincodeProposalPayload = ProposalPackage.ChaincodeProposalPayload.parseFrom((ByteString)proposal.getPayload());
                Timestamp timestamp = channelHeader.getTimestamp();
                this.txTimestamp = Instant.ofEpochSecond(timestamp.getSeconds(), timestamp.getNanos());
                this.creator = signatureHeader.getCreator();
                this.transientMap = chaincodeProposalPayload.getTransientMapMap();
                this.binding = this.computeBinding(channelHeader, signatureHeader);
            }
            catch (InvalidProtocolBufferException | NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private byte[] computeBinding(Common.ChannelHeader channelHeader, Common.SignatureHeader signatureHeader) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        messageDigest.update(signatureHeader.getNonce().asReadOnlyByteBuffer());
        messageDigest.update(this.creator.asReadOnlyByteBuffer());
        ByteBuffer epochBytes = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putLong(channelHeader.getEpoch());
        epochBytes.flip();
        messageDigest.update(epochBytes);
        return messageDigest.digest();
    }

    private void validateProposalType(Common.ChannelHeader channelHeader) {
        switch (Common.HeaderType.forNumber((int)channelHeader.getType())) {
            case ENDORSER_TRANSACTION: 
            case CONFIG: {
                return;
            }
        }
        throw new RuntimeException(String.format("Unexpected transaction type: %s", Common.HeaderType.forNumber((int)channelHeader.getType())));
    }

    @Override
    public List<byte[]> getArgs() {
        return this.args.stream().map(x -> x.toByteArray()).collect(Collectors.toList());
    }

    @Override
    public List<String> getStringArgs() {
        return this.args.stream().map(x -> x.toStringUtf8()).collect(Collectors.toList());
    }

    @Override
    public String getFunction() {
        return this.getStringArgs().size() > 0 ? this.getStringArgs().get(0) : null;
    }

    @Override
    public List<String> getParameters() {
        return this.getStringArgs().stream().skip(1L).collect(Collectors.toList());
    }

    @Override
    public void setEvent(String name, byte[] payload) {
        if (name == null || name.trim().isEmpty()) {
            throw new IllegalArgumentException("event name can not be nil string");
        }
        this.event = payload != null ? ChaincodeEventPackage.ChaincodeEvent.newBuilder().setEventName(name).setPayload(ByteString.copyFrom((byte[])payload)).build() : ChaincodeEventPackage.ChaincodeEvent.newBuilder().setEventName(name).build();
    }

    @Override
    public ChaincodeEventPackage.ChaincodeEvent getEvent() {
        return this.event;
    }

    @Override
    public String getChannelId() {
        return this.channelId;
    }

    @Override
    public String getTxId() {
        return this.txId;
    }

    @Override
    public byte[] getState(String key) {
        return this.handler.invoke(ChaincodeMessageFactory.newGetStateEventMessage(this.channelId, this.txId, UNSPECIFIED_END_KEY, key)).toByteArray();
    }

    @Override
    public byte[] getStateValidationParameter(String key) {
        ByteString payload = this.handler.invoke(ChaincodeMessageFactory.newGetStateMetadataEventMessage(this.channelId, this.txId, UNSPECIFIED_END_KEY, key));
        try {
            ChaincodeShim.StateMetadataResult stateMetadataResult = ChaincodeShim.StateMetadataResult.parseFrom((ByteString)payload);
            HashMap stateMetadataMap = new HashMap();
            stateMetadataResult.getEntriesList().forEach(entry -> stateMetadataMap.put(entry.getMetakey(), entry.getValue()));
            if (stateMetadataMap.containsKey(TransactionPackage.MetaDataKeys.VALIDATION_PARAMETER.toString())) {
                return ((ByteString)stateMetadataMap.get(TransactionPackage.MetaDataKeys.VALIDATION_PARAMETER.toString())).toByteArray();
            }
        }
        catch (InvalidProtocolBufferException e) {
            LOGGER.severe(String.format("[%-8.8s] unmarshalling error", this.txId));
            throw new RuntimeException("Error unmarshalling StateMetadataResult.", e);
        }
        return null;
    }

    @Override
    public void putState(String key, byte[] value) {
        this.validateKey(key);
        this.handler.invoke(ChaincodeMessageFactory.newPutStateEventMessage(this.channelId, this.txId, UNSPECIFIED_END_KEY, key, ByteString.copyFrom((byte[])value)));
    }

    @Override
    public void setStateValidationParameter(String key, byte[] value) {
        this.validateKey(key);
        ChaincodeShim.ChaincodeMessage msg = ChaincodeMessageFactory.newPutStateMetadataEventMessage(this.channelId, this.txId, UNSPECIFIED_END_KEY, key, TransactionPackage.MetaDataKeys.VALIDATION_PARAMETER.toString(), ByteString.copyFrom((byte[])value));
        this.handler.invoke(msg);
    }

    @Override
    public void delState(String key) {
        ChaincodeShim.ChaincodeMessage msg = ChaincodeMessageFactory.newDeleteStateEventMessage(this.channelId, this.txId, UNSPECIFIED_END_KEY, key);
        this.handler.invoke(msg);
    }

    @Override
    public QueryResultsIterator<KeyValue> getStateByRange(String startKey, String endKey) {
        String start = startKey;
        String end = endKey;
        if (startKey == null || startKey.isEmpty()) {
            start = UNSPECIFIED_START_KEY;
        }
        if (endKey == null) {
            end = UNSPECIFIED_END_KEY;
        }
        CompositeKey.validateSimpleKeys(start, end);
        return this.executeGetStateByRange(UNSPECIFIED_END_KEY, start, end);
    }

    private QueryResultsIterator<KeyValue> executeGetStateByRange(String collection, String startKey, String endKey) {
        ByteString requestPayload = ChaincodeShim.GetStateByRange.newBuilder().setCollection(collection).setStartKey(startKey).setEndKey(endKey).build().toByteString();
        ChaincodeShim.ChaincodeMessage requestMessage = ChaincodeMessageFactory.newEventMessage(ChaincodeShim.ChaincodeMessage.Type.GET_STATE_BY_RANGE, this.channelId, this.txId, requestPayload);
        ByteString response = this.handler.invoke(requestMessage);
        return new QueryResultsIteratorImpl<KeyValue>(this.handler, this.channelId, this.txId, response, this.queryResultBytesToKv.andThen(KeyValueImpl::new));
    }

    @Override
    public QueryResultsIteratorWithMetadata<KeyValue> getStateByRangeWithPagination(String startKey, String endKey, int pageSize, String bookmark) {
        String start = startKey;
        String end = endKey;
        if (startKey == null || startKey.isEmpty()) {
            start = UNSPECIFIED_START_KEY;
        }
        if (endKey == null) {
            end = UNSPECIFIED_END_KEY;
        }
        CompositeKey.validateSimpleKeys(start, end);
        ChaincodeShim.QueryMetadata queryMetadata = ChaincodeShim.QueryMetadata.newBuilder().setBookmark(bookmark).setPageSize(pageSize).build();
        return this.executeGetStateByRangeWithMetadata(UNSPECIFIED_END_KEY, start, end, queryMetadata.toByteString());
    }

    private QueryResultsIteratorWithMetadataImpl<KeyValue> executeGetStateByRangeWithMetadata(String collection, String startKey, String endKey, ByteString metadata) {
        ByteString payload = ChaincodeShim.GetStateByRange.newBuilder().setCollection(collection).setStartKey(startKey).setEndKey(endKey).setMetadata(metadata).build().toByteString();
        ChaincodeShim.ChaincodeMessage requestMessage = ChaincodeMessageFactory.newEventMessage(ChaincodeShim.ChaincodeMessage.Type.GET_STATE_BY_RANGE, this.channelId, this.txId, payload);
        ByteString response = this.handler.invoke(requestMessage);
        return new QueryResultsIteratorWithMetadataImpl<KeyValue>(this.handler, this.getChannelId(), this.getTxId(), response, this.queryResultBytesToKv.andThen(KeyValueImpl::new));
    }

    @Override
    public QueryResultsIterator<KeyValue> getStateByPartialCompositeKey(String compositeKey) {
        CompositeKey key = compositeKey.startsWith(CompositeKey.NAMESPACE) ? CompositeKey.parseCompositeKey(compositeKey) : new CompositeKey(compositeKey, new String[0]);
        return this.getStateByPartialCompositeKey(key);
    }

    @Override
    public QueryResultsIterator<KeyValue> getStateByPartialCompositeKey(String objectType, String ... attributes) {
        return this.getStateByPartialCompositeKey(new CompositeKey(objectType, attributes));
    }

    @Override
    public QueryResultsIterator<KeyValue> getStateByPartialCompositeKey(CompositeKey compositeKey) {
        String cKeyAsString = compositeKey == null ? new CompositeKey(UNSPECIFIED_START_KEY, new String[0]).toString() : compositeKey.toString();
        return this.executeGetStateByRange(UNSPECIFIED_END_KEY, cKeyAsString, cKeyAsString + MAX_UNICODE_RUNE);
    }

    @Override
    public QueryResultsIteratorWithMetadata<KeyValue> getStateByPartialCompositeKeyWithPagination(CompositeKey compositeKey, int pageSize, String bookmark) {
        String cKeyAsString = compositeKey == null ? new CompositeKey(UNSPECIFIED_START_KEY, new String[0]).toString() : compositeKey.toString();
        ChaincodeShim.QueryMetadata queryMetadata = ChaincodeShim.QueryMetadata.newBuilder().setBookmark(bookmark).setPageSize(pageSize).build();
        return this.executeGetStateByRangeWithMetadata(UNSPECIFIED_END_KEY, cKeyAsString, cKeyAsString + MAX_UNICODE_RUNE, queryMetadata.toByteString());
    }

    @Override
    public CompositeKey createCompositeKey(String objectType, String ... attributes) {
        return new CompositeKey(objectType, attributes);
    }

    @Override
    public CompositeKey splitCompositeKey(String compositeKey) {
        return CompositeKey.parseCompositeKey(compositeKey);
    }

    @Override
    public QueryResultsIterator<KeyValue> getQueryResult(String query) {
        ByteString requestPayload = ChaincodeShim.GetQueryResult.newBuilder().setCollection(UNSPECIFIED_END_KEY).setQuery(query).build().toByteString();
        ChaincodeShim.ChaincodeMessage requestMessage = ChaincodeMessageFactory.newEventMessage(ChaincodeShim.ChaincodeMessage.Type.GET_QUERY_RESULT, this.channelId, this.txId, requestPayload);
        ByteString response = this.handler.invoke(requestMessage);
        return new QueryResultsIteratorImpl<KeyValue>(this.handler, this.channelId, this.txId, response, this.queryResultBytesToKv.andThen(KeyValueImpl::new));
    }

    @Override
    public QueryResultsIteratorWithMetadata<KeyValue> getQueryResultWithPagination(String query, int pageSize, String bookmark) {
        ByteString queryMetadataPayload = ChaincodeShim.QueryMetadata.newBuilder().setBookmark(bookmark).setPageSize(pageSize).build().toByteString();
        ByteString requestPayload = ChaincodeShim.GetQueryResult.newBuilder().setCollection(UNSPECIFIED_END_KEY).setQuery(query).setMetadata(queryMetadataPayload).build().toByteString();
        ChaincodeShim.ChaincodeMessage requestMessage = ChaincodeMessageFactory.newEventMessage(ChaincodeShim.ChaincodeMessage.Type.GET_QUERY_RESULT, this.channelId, this.txId, requestPayload);
        ByteString response = this.handler.invoke(requestMessage);
        return new QueryResultsIteratorWithMetadataImpl<KeyValue>(this.handler, this.channelId, this.txId, response, this.queryResultBytesToKv.andThen(KeyValueImpl::new));
    }

    @Override
    public QueryResultsIterator<KeyModification> getHistoryForKey(String key) {
        ByteString requestPayload = ChaincodeShim.GetQueryResult.newBuilder().setCollection(UNSPECIFIED_END_KEY).setQuery(key).build().toByteString();
        ChaincodeShim.ChaincodeMessage requestMessage = ChaincodeMessageFactory.newEventMessage(ChaincodeShim.ChaincodeMessage.Type.GET_HISTORY_FOR_KEY, this.channelId, this.txId, requestPayload);
        ByteString response = this.handler.invoke(requestMessage);
        return new QueryResultsIteratorImpl<KeyModification>(this.handler, this.channelId, this.txId, response, this.queryResultBytesToKeyModification.andThen(KeyModificationImpl::new));
    }

    @Override
    public byte[] getPrivateData(String collection, String key) {
        this.validateCollection(collection);
        return this.handler.invoke(ChaincodeMessageFactory.newGetStateEventMessage(this.channelId, this.txId, collection, key)).toByteArray();
    }

    @Override
    public byte[] getPrivateDataHash(String collection, String key) {
        this.validateCollection(collection);
        ByteString requestPayload = ChaincodeShim.GetState.newBuilder().setCollection(collection).setKey(key).build().toByteString();
        ChaincodeShim.ChaincodeMessage requestMessage = ChaincodeMessageFactory.newEventMessage(ChaincodeShim.ChaincodeMessage.Type.GET_PRIVATE_DATA_HASH, this.channelId, this.txId, requestPayload);
        return this.handler.invoke(requestMessage).toByteArray();
    }

    @Override
    public byte[] getPrivateDataValidationParameter(String collection, String key) {
        this.validateCollection(collection);
        ByteString payload = this.handler.invoke(ChaincodeMessageFactory.newGetStateMetadataEventMessage(this.channelId, this.txId, collection, key));
        try {
            ChaincodeShim.StateMetadataResult stateMetadataResult = ChaincodeShim.StateMetadataResult.parseFrom((ByteString)payload);
            HashMap stateMetadataMap = new HashMap();
            stateMetadataResult.getEntriesList().forEach(entry -> stateMetadataMap.put(entry.getMetakey(), entry.getValue()));
            if (stateMetadataMap.containsKey(TransactionPackage.MetaDataKeys.VALIDATION_PARAMETER.toString())) {
                return ((ByteString)stateMetadataMap.get(TransactionPackage.MetaDataKeys.VALIDATION_PARAMETER.toString())).toByteArray();
            }
        }
        catch (InvalidProtocolBufferException e) {
            LOGGER.severe(String.format("[%-8.8s] unmarshalling error", this.txId));
            throw new RuntimeException("Error unmarshalling StateMetadataResult.", e);
        }
        return null;
    }

    @Override
    public void putPrivateData(String collection, String key, byte[] value) {
        this.validateKey(key);
        this.validateCollection(collection);
        this.handler.invoke(ChaincodeMessageFactory.newPutStateEventMessage(this.channelId, this.txId, collection, key, ByteString.copyFrom((byte[])value)));
    }

    @Override
    public void setPrivateDataValidationParameter(String collection, String key, byte[] value) {
        this.validateKey(key);
        this.validateCollection(collection);
        ChaincodeShim.ChaincodeMessage msg = ChaincodeMessageFactory.newPutStateMetadataEventMessage(this.channelId, this.txId, collection, key, TransactionPackage.MetaDataKeys.VALIDATION_PARAMETER.toString(), ByteString.copyFrom((byte[])value));
        this.handler.invoke(msg);
    }

    @Override
    public void delPrivateData(String collection, String key) {
        this.validateCollection(collection);
        ChaincodeShim.ChaincodeMessage msg = ChaincodeMessageFactory.newDeleteStateEventMessage(this.channelId, this.txId, collection, key);
        this.handler.invoke(msg);
    }

    @Override
    public QueryResultsIterator<KeyValue> getPrivateDataByRange(String collection, String startKey, String endKey) {
        String start = startKey;
        String end = endKey;
        this.validateCollection(collection);
        if (startKey == null || startKey.isEmpty()) {
            start = UNSPECIFIED_START_KEY;
        }
        if (endKey == null) {
            end = UNSPECIFIED_END_KEY;
        }
        CompositeKey.validateSimpleKeys(start, end);
        return this.executeGetStateByRange(collection, start, end);
    }

    @Override
    public QueryResultsIterator<KeyValue> getPrivateDataByPartialCompositeKey(String collection, String compositeKey) {
        CompositeKey key = compositeKey == null ? new CompositeKey(UNSPECIFIED_END_KEY, new String[0]) : (compositeKey.startsWith(CompositeKey.NAMESPACE) ? CompositeKey.parseCompositeKey(compositeKey) : new CompositeKey(compositeKey, new String[0]));
        return this.getPrivateDataByPartialCompositeKey(collection, key);
    }

    @Override
    public QueryResultsIterator<KeyValue> getPrivateDataByPartialCompositeKey(String collection, CompositeKey compositeKey) {
        String cKeyAsString = compositeKey == null ? new CompositeKey(UNSPECIFIED_START_KEY, new String[0]).toString() : compositeKey.toString();
        return this.executeGetStateByRange(collection, cKeyAsString, cKeyAsString + MAX_UNICODE_RUNE);
    }

    @Override
    public QueryResultsIterator<KeyValue> getPrivateDataByPartialCompositeKey(String collection, String objectType, String ... attributes) {
        return this.getPrivateDataByPartialCompositeKey(collection, new CompositeKey(objectType, attributes));
    }

    @Override
    public QueryResultsIterator<KeyValue> getPrivateDataQueryResult(String collection, String query) {
        this.validateCollection(collection);
        ByteString requestPayload = ChaincodeShim.GetQueryResult.newBuilder().setCollection(collection).setQuery(query).build().toByteString();
        ChaincodeShim.ChaincodeMessage requestMessage = ChaincodeMessageFactory.newEventMessage(ChaincodeShim.ChaincodeMessage.Type.GET_QUERY_RESULT, this.channelId, this.txId, requestPayload);
        ByteString response = this.handler.invoke(requestMessage);
        return new QueryResultsIteratorImpl<KeyValue>(this.handler, this.channelId, this.txId, response, this.queryResultBytesToKv.andThen(KeyValueImpl::new));
    }

    @Override
    public Chaincode.Response invokeChaincode(String chaincodeName, List<byte[]> args, String channel) {
        String compositeName = channel != null && !channel.trim().isEmpty() ? chaincodeName + "/" + channel : chaincodeName;
        ByteString invocationSpecPayload = Chaincode.ChaincodeSpec.newBuilder().setChaincodeId(Chaincode.ChaincodeID.newBuilder().setName(compositeName).build()).setInput(Chaincode.ChaincodeInput.newBuilder().addAllArgs((Iterable)args.stream().map(ByteString::copyFrom).collect(Collectors.toList())).build()).build().toByteString();
        ChaincodeShim.ChaincodeMessage invokeChaincodeMessage = ChaincodeMessageFactory.newInvokeChaincodeMessage(this.channelId, this.txId, invocationSpecPayload);
        ByteString response = this.handler.invoke(invokeChaincodeMessage);
        try {
            ChaincodeShim.ChaincodeMessage responseMessage = ChaincodeShim.ChaincodeMessage.parseFrom((ByteString)response);
            LOGGER.fine(String.format("[%-8.8s] %s response received from other chaincode.", this.txId, responseMessage.getType()));
            if (responseMessage.getType() == ChaincodeShim.ChaincodeMessage.Type.COMPLETED) {
                ProposalResponsePackage.Response r = ProposalResponsePackage.Response.parseFrom((ByteString)responseMessage.getPayload());
                return new Chaincode.Response(Chaincode.Response.Status.forCode(r.getStatus()), r.getMessage(), r.getPayload() == null ? null : r.getPayload().toByteArray());
            }
            String message = responseMessage.getPayload().toStringUtf8();
            return new Chaincode.Response(Chaincode.Response.Status.INTERNAL_SERVER_ERROR, message, null);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ProposalPackage.SignedProposal getSignedProposal() {
        return this.signedProposal;
    }

    @Override
    public Instant getTxTimestamp() {
        return this.txTimestamp;
    }

    @Override
    public byte[] getCreator() {
        if (this.creator == null) {
            return null;
        }
        return this.creator.toByteArray();
    }

    @Override
    public Map<String, byte[]> getTransient() {
        return this.transientMap.entrySet().stream().collect(Collectors.toMap(x -> (String)x.getKey(), x -> ((ByteString)x.getValue()).toByteArray()));
    }

    @Override
    public byte[] getBinding() {
        return this.binding;
    }

    private void validateKey(String key) {
        if (key == null) {
            throw new NullPointerException("key cannot be null");
        }
        if (key.length() == 0) {
            throw new IllegalArgumentException("key cannot not be an empty string");
        }
    }

    private void validateCollection(String collection) {
        if (collection == null) {
            throw new NullPointerException("collection cannot be null");
        }
        if (collection.isEmpty()) {
            throw new IllegalArgumentException("collection must not be an empty string");
        }
    }

    @Override
    public String getMspId() {
        if (System.getenv().containsKey(CORE_PEER_LOCALMSPID)) {
            return System.getenv(CORE_PEER_LOCALMSPID);
        }
        throw new RuntimeException("CORE_PEER_LOCALMSPID is unset in chaincode process");
    }
}

