/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.shim.impl;

import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.stub.StreamObserver;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.logging.Logger;
import org.hyperledger.fabric.Logging;
import org.hyperledger.fabric.protos.peer.ChaincodeShim;
import org.hyperledger.fabric.protos.peer.ChaincodeSupportGrpc;
import org.hyperledger.fabric.shim.impl.InvocationTaskManager;

public class ChaincodeSupportClient {
    private static Logger logger = Logger.getLogger(ChaincodeSupportClient.class.getName());
    private static Logger perflogger = Logger.getLogger("org.hyperledger.Performance");
    private final ManagedChannel channel;
    private final ChaincodeSupportGrpc.ChaincodeSupportStub stub;
    private static final int DEFAULT_TIMEOUT = 5;

    public ChaincodeSupportClient(ManagedChannelBuilder<?> channelBuilder) {
        this.channel = channelBuilder.build();
        this.stub = ChaincodeSupportGrpc.newStub((Channel)this.channel);
    }

    private void shutdown(InvocationTaskManager itm) {
        itm.shutdown();
        try {
            this.channel.shutdown();
            if (!this.channel.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.channel.shutdownNow();
                if (!this.channel.awaitTermination(5L, TimeUnit.SECONDS)) {
                    System.err.println("Channel did not terminate");
                }
            }
        }
        catch (InterruptedException e) {
            this.channel.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public void start(final InvocationTaskManager itm) {
        final Consumer<ChaincodeShim.ChaincodeMessage> consumer = itm::onChaincodeMessage;
        logger.info("making the grpc call");
        final StreamObserver requestObserver = this.stub.register((StreamObserver)new StreamObserver<ChaincodeShim.ChaincodeMessage>(){
            private String txid;

            public void onNext(ChaincodeShim.ChaincodeMessage chaincodeMessage) {
                this.txid = chaincodeMessage.getTxid();
                consumer.accept(chaincodeMessage);
            }

            public void onError(Throwable t) {
                logger.severe(() -> "Last txid=" + this.txid + " An error occurred on the chaincode stream. Shutting down the chaincode stream." + Logging.formatError(t));
                ChaincodeSupportClient.this.shutdown(itm);
            }

            public void onCompleted() {
                logger.severe("Chaincode stream is complete. Shutting down the chaincode stream.");
                ChaincodeSupportClient.this.shutdown(itm);
            }
        });
        Consumer<ChaincodeShim.ChaincodeMessage> c = new Consumer<ChaincodeShim.ChaincodeMessage>(){
            private final ReentrantLock lock = new ReentrantLock(true);

            @Override
            public void accept(ChaincodeShim.ChaincodeMessage t) {
                this.lock.lock();
                perflogger.fine(() -> "> sendToPeer TX::" + t.getTxid());
                requestObserver.onNext((Object)t);
                perflogger.fine(() -> "< sendToPeer TX::" + t.getTxid());
                this.lock.unlock();
            }
        };
        itm.setResponseConsumer(c).register();
    }
}

